plugins {
    id("org.jetbrains.compose")
    id("org.jetbrains.kotlin.plugin.compose")
    id("com.android.application") version "8.12.0"
    kotlin("android")
    distribution
}

repositories {
    maven { url = uri("https://archiva.macrofocus.com/repository/public/") }
    maven { url = uri("https://archiva.macrofocus.com/repository/snapshots/") }
    mavenCentral()

    maven("https://maven.pkg.jetbrains.space/public/p/compose/dev/")
    maven { url = uri("https://androidx.dev/storage/compose-compiler/repository/") }

    google()
}

val frameworkAttribute = Attribute.of("mkui", String::class.java)
//configurations.all {
//    afterEvaluate {
//        attributes.attribute(frameworkAttribute, "compose")
//    }
//}
dependencies {
    val localDependencies: String? by project
    if(localDependencies != null && localDependencies.toBoolean()) {
        implementation(project(":macrofocus-common"))
        implementation(project(":mkui"))
        implementation(project(":molap"))
        implementation(project(":treemap"))
    } else {
        val macrofocusVersion: String by project
        //    implementation("org.macrofocus", "macrofocus-common", "$macrofocusVersion", "jvmRuntime")
        //    implementation("org.molap", "molap", "$macrofocusVersion", "jvmRuntime")
        //    implementation("org.macrofocus", "mkui", "$macrofocusVersion", "swingRuntime")
        //    implementation("com.treemap", "treemap", "$macrofocusVersion", "swingRuntime")

        implementation("org.macrofocus:macrofocus-common:$macrofocusVersion")
        implementation("org.molap:molap:$macrofocusVersion")
        implementation("org.mkui:mkui:$macrofocusVersion")
        implementation("com.treemap:treemap:$macrofocusVersion")
    }

    api(compose.runtime)
    api(compose.foundation)
    api(compose.material)

    api("androidx.appcompat:appcompat:1.7.1")
    api("androidx.core:core-ktx:1.17.0")

    implementation("androidx.activity:activity-compose:1.12.2")
}

android {
    namespace = "com.treemap.demo"

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    compileSdk = 36
    defaultConfig {
        applicationId = "com.treemap.app"
        minSdk = 32
        targetSdk = 33
        versionCode = 1
        versionName = "1.0"
    }
    buildTypes {
        getByName("release") {
            isMinifyEnabled = false
        }
    }
}

distributions {
    main {
//        distributionBaseName.set("someName")
        contents {
            from(".") {
                exclude(".gradle/**")
                exclude("build/**")
            }

//            from("TreeMap API for Kotlin-Swing Developer Guide.pdf")
//            from("../treemap/build/dokka/html/") {
//                into("dokka")
//            }
        }
    }
}

compose {
//    val composeCompilerVersion: String? by project
//    composeCompilerVersion?.let { this.kotlinCompilerPlugin.set("androidx.compose.compiler:compiler:$it") }
}