package com.treemap.demo

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.treemap.AbstractTreeMap
import com.treemap.DefaultTreeMap
import com.treemap.RenderingFactory
import org.mkui.labeling.EnhancedLabel
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame
import org.molap.dataframe.JsonDataFrame

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            Demo()
        }
    }
}

@Composable
fun Demo() {
    val inputStream = MainActivity::class.java.getResourceAsStream("Forbes Global 2000 - 2021.json")!!
    val dataFrame: DataFrame<Int, String, Any?> = JsonDataFrame.fromInputStream(inputStream)
    val treeMap: AbstractTreeMap<Int, String> = DefaultTreeMap(dataFrame)
    val model = treeMap.model
    val settings = model!!.settings

    // General
    settings.rendering = RenderingFactory.FLAT

    // Group by
    settings.groupByColumns = listOf("Sector", "Industry")

    // Size
    settings.sizeColumn = "Market Value"

    // Color
    settings.colorColumn = "Profits"
    val profitsSettings = settings.getColumnSettings("Profits")
    val negpos = PaletteFactory.instance["negpos"]!!.getPalette()
    val colorMap = model.getColorMap("Profits")
    colorMap!!.palette = negpos
    colorMap.interval!!.setValue(-63.93, 127.86)

    // Label
    val companySettings = settings.getColumnSettings("Company")
//        companySettings.setLabelingFont(CPFont(Font("Helvetica", Font.PLAIN, 9)).nativeFont) // 9 points is the minimum size that will be displayed
    companySettings.setLabelingMinimumCharactersToDisplay(5)
    companySettings.setLabelingResizeTextToFitShape(true)
    companySettings.setLabelingVerticalAlignment(EnhancedLabel.CENTER)
    companySettings.setLabelingHorizontalAlignment(EnhancedLabel.CENTER)

    treeMap.view!!.isShowTiming = false

    MaterialTheme {
        Column(Modifier.fillMaxSize(), Arrangement.spacedBy(5.dp)) {
            treeMap.view!!.component.nativeComponent.invoke()
        }
    }
}

