plugins {
    kotlin("multiplatform")
    id("org.jetbrains.compose")
    id("org.jetbrains.kotlin.plugin.compose")
    distribution
}

//val local = Properties()
//val localProperties: File = rootProject.file("local.properties")
//if (localProperties.exists()) {
//    localProperties.inputStream().use { local.load(it) }
//}

repositories {
    maven { url = uri("https://archiva.macrofocus.com/repository/public/") }
    maven { url = uri("https://archiva.macrofocus.com/repository/snapshots/") }
    mavenCentral()

    maven("https://maven.pkg.jetbrains.space/public/p/compose/dev/")
    maven { url = uri("https://androidx.dev/storage/compose-compiler/repository/") }

    google()
}

//val frameworkAttribute = Attribute.of("mkui", String::class.java)
//configurations.all {
//    afterEvaluate {
//        attributes.attribute(frameworkAttribute, "compose")
//    }
//}

kotlin {
    // Used to disambiguate same-platform targets
    val frameworkAttribute = Attribute.of("mkui", String::class.java)
    kotlin {
        jvm("compose") {
//            attributes.attribute(frameworkAttribute, "compose")
        }
    }

    sourceSets {
        val composeMain by getting {
            dependencies {
                api(compose.runtime)
                api(compose.foundation)
                api(compose.material)
                @OptIn(org.jetbrains.compose.ExperimentalComposeLibrary::class)
                api(compose.material3)
                api(compose.materialIconsExtended)
                implementation(compose.desktop.currentOs)

                val localDependencies: String? by project
                if(localDependencies != null && localDependencies.toBoolean()) {
                    implementation(project(":macrofocus-common"))
                    implementation(project(":mkui"))
                    implementation(project(":molap"))
                    implementation(project(":treemap"))
                } else {
                    val macrofocusVersion: String by project

                    implementation("org.macrofocus:macrofocus-common:$macrofocusVersion")
                    implementation("org.molap:molap:$macrofocusVersion")
                    implementation("org.mkui:mkui-compose:$macrofocusVersion")
                    implementation("com.treemap:treemap-compose:$macrofocusVersion")
                }
            }
        }
    }
}

//application {
//    mainClass.set("Demo")
//}

distributions {
    main {
//        distributionBaseName.set("someName")
        contents {
            from(".") {
                exclude(".gradle/**")
                exclude("build/**")
            }

//            from("TreeMap API for Kotlin-Swing Developer Guide.pdf")
//            from("../treemap/build/dokka/html/") {
//                into("dokka")
//            }
        }
    }
}

compose {
//    val composeCompilerVersion: String? by project
//    composeCompilerVersion?.let { this.kotlinCompilerPlugin.set("androidx.compose.compiler:compiler:$it") }

    desktop {
        application {
    //        disableDefaultConfiguration()
    //        from(kotlin.targets["compose"])

            mainClass = "DemoKt"

            nativeDistributions {
                targetFormats(
                    org.jetbrains.compose.desktop.application.dsl.TargetFormat.Dmg
    //                org.jetbrains.compose.desktop.application.dsl.TargetFormat.Msi,
    //                org.jetbrains.compose.desktop.application.dsl.TargetFormat.Deb
                )
            }
        }
    }
}