/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Geometry;
import org.mkui.geom.Point2D;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\n\u0010\u0018\u001a\u00020\u0019H\u0096\u0080\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/mkui/geom/Ellipse;", "Lorg/mkui/geom/Geometry;", "<init>", "()V", "x", "", "y", "width", "height", "(DDDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "getWidth", "setWidth", "getHeight", "setHeight", "contains", "", "point", "Lorg/mkui/geom/Point2D;", "toString", "", "mkui"})
@StabilityInferred(parameters=0)
public final class Ellipse
implements Geometry {
    private double x;
    private double y;
    private double width;
    private double height;
    public static final int $stable = 8;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getWidth() {
        return this.width;
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public Ellipse() {
    }

    public Ellipse(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double ellw = this.width;
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (point.getX() - this.x) / ellw - 0.5;
        double ellh = this.height;
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (point.getY() - this.y) / ellh - 0.5;
        return normx * normx + normy * normy < 0.25;
    }

    @NotNull
    public String toString() {
        return "Ellipse{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "}";
    }
}

