/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.annotation.Synchronized;
import com.macrofocus.common.collection.ArrayFnKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Curve;
import org.mkui.geom.FlatteningPathIterator;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\b'\u0018\u0000 O2\u00020\u0001:\u0003MNOB\t\b\u0010\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H&J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00012\b\u0010#\u001a\u0004\u0018\u00010\u001cH&J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H&J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H&J(\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 H&J8\u0010+\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020 H&J\b\u0010.\u001a\u00020\u001eH\u0007J\u0018\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0005H&J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000201H&J\u0012\u0010:\u001a\u0004\u0018\u0001072\u0006\u0010;\u001a\u00020\u0005H&J\b\u0010<\u001a\u00020\u001eH\u0007J\u0011\u0010=\u001a\u0002012\u0006\u0010>\u001a\u000207H\u0096\u0002J\u0016\u0010=\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0018\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 H&J\u0010\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020DH\u0016J&\u0010B\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 J\u0011\u0010=\u001a\u0002012\u0006\u0010G\u001a\u00020DH\u0086\u0002J&\u0010=\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 J(\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020 2\u0006\u0010L\u001a\u00020 H&R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0013\u00106\u001a\u0004\u0018\u0001078G\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006P"}, d2={"Lorg/mkui/geom/Path2D;", "Lorg/mkui/geom/Shape;", "<init>", "()V", "rule", "", "initialTypes", "(II)V", "pointTypes", "", "getPointTypes", "()[B", "setPointTypes", "([B)V", "numTypes", "getNumTypes", "()I", "setNumTypes", "(I)V", "numCoords", "getNumCoords", "setNumCoords", "windingRule", "getWindingRule", "setWindingRule", "cloneCoordsDouble", "", "at", "Lorg/mkui/geom/AffineTransform;", "append", "", "x", "", "y", "createTransformedShape", "transform", "moveTo", "lineTo", "quadTo", "x1", "y1", "x2", "y2", "curveTo", "x3", "y3", "closePath", "needRoom", "needMove", "", "newCoords", "pi", "Lorg/mkui/geom/PathIterator;", "connect", "currentPoint", "Lorg/mkui/geom/Point2D;", "getCurrentPoint", "()Lorg/mkui/geom/Point2D;", "getPoint", "coordindex", "reset", "contains", "point", "pointCrossings", "px", "py", "intersects", "rect", "Lorg/mkui/geom/Rectangle2D;", "w", "h", "r", "rectCrossings", "rxmin", "rymin", "rxmax", "rymax", "Double", "Iterator", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public abstract class Path2D
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private transient byte[] pointTypes;
    private transient int numTypes;
    private transient int numCoords;
    private transient int windingRule;
    public static final int $stable = 8;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final int INIT_SIZE = 20;
    public static final int EXPAND_MAX = 500;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;

    @NotNull
    public final byte[] getPointTypes() {
        return this.pointTypes;
    }

    public final void setPointTypes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.pointTypes = byArray;
    }

    public final int getNumTypes() {
        return this.numTypes;
    }

    public final void setNumTypes(int n) {
        this.numTypes = n;
    }

    public final int getNumCoords() {
        return this.numCoords;
    }

    public final void setNumCoords(int n) {
        this.numCoords = n;
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        this.windingRule = n;
    }

    public Path2D() {
        this.pointTypes = new byte[0];
    }

    public Path2D(int rule, int initialTypes) {
        this.windingRule = rule;
        this.pointTypes = new byte[initialTypes];
    }

    @NotNull
    public abstract double[] cloneCoordsDouble(@Nullable AffineTransform var1);

    public abstract void append(double var1, double var3);

    @Nullable
    public abstract Shape createTransformedShape(@Nullable AffineTransform var1);

    public abstract void moveTo(double var1, double var3);

    public abstract void lineTo(double var1, double var3);

    public abstract void quadTo(double var1, double var3, double var5, double var7);

    public abstract void curveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    @Synchronized
    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            int n = this.numTypes;
            this.numTypes = n + 1;
            this.pointTypes[n] = 4;
        }
    }

    public abstract void needRoom(boolean var1, int var2);

    public abstract void append(@NotNull PathIterator var1, boolean var2);

    @Synchronized
    @Nullable
    public final Point2D getCurrentPoint() {
        int index = this.numCoords;
        if (this.numTypes < 1 || index < 1) {
            return null;
        }
        if (this.pointTypes[this.numTypes - 1] == 4) {
            byte by;
            for (int i = this.numTypes - 2; 0 < i && (by = this.pointTypes[i]) != 0; --i) {
                if (by == 1) {
                    index -= 2;
                    continue;
                }
                if (by == 2) {
                    index -= 4;
                    continue;
                }
                if (by == 3) {
                    index -= 6;
                    continue;
                }
                if (by != 4) continue;
            }
        }
        return this.getPoint(index - 2);
    }

    @Nullable
    public abstract Point2D getPoint(int var1);

    @Synchronized
    public final void reset() {
        this.numTypes = this.numCoords = 0;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.getX(), point.getY());
    }

    public final boolean contains(double x, double y) {
        boolean bl;
        if (x * 0.0 + y * 0.0 == 0.0) {
            int mask;
            if (this.numTypes < 2) {
                return false;
            }
            int n = mask = this.windingRule == 1 ? -1 : 1;
            bl = (this.pointCrossings(x, y) & mask) != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int pointCrossings(double var1, double var3);

    @Override
    public boolean intersects(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    public abstract int rectCrossings(double var1, double var3, double var5, double var7);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/mkui/geom/Path2D$Companion;", "", "<init>", "()V", "WIND_EVEN_ODD", "", "WIND_NON_ZERO", "INIT_SIZE", "EXPAND_MAX", "SEG_MOVETO", "", "SEG_LINETO", "SEG_QUADTO", "SEG_CUBICTO", "SEG_CLOSE", "contains", "", "pi", "Lorg/mkui/geom/PathIterator;", "p", "Lorg/mkui/geom/Point2D;", "x", "", "y", "r", "Lorg/mkui/geom/Rectangle2D;", "w", "h", "intersects", "copyOf", "", "original", "newLength", "", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean contains(@NotNull PathIterator pi, @NotNull Point2D p) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.contains(pi, p.getX(), p.getY());
        }

        public final boolean contains(@NotNull PathIterator pi, double x, double y) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (x * 0.0 + y * 0.0 == 0.0) {
                int mask = pi.getWindingRule() == 1 ? -1 : 1;
                int cross = Curve.Companion.pointCrossingsForPath(pi, x, y);
                bl = (cross & mask) != 0;
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean contains(@NotNull PathIterator pi, @NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return this.contains(pi, r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        public final boolean contains(@NotNull PathIterator pi, double x, double y, double w, double h) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
                return false;
            }
            if (w <= 0.0 || h <= 0.0) {
                return false;
            }
            int mask = pi.getWindingRule() == 1 ? -1 : 2;
            int crossings = Curve.Companion.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
        }

        public final boolean intersects(@NotNull PathIterator pi, @NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return this.intersects(pi, r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        public final boolean intersects(@NotNull PathIterator pi, double x, double y, double w, double h) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
                return false;
            }
            if (w <= 0.0 || h <= 0.0) {
                return false;
            }
            int mask = pi.getWindingRule() == 1 ? -1 : 2;
            int crossings = Curve.Companion.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
        }

        @NotNull
        public final byte[] copyOf(@NotNull byte[] original, int newLength) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            byte[] copy = new byte[newLength];
            ArrayFnKt.arraycopy((byte[])original, (int)0, (byte[])copy, (int)0, (int)Math.min(original.length, newLength));
            return copy;
        }

        @NotNull
        public final int[] copyOf(@NotNull int[] original, int newLength) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            int[] copy = new int[newLength];
            ArrayFnKt.arraycopy((int[])original, (int)0, (int[])copy, (int)0, (int)Math.min(original.length, newLength));
            return copy;
        }

        @NotNull
        public final double[] copyOf(@NotNull double[] original, int newLength) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            double[] copy = new double[newLength];
            ArrayFnKt.arraycopy((double[])original, (int)0, (double[])copy, (int)0, (int)Math.min(original.length, newLength));
            return copy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001:\u0002CDB\u001d\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0005\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0005\u0010\u0010J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0016J(\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u0014\u0010,\u001a\u0004\u0018\u00010\n2\b\u0010-\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010.\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0017J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0017J(\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001bH\u0017J8\u00105\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001bH\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\"H\u0016J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010=\u001a\u00020:H\u0007J\u0012\u0010?\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u001bH\u0016R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010>\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006E"}, d2={"Lorg/mkui/geom/Path2D$Double;", "Lorg/mkui/geom/Path2D;", "rule", "", "initialCapacity", "<init>", "(II)V", "p2d", "(Lorg/mkui/geom/Path2D;)V", "s", "Lorg/mkui/geom/Shape;", "at", "Lorg/mkui/geom/AffineTransform;", "(Lorg/mkui/geom/Shape;Lorg/mkui/geom/AffineTransform;)V", "pi", "Lorg/mkui/geom/PathIterator;", "(Lorg/mkui/geom/PathIterator;)V", "doubleCoords", "", "getDoubleCoords", "()[D", "setDoubleCoords", "([D)V", "cloneCoordsDouble", "append", "", "x", "", "y", "getPoint", "Lorg/mkui/geom/Point2D;", "coordindex", "needRoom", "needMove", "", "newCoords", "pointCrossings", "px", "py", "rectCrossings", "rxmin", "rymin", "rxmax", "rymax", "createTransformedShape", "transform", "moveTo", "lineTo", "quadTo", "x1", "y1", "x2", "y2", "curveTo", "x3", "y3", "connect", "bounds2D", "Lorg/mkui/geom/Rectangle2D;", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "computeBounds2D", "pathIterator", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "getFlattenPathIterator", "flatness", "CopyIterator", "TxIterator", "mkui"})
    @StabilityInferred(parameters=0)
    public static class Double
    extends Path2D {
        @NotNull
        private transient double[] doubleCoords;
        public static final int $stable = 8;

        @NotNull
        public final double[] getDoubleCoords() {
            return this.doubleCoords;
        }

        public final void setDoubleCoords(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.doubleCoords = dArray;
        }

        public Double(int rule, int initialCapacity) {
            super(rule, initialCapacity);
            this.doubleCoords = new double[initialCapacity * 2];
        }

        public /* synthetic */ Double(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 1;
            }
            if ((n3 & 2) != 0) {
                n2 = 20;
            }
            this(n, n2);
        }

        public Double(@NotNull Path2D p2d) {
            Intrinsics.checkNotNullParameter((Object)p2d, (String)"p2d");
            this.setWindingRule(p2d.getWindingRule());
            this.setNumTypes(p2d.getNumTypes());
            this.setPointTypes(Companion.copyOf(p2d.getPointTypes(), p2d.getPointTypes().length));
            this.setNumCoords(p2d.getNumCoords());
            this.doubleCoords = p2d.cloneCoordsDouble(null);
        }

        public Double(@NotNull Shape s, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (s instanceof Path2D) {
                this.setWindingRule(((Path2D)s).getWindingRule());
                this.setNumTypes(((Path2D)s).getNumTypes());
                this.setPointTypes(Companion.copyOf(((Path2D)s).getPointTypes(), ((Path2D)s).getNumTypes()));
                this.setNumCoords(((Path2D)s).getNumCoords());
                this.doubleCoords = ((Path2D)s).cloneCoordsDouble(at);
            } else {
                PathIterator pi = s.getPathIterator(at);
                this.setWindingRule(pi.getWindingRule());
                this.setPointTypes(new byte[20]);
                this.doubleCoords = new double[40];
                this.append(pi, false);
            }
        }

        public Double(@NotNull PathIterator pi) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            this.setWindingRule(pi.getWindingRule());
            this.setPointTypes(new byte[20]);
            this.doubleCoords = new double[40];
            this.append(pi, false);
        }

        @Override
        @NotNull
        public double[] cloneCoordsDouble(@Nullable AffineTransform at) {
            double[] ret = null;
            if (at == null) {
                ret = Companion.copyOf(this.doubleCoords, this.getNumCoords());
            } else {
                ret = new double[this.getNumCoords()];
                at.transform(this.doubleCoords, 0, ret, 0, this.getNumCoords() / 2);
            }
            return ret;
        }

        @Override
        public void append(double x, double y) {
            int n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y;
        }

        @Override
        @NotNull
        public Point2D getPoint(int coordindex) {
            return new Point2D.Double(this.doubleCoords[coordindex], this.doubleCoords[coordindex + 1]);
        }

        @Override
        public void needRoom(boolean needMove, int newCoords) {
            int grow;
            if (!(!needMove || this.getNumTypes() != 0)) {
                boolean $i$a$-check-Path2D$Double$needRoom$22 = false;
                String $i$a$-check-Path2D$Double$needRoom$22 = "missing initial moveto in path definition";
                throw new IllegalStateException($i$a$-check-Path2D$Double$needRoom$22.toString());
            }
            int size = this.getPointTypes().length;
            if (this.getNumTypes() >= size) {
                grow = size;
                if (grow > 500) {
                    grow = 500;
                }
                this.setPointTypes(Companion.copyOf(this.getPointTypes(), size + grow));
            }
            size = this.doubleCoords.length;
            if (this.getNumCoords() + newCoords > size) {
                grow = size;
                if (grow > 1000) {
                    grow = 1000;
                }
                if (grow < newCoords) {
                    grow = newCoords;
                }
                this.doubleCoords = Companion.copyOf(this.doubleCoords, size + grow);
            }
        }

        @Override
        public int pointCrossings(double px, double py) {
            if (this.getNumTypes() == 0) {
                return 0;
            }
            double movx = 0.0;
            double[] coords = this.doubleCoords;
            movx = coords[0];
            double curx = 0.0;
            curx = movx;
            double movy = 0.0;
            movy = coords[1];
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            int ci = 0;
            ci = 2;
            int n = this.getNumTypes();
            for (int i = 1; i < n; ++i) {
                double d;
                double d2;
                double d3;
                int n2;
                Curve.Companion companion;
                double d4;
                double d5;
                double d6;
                double d7;
                double endy = 0.0;
                double endx = 0.0;
                byte by = this.getPointTypes()[i];
                if (by == 0) {
                    if (!(cury == movy)) {
                        crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    Double $this$pointCrossings_u24lambda_u240 = this;
                    boolean bl = false;
                    int n3 = ci;
                    ci = n3 + 1;
                    movx = curx = coords[n3];
                    Double $this$pointCrossings_u24lambda_u241 = this;
                    boolean bl2 = false;
                    n3 = ci;
                    ci = n3 + 1;
                    movy = cury = coords[n3];
                    continue;
                }
                if (by == 1) {
                    double it;
                    double d8;
                    int n4 = ci;
                    ci = n4 + 1;
                    double $this$pointCrossings_u24lambda_u241 = d8 = coords[n4];
                    d7 = cury;
                    d6 = curx;
                    d5 = py;
                    d4 = px;
                    companion = Curve.Companion;
                    n2 = crossings;
                    boolean bl = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n5 = ci;
                    ci = n5 + 1;
                    it = d3 = coords[n5];
                    d2 = d8;
                    boolean bl3 = false;
                    endy = it;
                    Unit unit2 = Unit.INSTANCE;
                    crossings = n2 + companion.pointCrossingsForLine(d4, d5, d6, d7, d2, d3);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by == 2) {
                    double d9;
                    int n6 = ci;
                    ci = n6 + 1;
                    double d10 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double d11 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double it = d9 = coords[n6];
                    double d12 = d11;
                    d2 = d10;
                    d7 = cury;
                    d6 = curx;
                    d5 = py;
                    d4 = px;
                    companion = Curve.Companion;
                    n2 = crossings;
                    boolean bl = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n7 = ci;
                    ci = n7 + 1;
                    it = d3 = coords[n7];
                    d = d9;
                    boolean bl4 = false;
                    endy = it;
                    Unit unit3 = Unit.INSTANCE;
                    crossings = n2 + companion.pointCrossingsForQuad(d4, d5, d6, d7, d2, d12, d, d3, 0);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by == 3) {
                    double d13;
                    int n8 = ci;
                    ci = n8 + 1;
                    double d14 = coords[n8];
                    n8 = ci;
                    ci = n8 + 1;
                    double d15 = coords[n8];
                    n8 = ci;
                    ci = n8 + 1;
                    double d16 = coords[n8];
                    n8 = ci;
                    ci = n8 + 1;
                    double d17 = coords[n8];
                    n8 = ci;
                    ci = n8 + 1;
                    double it = d13 = coords[n8];
                    double d18 = d17;
                    d = d16;
                    double d19 = d15;
                    d2 = d14;
                    d7 = cury;
                    d6 = curx;
                    d5 = py;
                    d4 = px;
                    companion = Curve.Companion;
                    n2 = crossings;
                    boolean bl = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n9 = ci;
                    ci = n9 + 1;
                    it = d3 = coords[n9];
                    double d20 = d13;
                    boolean bl5 = false;
                    endy = it;
                    Unit unit4 = Unit.INSTANCE;
                    crossings = n2 + companion.pointCrossingsForCubic(d4, d5, d6, d7, d2, d19, d, d18, d20, d3, 0);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by != 4) continue;
                if (!(cury == movy)) {
                    crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                }
                curx = movx;
                cury = movy;
            }
            if (!(cury == movy)) {
                crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
            }
            return crossings;
        }

        @Override
        public int rectCrossings(double rxmin, double rymin, double rxmax, double rymax) {
            if (this.getNumTypes() == 0) {
                return 0;
            }
            double[] coords = this.doubleCoords;
            double movx = 0.0;
            movx = coords[0];
            double curx = 0.0;
            curx = movx;
            double movy = 0.0;
            movy = coords[1];
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            int ci = 0;
            ci = 2;
            for (int i = 1; crossings != Integer.MIN_VALUE && i < this.getNumTypes(); ++i) {
                double d;
                Curve.Companion companion;
                int n;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double endy = 0.0;
                double endx = 0.0;
                byte by = this.getPointTypes()[i];
                if (by == 0) {
                    if (!(curx == movx) || !(cury == movy)) {
                        crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    Double $this$rectCrossings_u24lambda_u240 = this;
                    boolean bl = false;
                    int n2 = ci;
                    ci = n2 + 1;
                    movx = curx = coords[n2];
                    Double $this$rectCrossings_u24lambda_u241 = this;
                    boolean bl2 = false;
                    n2 = ci;
                    ci = n2 + 1;
                    movy = cury = coords[n2];
                    continue;
                }
                if (by == 1) {
                    int n3 = ci;
                    ci = n3 + 1;
                    endx = coords[n3];
                    n3 = ci;
                    ci = n3 + 1;
                    endy = coords[n3];
                    crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by == 2) {
                    double d10;
                    double it;
                    double d11;
                    int n4 = ci;
                    ci = n4 + 1;
                    double d12 = coords[n4];
                    n4 = ci;
                    ci = n4 + 1;
                    double d13 = coords[n4];
                    n4 = ci;
                    ci = n4 + 1;
                    double $this$rectCrossings_u24lambda_u241 = d11 = coords[n4];
                    d9 = d13;
                    d8 = d12;
                    d7 = cury;
                    d6 = curx;
                    d5 = rymax;
                    d4 = rxmax;
                    d3 = rymin;
                    d2 = rxmin;
                    n = crossings;
                    companion = Curve.Companion;
                    boolean bl = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n5 = ci;
                    ci = n5 + 1;
                    it = d10 = coords[n5];
                    d = d11;
                    boolean bl3 = false;
                    endy = it;
                    Unit unit2 = Unit.INSTANCE;
                    crossings = companion.rectCrossingsForQuad(n, d2, d3, d4, d5, d6, d7, d8, d9, d, d10, 0);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by == 3) {
                    double d14;
                    double d15;
                    int n6 = ci;
                    ci = n6 + 1;
                    double d16 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double d17 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double d18 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double d19 = coords[n6];
                    n6 = ci;
                    ci = n6 + 1;
                    double it = d15 = coords[n6];
                    double d20 = d19;
                    d = d18;
                    d9 = d17;
                    d8 = d16;
                    d7 = cury;
                    d6 = curx;
                    d5 = rymax;
                    d4 = rxmax;
                    d3 = rymin;
                    d2 = rxmin;
                    n = crossings;
                    companion = Curve.Companion;
                    boolean bl = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n7 = ci;
                    ci = n7 + 1;
                    it = d14 = coords[n7];
                    double d21 = d15;
                    boolean bl4 = false;
                    endy = it;
                    Unit unit3 = Unit.INSTANCE;
                    crossings = companion.rectCrossingsForCubic(n, d2, d3, d4, d5, d6, d7, d8, d9, d, d20, d21, d14, 0);
                    curx = endx;
                    cury = endy;
                    continue;
                }
                if (by != 4) continue;
                if (!(curx == movx) || !(cury == movy)) {
                    crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                }
                curx = movx;
                cury = movy;
            }
            if (!(crossings == Integer.MIN_VALUE || curx == movx && cury == movy)) {
                crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
            }
            return crossings;
        }

        @Override
        @Nullable
        public Shape createTransformedShape(@Nullable AffineTransform transform) {
            return null;
        }

        @Override
        @Synchronized
        public void moveTo(double x, double y) {
            if (this.getNumTypes() > 0 && this.getPointTypes()[this.getNumTypes() - 1] == 0) {
                this.doubleCoords[this.getNumCoords() - 2] = x;
                this.doubleCoords[this.getNumCoords() - 1] = y;
            } else {
                this.needRoom(false, 2);
                byte[] byArray = this.getPointTypes();
                int n = this.getNumTypes();
                this.setNumTypes(n + 1);
                byArray[n] = 0;
                n = this.getNumCoords();
                this.setNumCoords(n + 1);
                this.doubleCoords[n] = x;
                n = this.getNumCoords();
                this.setNumCoords(n + 1);
                this.doubleCoords[n] = y;
            }
        }

        @Override
        @Synchronized
        public void lineTo(double x, double y) {
            this.needRoom(true, 2);
            byte[] byArray = this.getPointTypes();
            int n = this.getNumTypes();
            this.setNumTypes(n + 1);
            byArray[n] = 1;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y;
        }

        @Override
        @Synchronized
        public void quadTo(double x1, double y1, double x2, double y2) {
            this.needRoom(true, 4);
            byte[] byArray = this.getPointTypes();
            int n = this.getNumTypes();
            this.setNumTypes(n + 1);
            byArray[n] = 2;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x1;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y1;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x2;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y2;
        }

        @Override
        @Synchronized
        public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.needRoom(true, 6);
            byte[] byArray = this.getPointTypes();
            int n = this.getNumTypes();
            this.setNumTypes(n + 1);
            byArray[n] = 3;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x1;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y1;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x2;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y2;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = x3;
            n = this.getNumCoords();
            this.setNumCoords(n + 1);
            this.doubleCoords[n] = y3;
        }

        @Override
        public void append(@NotNull PathIterator pi, boolean connect) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            boolean connect2 = connect;
            double[] coords = new double[6];
            while (!pi.isDone()) {
                byte by = (byte)pi.currentSegment(coords);
                if (by == 0) {
                    if (!connect2 || this.getNumTypes() < 1 || this.getNumCoords() < 1) {
                        this.moveTo(coords[0], coords[1]);
                    } else if (this.getPointTypes()[this.getNumTypes() - 1] == 4 || !(this.doubleCoords[this.getNumCoords() - 2] == coords[0]) || !(this.doubleCoords[this.getNumCoords() - 1] == coords[1])) {
                        this.lineTo(coords[0], coords[1]);
                    }
                } else if (by == 1) {
                    this.lineTo(coords[0], coords[1]);
                } else if (by == 2) {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                } else if (by == 3) {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                } else if (by == 4) {
                    this.closePath();
                }
                pi.next();
                connect2 = false;
            }
        }

        public final void transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            at.transform(this.doubleCoords, 0, this.doubleCoords, 0, this.getNumCoords() / 2);
        }

        @Override
        @NotNull
        public Rectangle2D getBounds2D() {
            return this.computeBounds2D();
        }

        @Synchronized
        @NotNull
        public final Rectangle2D computeBounds2D() {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            int i = this.getNumCoords();
            if (i > 0) {
                y1 = y2 = this.doubleCoords[--i];
                x1 = x2 = this.doubleCoords[--i];
                while (i > 0) {
                    double x;
                    double y = this.doubleCoords[--i];
                    if ((x = this.doubleCoords[--i]) < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (!(y > y2)) continue;
                    y2 = y;
                }
            } else {
                x1 = y1 = (x2 = (y2 = 0.0));
            }
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator(@Nullable AffineTransform at) {
            return at == null ? (PathIterator)new CopyIterator(this) : (PathIterator)new TxIterator(this, at);
        }

        @Override
        @NotNull
        public PathIterator getFlattenPathIterator(double flatness) {
            return new FlatteningPathIterator(this.getPathIterator(), flatness);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/mkui/geom/Path2D$Double$CopyIterator;", "Lorg/mkui/geom/Path2D$Iterator;", "p2dd", "Lorg/mkui/geom/Path2D$Double;", "<init>", "(Lorg/mkui/geom/Path2D$Double;)V", "doubleCoords", "", "getDoubleCoords", "()[D", "currentSegment", "", "coords", "", "mkui"})
        @StabilityInferred(parameters=0)
        public static final class CopyIterator
        extends Iterator {
            @NotNull
            private final double[] doubleCoords;
            public static final int $stable = 8;

            public CopyIterator(@NotNull Double p2dd) {
                Intrinsics.checkNotNullParameter((Object)p2dd, (String)"p2dd");
                super(p2dd);
                this.doubleCoords = p2dd.getDoubleCoords();
            }

            @NotNull
            public final double[] getDoubleCoords() {
                return this.doubleCoords;
            }

            @Override
            public int currentSegment(@NotNull float[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    for (int i = 0; i < numCoords; ++i) {
                        coords[i] = (float)this.doubleCoords[this.getPointIdx() + i];
                    }
                }
                return type;
            }

            @Override
            public int currentSegment(@NotNull double[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    for (int i = 0; i < numCoords; ++i) {
                        coords[i] = this.doubleCoords[this.getPointIdx() + i];
                    }
                }
                return type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/mkui/geom/Path2D$Double$TxIterator;", "Lorg/mkui/geom/Path2D$Iterator;", "p2dd", "Lorg/mkui/geom/Path2D$Double;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/Path2D$Double;Lorg/mkui/geom/AffineTransform;)V", "doubleCoords", "", "getDoubleCoords", "()[D", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "currentSegment", "", "coords", "", "mkui"})
        @StabilityInferred(parameters=0)
        public static final class TxIterator
        extends Iterator {
            @NotNull
            private final double[] doubleCoords;
            @NotNull
            private final AffineTransform affine;
            public static final int $stable = 8;

            public TxIterator(@NotNull Double p2dd, @NotNull AffineTransform at) {
                Intrinsics.checkNotNullParameter((Object)p2dd, (String)"p2dd");
                Intrinsics.checkNotNullParameter((Object)at, (String)"at");
                super(p2dd);
                this.doubleCoords = p2dd.getDoubleCoords();
                this.affine = at;
            }

            @NotNull
            public final double[] getDoubleCoords() {
                return this.doubleCoords;
            }

            @NotNull
            public final AffineTransform getAffine() {
                return this.affine;
            }

            @Override
            public int currentSegment(@NotNull float[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    this.affine.transform(this.doubleCoords, this.getPointIdx(), coords, 0, numCoords / 2);
                }
                return type;
            }

            @Override
            public int currentSegment(@NotNull double[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    this.affine.transform(this.doubleCoords, this.getPointIdx(), coords, 0, numCoords / 2);
                }
                return type;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/mkui/geom/Path2D$Iterator;", "Lorg/mkui/geom/PathIterator;", "path", "Lorg/mkui/geom/Path2D;", "<init>", "(Lorg/mkui/geom/Path2D;)V", "getPath", "()Lorg/mkui/geom/Path2D;", "typeIdx", "", "getTypeIdx", "()I", "setTypeIdx", "(I)V", "pointIdx", "getPointIdx", "setPointIdx", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "Companion", "mkui"})
    @StabilityInferred(parameters=0)
    public static abstract class Iterator
    implements PathIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Path2D path;
        private int typeIdx;
        private int pointIdx;
        public static final int $stable = 8;
        @NotNull
        private static final int[] curvecoords;

        public Iterator(@NotNull Path2D path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final Path2D getPath() {
            return this.path;
        }

        public final int getTypeIdx() {
            return this.typeIdx;
        }

        public final void setTypeIdx(int n) {
            this.typeIdx = n;
        }

        public final int getPointIdx() {
            return this.pointIdx;
        }

        public final void setPointIdx(int n) {
            this.pointIdx = n;
        }

        @Override
        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.getNumTypes();
        }

        @Override
        public void next() {
            int n = this.typeIdx;
            this.typeIdx = n + 1;
            byte type = this.path.getPointTypes()[n];
            this.pointIdx += curvecoords[type];
        }

        static {
            int[] nArray = new int[]{2, 2, 4, 6, 0};
            curvecoords = nArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/mkui/geom/Path2D$Iterator$Companion;", "", "<init>", "()V", "curvecoords", "", "getCurvecoords", "()[I", "mkui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final int[] getCurvecoords() {
                return curvecoords;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

