/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AbstractRectangle2D;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.RoundRectIterator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0000H\u0016J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH&J&\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\n\u0010!\u001a\u00020\u0015H\u0096\u0080\u0004J\u0014\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0082\u0004R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\u001b\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/mkui/geom/RoundRectangle2D;", "Lorg/mkui/geom/AbstractRectangle2D;", "<init>", "()V", "setRoundRect", "", "rr", "arcWidth", "", "getArcWidth", "()D", "arcHeight", "getArcHeight", "x", "y", "w", "h", "setFrame", "intersects", "", "classify", "", "coord", "left", "right", "arcsize", "contains", "isEmpty", "()Z", "getPathIterator", "Lorg/mkui/geom/PathIterator;", "at", "Lorg/mkui/geom/AffineTransform;", "hashCode", "equals", "other", "", "Double", "mkui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRoundRectangle2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundRectangle2D.kt\norg/mkui/geom/RoundRectangle2D\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1#2:491\n*E\n"})
public abstract class RoundRectangle2D
extends AbstractRectangle2D {
    public static final int $stable;

    protected RoundRectangle2D() {
    }

    public void setRoundRect(@NotNull RoundRectangle2D rr) {
        Intrinsics.checkNotNullParameter((Object)rr, (String)"rr");
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    public abstract double getArcWidth();

    public abstract double getArcHeight();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public final void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        double x2 = x;
        double y2 = y;
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double rrx0 = x2;
        double rry0 = y2;
        double rrx1 = rrx0 + this.getWidth();
        double rry1 = rry0 + this.getHeight();
        if (x2 + w <= rrx0 || x2 >= rrx1 || y2 + h <= rry0 || y2 >= rry1) {
            return false;
        }
        double aw = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double ah = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        int x0class = this.classify(x2, rrx0, rrx1, aw);
        int x1class = this.classify(x2 + w, rrx0, rrx1, aw);
        int y0class = this.classify(y2, rry0, rry1, ah);
        int y1class = this.classify(y2 + h, rry0, rry1, ah);
        if (x0class == 2 || x1class == 2 || y0class == 2 || y1class == 2) {
            return true;
        }
        if (x0class < 2 && x1class > 2 || y0class < 2 && y1class > 2) {
            return true;
        }
        x2 = x1class == 1 ? x2 + w - (rrx0 + aw) : x2 - (rrx1 - aw);
        y2 = y1class == 1 ? y2 + h - (rry0 + ah) : y2 - (rry1 - ah);
        return (x2 /= aw) * x2 + (y2 /= ah) * y2 <= 1.0;
    }

    private final int classify(double coord, double left, double right, double arcsize) {
        return coord < left ? 0 : (coord < left + arcsize ? 1 : (coord < right - arcsize ? 2 : (coord < right ? 3 : 4)));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.isEmpty() || w <= 0.0 || h <= 0.0 ? false : this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(double x, double y) {
        Unit unit;
        double d;
        double it;
        double x2 = x;
        double y2 = y;
        if (this.isEmpty()) {
            return false;
        }
        double rrx0 = 0.0;
        rrx0 = x2;
        double rry0 = 0.0;
        rry0 = y2;
        double rrx1 = rrx0 + this.getWidth();
        double rry1 = rry0 + this.getHeight();
        if (x2 < rrx0 || y2 < rry0 || x2 >= rrx1 || y2 >= rry1) {
            return false;
        }
        double aw = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double ah = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        double d2 = aw;
        double d3 = x2;
        boolean bl = false;
        double d4 = rrx0 += it;
        if (d3 >= d4) {
            it = d = aw;
            d4 = rrx1;
            d3 = x2;
            boolean bl2 = false;
            rrx0 = it;
            unit = Unit.INSTANCE;
            if (d3 < d4 - d) {
                return true;
            }
        }
        it = ah;
        d3 = y2;
        boolean bl3 = false;
        d4 = rry0 += it;
        if (d3 >= d4) {
            it = d = ah;
            d4 = rry1;
            d3 = y2;
            boolean bl4 = false;
            rry0 = it;
            unit = Unit.INSTANCE;
            if (d3 < d4 - d) {
                return true;
            }
        }
        return (x2 = (x2 - rrx0) / aw) * x2 + (y2 = (y2 - rry0) / ah) * y2 <= 1.0;
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new RoundRectIterator(this, at);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToRawLongBits(this.getX());
        bits += java.lang.Double.doubleToRawLongBits(this.getY()) * (long)37;
        bits += java.lang.Double.doubleToRawLongBits(this.getWidth()) * (long)43;
        bits += java.lang.Double.doubleToRawLongBits(this.getHeight()) * (long)47;
        bits += java.lang.Double.doubleToRawLongBits(this.getArcWidth()) * (long)53;
        return (int)(bits += java.lang.Double.doubleToRawLongBits(this.getArcHeight()) * (long)59) ^ (int)(bits >> 32);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RoundRectangle2D) {
            return this.getX() == ((RoundRectangle2D)other).getX() && this.getY() == ((RoundRectangle2D)other).getY() && this.getWidth() == ((RoundRectangle2D)other).getWidth() && this.getHeight() == ((RoundRectangle2D)other).getHeight() && this.getArcWidth() == ((RoundRectangle2D)other).getArcWidth() && this.getArcHeight() == ((RoundRectangle2D)other).getArcHeight();
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B9\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J8\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0001H\u0016J\u0006\u0010(\u001a\u00020\u001fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000fR\u001a\u0010\u0015\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0018\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000fR\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0014\u0010'\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#\u00a8\u0006)"}, d2={"Lorg/mkui/geom/RoundRectangle2D$Double;", "Lorg/mkui/geom/RoundRectangle2D;", "<init>", "()V", "x", "", "y", "w", "h", "arcw", "arch", "(DDDDDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "width", "getWidth", "setWidth", "height", "getHeight", "setHeight", "arcWidth", "getArcWidth", "setArcWidth", "arcHeight", "getArcHeight", "setArcHeight", "add", "Lorg/mkui/geom/Rectangle2D;", "normalize", "isNormalized", "", "()Z", "setRoundRect", "", "rr", "isEmpty", "computeBounds2D", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class Double
    extends RoundRectangle2D {
        private double x;
        private double y;
        private double width;
        private double height;
        private double arcWidth;
        private double arcHeight;
        public static final int $stable = 8;

        @Override
        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        @Override
        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        public void setWidth(double d) {
            this.width = d;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        @Override
        public double getArcWidth() {
            return this.arcWidth;
        }

        public void setArcWidth(double d) {
            this.arcWidth = d;
        }

        @Override
        public double getArcHeight() {
            return this.arcHeight;
        }

        public void setArcHeight(double d) {
            this.arcHeight = d;
        }

        public Double() {
        }

        public Double(double x, double y, double w, double h, double arcw, double arch) {
            this.setRoundRect(x, y, w, h, arcw, arch);
        }

        @Override
        @NotNull
        public Rectangle2D add(double x, double y) {
            double x1 = Math.min(this.getMinX(), x);
            double x2 = Math.max(this.getMaxX(), x);
            double y1 = Math.min(this.getMinY(), y);
            double y2 = Math.max(this.getMaxY(), y);
            return new Double(x1, y1, x2 - x1, y2 - y1, this.getArcWidth(), this.getArcHeight());
        }

        @Override
        @NotNull
        public Rectangle2D normalize() {
            if (this.isNormalized()) {
                return this;
            }
            double normalizedX = this.getX();
            double normalizedY = this.getY();
            double normalizedWidth = this.getWidth();
            double normalizedHeight = this.getHeight();
            if (normalizedWidth < 0.0) {
                normalizedWidth = -normalizedWidth;
                normalizedX -= normalizedWidth;
            }
            if (normalizedHeight < 0.0) {
                normalizedHeight = -normalizedHeight;
                normalizedY -= normalizedHeight;
            }
            return new Double(normalizedX, normalizedY, normalizedWidth, normalizedHeight, this.getArcWidth(), this.getArcHeight());
        }

        private final boolean isNormalized() {
            return this.getWidth() >= 0.0 && this.getHeight() >= 0.0;
        }

        @Override
        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.setX(x);
            this.setY(y);
            this.setWidth(w);
            this.setHeight(h);
            this.setArcWidth(arcWidth);
            this.setArcHeight(arcHeight);
        }

        @Override
        public void setRoundRect(@NotNull RoundRectangle2D rr) {
            Intrinsics.checkNotNullParameter((Object)rr, (String)"rr");
            this.setX(rr.getX());
            this.setY(rr.getY());
            this.setWidth(rr.getWidth());
            this.setHeight(rr.getHeight());
            this.setArcWidth(rr.getArcWidth());
            this.setArcHeight(rr.getArcHeight());
        }

        @Override
        public boolean isEmpty() {
            return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
        }

        @NotNull
        public final Rectangle2D computeBounds2D() {
            return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }
}

