/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010JR\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/mkui/geom/curve/Geom;", "", "<init>", "()V", "INTERSECT", "getINTERSECT", "()Ljava/lang/Object;", "PARALLEL", "ptSegDistSq", "", "a", "", "b", "c", "d", "n", "", "getSegSegIntersection", "x1", "y1", "x2", "y2", "x3", "y3", "x4", "y4", "result", "mkui"})
@StabilityInferred(parameters=0)
public final class Geom {
    @NotNull
    public static final Geom INSTANCE = new Geom();
    @NotNull
    private static final Object INTERSECT = new Object();
    @NotNull
    private static final Object PARALLEL = new Object();
    public static final int $stable = 8;

    private Geom() {
    }

    @NotNull
    public final Object getINTERSECT() {
        return INTERSECT;
    }

    public final double ptSegDistSq(@Nullable double[] a, @Nullable double[] b, @Nullable double[] c2, @NotNull double[] d, int n) {
        int i;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        for (int i2 = 0; i2 < n; ++i2) {
            Intrinsics.checkNotNull((Object)b);
            double d2 = b[i2];
            Intrinsics.checkNotNull((Object)a);
            d[i2] = d2 - a[i2];
        }
        double f = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            f += d[i3] * d[i3];
        }
        double t = 0.0;
        if (!(f == 0.0)) {
            double g2 = 0.0;
            for (i = 0; i < n; ++i) {
                double d3 = d[i];
                Intrinsics.checkNotNull((Object)c2);
                double d4 = c2[i];
                Intrinsics.checkNotNull((Object)a);
                g2 += d3 * (d4 - a[i]);
            }
            t = g2 / f;
        }
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        for (int i4 = 0; i4 < n; ++i4) {
            Intrinsics.checkNotNull((Object)a);
            d[i4] = a[i4] + t * d[i4];
        }
        d[n] = t;
        double distSq = 0.0;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)c2);
            double h = c2[i] - d[i];
            distSq += h * h;
        }
        return distSq;
    }

    @Nullable
    public final Object getSegSegIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, @Nullable double[] result) {
        double bx = x2 - x1;
        double dy = y4 - y3;
        double by = y2 - y1;
        double dx = x4 - x3;
        double b_dot_d_perp = bx * dy - by * dx;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx = x3 - x1;
        double cy = y3 - y1;
        double t = (cx * dy - cy * dx) / b_dot_d_perp;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        double u = (cx * by - cy * bx) / b_dot_d_perp;
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        if (result != null) {
            result[0] = x1 + t * bx;
            result[1] = y1 + t * by;
            result[2] = t;
        }
        return INTERSECT;
    }
}

