/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BSpline;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ValueVector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/mkui/geom/curve/NURBSpline;", "Lorg/mkui/geom/curve/BSpline;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "<init>", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "weightVector", "Lorg/mkui/geom/curve/ValueVector;", "useWeightVector", "", "getUseWeightVector", "()Z", "setUseWeightVector", "(Z)V", "getWeightVector", "setWeightVector", "", "v", "appendTo", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "resetMemory", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class NURBSpline
extends BSpline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ValueVector weightVector;
    private boolean useWeightVector;
    public static final int $stable = 8;
    @NotNull
    private static double[] nw = new double[0];
    @NotNull
    private static double[] weight = new double[0];

    public NURBSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0};
        this.weightVector = new ValueVector(dArray, 4);
        this.useWeightVector = true;
    }

    public final boolean getUseWeightVector() {
        return this.useWeightVector;
    }

    public final void setUseWeightVector(boolean bl) {
        this.useWeightVector = bl;
    }

    @Nullable
    public final ValueVector getWeightVector() {
        return this.weightVector;
    }

    public final void setWeightVector(@Nullable ValueVector v) {
        this.weightVector = v;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int numPts = groupIterator2.getGroupSize();
        if (nw.length < numPts) {
            nw = new double[2 * numPts];
            weight = new double[2 * numPts];
        }
        if (this.useWeightVector) {
            ValueVector valueVector = this.weightVector;
            Intrinsics.checkNotNull((Object)valueVector);
            if (valueVector.size() != numPts) {
                return;
            }
            for (int i = 0; i < numPts; ++i) {
                ValueVector valueVector2 = this.weightVector;
                Intrinsics.checkNotNull((Object)valueVector2);
                NURBSpline.weight[i] = valueVector2.get(i);
                if (!(weight[i] < 0.0)) continue;
                return;
            }
        } else {
            for (int i = 0; i < numPts; ++i) {
                NURBSpline.weight[i] = 1.0;
            }
        }
        super.appendTo(mp);
    }

    @Override
    public void eval(@NotNull double[] p) {
        int i;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int dim = p.length - 1;
        double t = p[dim];
        double sum2 = 0.0;
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        for (i = 0; i < numPts; ++i) {
            NURBSpline.nw[i] = this.N(t, i) * weight[i];
            sum2 += nw[i];
        }
        if (sum2 == 0.0) {
            sum2 = 1.0;
        }
        for (i = 0; i < dim; ++i) {
            GroupIterator groupIterator2 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator2);
            groupIterator2.set(0, 0);
            double sum1 = 0.0;
            for (int j = 0; j < numPts; ++j) {
                double d = nw[j];
                ControlPath controlPath = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath);
                GroupIterator groupIterator3 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator3);
                sum1 += d * controlPath.getPoint(groupIterator3.next()).getLocation()[i];
            }
            p[i] = sum1 / sum2;
        }
    }

    @Override
    public void resetMemory() {
        super.resetMemory();
        if (!(nw.length == 0)) {
            nw = new double[0];
            weight = new double[0];
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/mkui/geom/curve/NURBSpline$Companion;", "", "<init>", "()V", "nw", "", "weight", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

