/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics.line;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.graphics.line.LineDrawer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/mkui/graphics/line/BresenhamLineDrawer;", "Lorg/mkui/graphics/line/LineDrawer;", "<init>", "()V", "drawLine", "", "x0", "", "y0", "x1", "y1", "width", "height", "visitor", "Lorg/mkui/graphics/line/LineDrawer$LineVisitor;", "drawFirstPoint", "", "mkui"})
@StabilityInferred(parameters=1)
public final class BresenhamLineDrawer
implements LineDrawer {
    public static final int $stable;

    @Override
    public void drawLine(int x0, int y0, int x1, int y1, int width, int height, @NotNull LineDrawer.LineVisitor visitor, boolean drawFirstPoint) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        int x02 = x0;
        int y02 = y0;
        int dy = y1 - y02;
        int dx = x1 - x02;
        int stepy = 0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        int stepx = 0;
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        dy <<= 1;
        dx <<= 1;
        if (drawFirstPoint) {
            visitor.process(x02, y02);
        }
        if (dx > dy) {
            int fraction = dy - (dx >> 1);
            while (x02 != x1) {
                if (fraction >= 0) {
                    y02 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                visitor.process(x02 += stepx, y02);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y02 != y1) {
                if (fraction >= 0) {
                    x02 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                visitor.process(x02, y02 += stepy);
            }
        }
    }
}

