/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.canvas.AbstractDensityLayer;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.Edge;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.line.BresenhamLineDrawer;
import org.mkui.graphics.line.LineDrawer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 )2\u00020\u0001:\u0003'()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010 \u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lorg/mkui/canvas/AbstractDensityLayer;", "", "<init>", "()V", "overlay", "", "getOverlay", "()[I", "setOverlay", "([I)V", "safeLineVisitor", "Lorg/mkui/graphics/line/LineDrawer$LineVisitor;", "unsafeLineVisitor", "value", "", "width", "getWidth", "()I", "setWidth", "(I)V", "height", "getHeight", "setHeight", "cx1", "getCx1", "setCx1", "cy1", "getCy1", "setCy1", "cx2", "getCx2", "setCx2", "cy2", "getCy2", "setCy2", "g", "Lorg/mkui/graphics/IGraphics;", "getG", "()Lorg/mkui/graphics/IGraphics;", "SafeLineVisitor", "UnsafeLineVisitor", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class AbstractDensityLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected int[] overlay;
    @NotNull
    private final LineDrawer.LineVisitor safeLineVisitor = new SafeLineVisitor();
    @NotNull
    private final LineDrawer.LineVisitor unsafeLineVisitor = new UnsafeLineVisitor();
    private int width;
    private int height;
    private int cx1;
    private int cy1;
    private int cx2;
    private int cy2;
    @NotNull
    private final IGraphics g = new AbstractIGraphics(this){
        final /* synthetic */ AbstractDensityLayer this$0;
        {
            this.this$0 = $receiver;
        }

        public boolean isThreadSafe() {
            return true;
        }

        public double getLineWidth() {
            return 0.0;
        }

        public void setLineWidth(double lineWidth) {
        }

        public Color getColor() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        public void setColor(Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        }

        public void setGlobalAlpha(double alpha) {
        }

        protected void draw(Shape geometry) {
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            PathIterator pi = Shape.getPathIterator$default(geometry, null, 1, null);
            float[] data = new float[6];
            int previousX = 0;
            int previousY = 0;
            boolean firstPoint = true;
            while (!pi.isDone()) {
                int segType = pi.currentSegment(data);
                switch (segType) {
                    case 0: {
                        previousX = (int)data[0];
                        previousY = (int)data[1];
                        firstPoint = true;
                        break;
                    }
                    case 1: {
                        int currentX = (int)data[0];
                        int currentY = (int)data[1];
                        if (previousX >= this.this$0.getCx1() && previousX <= this.this$0.getCx2() && previousY >= this.this$0.getCy1() && previousY <= this.this$0.getCy2() && currentX >= this.this$0.getCx1() && currentX <= this.this$0.getCx2() && currentY >= this.this$0.getCy1() && currentY <= this.this$0.getCy2()) {
                            AbstractDensityLayer.access$getLineDrawer$cp().drawLine(previousX, previousY, currentX, currentY, this.this$0.getWidth(), this.this$0.getHeight(), AbstractDensityLayer.access$getUnsafeLineVisitor$p(this.this$0), firstPoint);
                        } else {
                            AbstractDensityLayer.access$getLineDrawer$cp().drawLine(previousX, previousY, currentX, currentY, this.this$0.getWidth(), this.this$0.getHeight(), AbstractDensityLayer.access$getSafeLineVisitor$p(this.this$0), firstPoint);
                        }
                        firstPoint = false;
                        previousX = currentX;
                        previousY = currentY;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new Error("Segmented type " + segType + "unsupported");
                    }
                }
                pi.next();
            }
        }

        public void drawLine(int x1, int y1, int x2, int y2) {
            if (x1 >= this.this$0.getCx1() && x1 <= this.this$0.getCx2() && y1 >= this.this$0.getCy1() && y1 <= this.this$0.getCy2() && x2 >= this.this$0.getCx1() && x2 <= this.this$0.getCx2() && y2 >= this.this$0.getCy1() && y2 <= this.this$0.getCy2()) {
                AbstractDensityLayer.access$getLineDrawer$cp().drawLine(x1, y1, x2, y2, this.this$0.getWidth(), this.this$0.getHeight(), AbstractDensityLayer.access$getUnsafeLineVisitor$p(this.this$0), true);
            } else {
                AbstractDensityLayer.access$getLineDrawer$cp().drawLine(x1, y1, x2, y2, this.this$0.getWidth(), this.this$0.getHeight(), AbstractDensityLayer.access$getSafeLineVisitor$p(this.this$0), true);
            }
        }

        public void drawLine(double x1, double y1, double x2, double y2) {
            this.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }

        private final void plot(int x, int y) {
            int i = y * this.this$0.getWidth() + x;
            int[] nArray = this.this$0.getOverlay();
            int n = nArray[i];
            nArray[i] = n + 1;
        }

        private final void plotH(int x1, int y, int x2) {
            for (int x = x1; x < x2; ++x) {
                this.plot(x, y);
            }
        }

        private final void plotHClipped(int x1, int y, int x2) {
            if (x1 <= this.this$0.getCx2() && x2 >= this.this$0.getCx1()) {
                this.plotH(x1 < this.this$0.getCx1() ? this.this$0.getCx1() : x1, y, x2 > this.this$0.getCx2() ? this.this$0.getCx2() : x2);
            }
        }

        private final void plotVHClipped(int x1, int y, int x2) {
            if (y >= this.this$0.getCy1() && y <= this.this$0.getCy2() && x1 <= this.this$0.getCx2() && x2 >= this.this$0.getCx1()) {
                this.plotH(x1 < this.this$0.getCx1() ? this.this$0.getCx1() : x1, y, x2 > this.this$0.getCx2() ? this.this$0.getCx2() : x2);
            }
        }

        private final void plotV(int y1, int x, int y2) {
            int y = y1;
            if (y <= y2) {
                while (true) {
                    this.plot(x, y);
                    if (y == y2) break;
                    ++y;
                }
            }
        }

        private final void plotVClipped(int y1, int x, int y2) {
            int y12 = y1;
            int y22 = y2;
            if (y12 <= this.this$0.getCy2() && y22 >= this.this$0.getCy1()) {
                int n;
                int y;
                if (y12 < this.this$0.getCy1()) {
                    y12 = this.this$0.getCy1();
                }
                if (y22 > this.this$0.getCy2()) {
                    y22 = this.this$0.getCy2();
                }
                if ((y = y12) <= (n = y22)) {
                    while (true) {
                        this.plot(x, y);
                        if (y == n) break;
                        ++y;
                    }
                }
            }
        }

        protected void fill(Shape s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Rectangle2D b = s.getBounds2D();
            int x1 = (int)b.getX();
            int y1 = (int)b.getY();
            int x2 = (int)((double)x1 + b.getWidth() - 1.0);
            int y2 = (int)((double)y1 + b.getHeight() - 1.0);
            if (x1 > this.this$0.getCx2() || y1 > this.this$0.getCy2() || x2 < this.this$0.getCx1() || y2 < this.this$0.getCy1()) {
                return;
            }
            PathIterator i = s.getFlattenPathIterator(0.33333);
            while (!i.isDone()) {
                int[] x = null;
                x = new int[100];
                int[] y = null;
                y = new int[100];
                int closeX = 0;
                int closeY = 0;
                int count = 0;
                float[] coords = new float[6];
                boolean didClose = true;
                while (!i.isDone()) {
                    int segment = i.currentSegment(coords);
                    switch (segment) {
                        case 0: {
                            int n;
                            if (!didClose) {
                                x[count] = closeX;
                                y[count] = closeY;
                                n = count;
                                count = n + 1;
                            }
                            g.1 $this$fill_u24lambda_u240 = this;
                            boolean bl = false;
                            x[count] = closeX = (int)coords[0];
                            g.1 $this$fill_u24lambda_u241 = this;
                            boolean bl2 = false;
                            y[count] = closeY = (int)coords[1];
                            didClose = false;
                            n = count;
                            count = n + 1;
                            break;
                        }
                        case 1: {
                            x[count] = (int)coords[0];
                            y[count] = (int)coords[1];
                            didClose = false;
                            int n = count;
                            count = n + 1;
                            break;
                        }
                        case 4: {
                            x[count] = closeX;
                            y[count] = closeY;
                            int n = count;
                            count = n + 1;
                            didClose = true;
                            break;
                        }
                        default: {
                            System.out.println((Object)("Unsupported type " + segment));
                        }
                    }
                    if (count >= x.length) {
                        int[] tmp = x;
                        x = new int[x.length * 2];
                        ArrayFnKt.arraycopy((int[])tmp, (int)0, (int[])x, (int)0, (int)tmp.length);
                        tmp = y;
                        y = new int[y.length * 2];
                        ArrayFnKt.arraycopy((int[])tmp, (int)0, (int[])y, (int)0, (int)tmp.length);
                    }
                    if (didClose) {
                        if (i.isDone()) break;
                        i.next();
                        break;
                    }
                    i.next();
                }
                if (!didClose) {
                    x[count] = closeX;
                    y[count] = closeY;
                    int tmp = count;
                    count = tmp + 1;
                }
                Object[] edges = null;
                int n = Math.max(this.this$0.getHeight(), this.this$0.getWidth());
                edges = new Edge[n];
                for (int j = 0; j < n; ++j) {
                    edges[j] = new Edge();
                }
                if (count <= 2) continue;
                this.scanFillVertical((Edge[])ArraysKt.requireNoNulls((Object[])edges), x, y, count, Math.max((int)b.getX(), this.this$0.getCx1()), Math.min((int)(b.getX() + b.getWidth() - 1.0), this.this$0.getCx2()));
            }
        }

        protected final void scanFillHorizontal(Edge[] edges, int[] x, int[] y, int cnt, int miny, int maxy) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge active = new Edge();
            this.buildEdgeListHorizontal(edges, x, y, cnt);
            int scan = miny;
            if (scan <= maxy) {
                while (true) {
                    this.buildActiveList(edges, scan, active);
                    this.plotHClipped(scan, active);
                    this.updateActiveList(scan, active);
                    this.resortActiveList(active);
                    edges[scan].setNext(null);
                    if (scan == maxy) break;
                    ++scan;
                }
            }
        }

        public final void scanFillVertical(Edge[] edges, int[] x, int[] y, int cnt, int minx, int maxx) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge active = new Edge();
            this.buildEdgeListVertical(edges, x, y, cnt);
            int scan = minx;
            if (scan <= maxx) {
                while (true) {
                    this.buildActiveList(edges, scan, active);
                    this.plotVClipped(scan, active);
                    this.updateActiveList(scan, active);
                    this.resortActiveList(active);
                    edges[scan].setNext(null);
                    if (scan == maxx) break;
                    ++scan;
                }
            }
        }

        public final void insertEdge(Edge list, Edge edge) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Edge p = null;
            Edge q = null;
            q = list;
            p = q.getNext();
            while (p != null) {
                if (edge.getIntersect() < p.getIntersect()) {
                    p = null;
                    continue;
                }
                q = p;
                p = p.getNext();
            }
            edge.setNext(q.getNext());
            q.setNext(edge);
        }

        public final void buildEdgeListHorizontal(Edge[] edges, int[] x, int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge edge = null;
            int v1 = 0;
            int v2 = 0;
            int yPrev = 0;
            int i = 0;
            yPrev = y[cnt - 2];
            for (v1 = cnt - 1; v1 >= 1 && (yPrev = y[v1 - 1]) == y[v1]; --v1) {
            }
            for (i = 0; i < cnt; ++i) {
                v2 = i;
                if (y[v1] != y[v2]) {
                    edge = new Edge();
                    if (y[v1] < y[v2]) {
                        this.makeEdgeRecHorizontal(edges, v1, v2, this.yNext(i, x, y, cnt), edge, x, y);
                    } else {
                        this.makeEdgeRecHorizontal(edges, v2, v1, yPrev, edge, x, y);
                    }
                    yPrev = y[v1];
                }
                v1 = v2;
            }
        }

        public final void buildEdgeListVertical(Edge[] edges, int[] x, int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge edge = null;
            int v1 = 0;
            int v2 = 0;
            int xPrev = 0;
            int i = 0;
            xPrev = x[cnt - 2];
            for (v1 = cnt - 1; v1 >= 1 && (xPrev = x[v1 - 1]) == x[v1]; --v1) {
            }
            for (i = 0; i < cnt; ++i) {
                v2 = i;
                if (x[v1] != x[v2]) {
                    edge = new Edge();
                    if (x[v1] < x[v2]) {
                        this.makeEdgeRecVertical(edges, v1, v2, this.xNext(i, x, y, cnt), edge, x, y);
                    } else {
                        this.makeEdgeRecVertical(edges, v2, v1, xPrev, edge, x, y);
                    }
                    xPrev = x[v1];
                }
                v1 = v2;
            }
        }

        public final int yNext(int k, int[] x, int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            int j = 0;
            int n = j = k + 1 >= cnt ? 0 : k + 1;
            while (y[k] == y[j]) {
                if (j + 1 >= cnt) {
                    j = 0;
                    continue;
                }
                ++j;
            }
            return y[j];
        }

        public final int xNext(int k, int[] x, int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int j = 0;
            int n = j = k + 1 >= cnt ? 0 : k + 1;
            while (x[k] == x[j]) {
                if (j + 1 >= cnt) {
                    j = 0;
                    continue;
                }
                ++j;
            }
            return x[j];
        }

        public final void makeEdgeRecHorizontal(Edge[] edges, int lower, int upper, int yComp, Edge edge, int[] x, int[] y) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            edge.setDPerScan((float)(x[upper] - x[lower]) / (float)(y[upper] - y[lower]));
            edge.setIntersect(x[lower]);
            if (y[lower] < this.this$0.getCy1()) {
                edge.setIntersect(edge.getIntersect() + edge.getDPerScan() * (float)(this.this$0.getCy1() - y[lower]));
            }
            if (y[upper] < yComp) {
                edge.setUpper(y[upper] - 1);
            } else {
                edge.setUpper(y[upper]);
            }
            if (y[lower] <= this.this$0.getCy2() && edge.getUpper() >= this.this$0.getCy1()) {
                this.insertEdge(edges[Math.max(this.this$0.getCy1(), y[lower])], edge);
            }
        }

        public final void makeEdgeRecVertical(Edge[] edges, int lower, int upper, int xComp, Edge edge, int[] x, int[] y) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            edge.setDPerScan((float)(y[upper] - y[lower]) / (float)(x[upper] - x[lower]));
            edge.setIntersect(y[lower]);
            if (x[lower] < this.this$0.getCx1()) {
                edge.setIntersect(edge.getIntersect() + edge.getDPerScan() * (float)(this.this$0.getCx1() - x[lower]));
            }
            if (x[upper] < xComp) {
                edge.setUpper(x[upper] - 1);
            } else {
                edge.setUpper(x[upper]);
            }
            if (x[lower] <= this.this$0.getCx2() && edge.getUpper() >= this.this$0.getCx1()) {
                this.insertEdge(edges[Math.max(this.this$0.getCx1(), x[lower])], edge);
            }
        }

        public final void buildActiveList(Edge[] edges, int scan, Edge active) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Edge p = null;
            Edge q = null;
            p = edges[scan].getNext();
            while (p != null) {
                Intrinsics.checkNotNull((Object)p.getNext());
                Edge edge = active;
                Intrinsics.checkNotNull((Object)edge);
                this.insertEdge(edge, p);
                p = q;
            }
        }

        public final void plotHClipped(int scan, Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p1 = null;
            Edge p2 = null;
            p1 = active.getNext();
            while (p1 != null) {
                Intrinsics.checkNotNull((Object)p1.getNext());
                int x1 = (int)(p1.getIntersect() + 0.5f);
                int x2 = (int)p2.getIntersect();
                this.plotHClipped(x1, scan, x2);
                p1 = p2.getNext();
            }
        }

        public final void plotVClipped(int scan, Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p1 = null;
            Edge p2 = null;
            p1 = active.getNext();
            while (p1 != null) {
                Intrinsics.checkNotNull((Object)p1.getNext());
                int y1 = (int)(p1.getIntersect() + 0.5f);
                int y2 = (int)p2.getIntersect();
                this.plotVClipped(y1, scan, y2);
                p1 = p2.getNext();
            }
        }

        public final void updateActiveList(int scan, Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p = null;
            Edge q = null;
            q = active;
            p = active.getNext();
            while (p != null) {
                if (scan >= p.getUpper()) {
                    p = p.getNext();
                    this.deleteAfter(q);
                    continue;
                }
                Edge edge = p;
                edge.setIntersect(edge.getIntersect() + p.getDPerScan());
                q = p;
                p = p.getNext();
            }
        }

        protected final void prepareEdgeList(Edge[] edges, int scan) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Edge p = null;
            Edge q = null;
            q = edges[scan];
            p = q.getNext();
            while (p != null) {
                if (scan >= p.getUpper()) {
                    p = p.getNext();
                    this.deleteAfter(q);
                    continue;
                }
                q = p;
                p = p.getNext();
            }
        }

        public final void deleteAfter(Edge q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Edge p = null;
            Edge edge = q.getNext();
            Intrinsics.checkNotNull((Object)edge);
            p = edge;
            q.setNext(p.getNext());
        }

        public final void resortActiveList(Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p = null;
            Edge q = null;
            p = active.getNext();
            active.setNext(null);
            while (p != null) {
                Intrinsics.checkNotNull((Object)p.getNext());
                this.insertEdge(active, p);
                p = q;
            }
        }

        public void drawPoint(Point2D point) {
            if (point != null) {
                AbstractDensityLayer.access$getSafeLineVisitor$p(this.this$0).process((int)point.getX(), (int)point.getY());
            }
        }

        public void fillCircle(Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            if (r.getWidth() <= 2.0 || r.getHeight() <= 2.0) {
                this.fillRectangle2D(r);
                return;
            }
            int a = (int)(r.getWidth() / (double)2);
            int b = (int)(r.getHeight() / (double)2);
            int x = 0;
            int y = b;
            long a2 = a * a;
            long b2 = b * b;
            long xcrit = (long)3 * a2 / (long)4 + 1L;
            long ycrit = (long)3 * b2 / (long)4 + 1L;
            long t = b2 + a2 - (long)2 * a2 * (long)b;
            long dxt = b2 * (long)(3 + x + x);
            long dyt = a2 * (long)(3 - y - y);
            long d2xt = b2 + b2;
            long d2yt = a2 + a2;
            Rectangle r1 = null;
            Rectangle r2 = null;
            r1 = new Rectangle((int)r.getX() + a, (int)r.getY(), (int)r.getWidth() & 1, 1);
            r2 = new Rectangle((int)r.getX() + a, (int)(r.getY() + r.getHeight()) - 1, (int)r.getWidth() & 1, 1);
            while (y > 0) {
                if (t + a2 * (long)y < xcrit) {
                    ++x;
                    t += dxt;
                    dxt += d2xt;
                    r1.setIx(r1.getIx() - 1);
                    r1.setIwidth(r1.getIwidth() + 2);
                    r2.setIx(r2.getIx() - 1);
                    r2.setIwidth(r2.getIwidth() + 2);
                    continue;
                }
                if (t - b2 * (long)x >= ycrit) {
                    --y;
                    t += dyt;
                    dyt += d2yt;
                    r1.setIheight(r1.getIheight() + 1);
                    r2.setIheight(r2.getIheight() + 1);
                    r2.setIy(r2.getIy() - 1);
                    continue;
                }
                ++x;
                --y;
                t += dxt + dyt;
                dxt += d2xt;
                dyt += d2yt;
                if (r1.getWidth() > 0.0 && r1.getHeight() > 0.0) {
                    if (r1.getY() + r1.getHeight() < r2.getY()) {
                        this.fillRectangle2D(r1);
                        this.fillRectangle2D(r2);
                    }
                    r1.setIy(r1.getIy() + (int)r1.getHeight());
                    r1.setIheight(1);
                    r2.setIy(r2.getIy() - 1);
                    r2.setIheight(1);
                } else {
                    r1.setIheight(r1.getIheight() + 1);
                    r2.setIheight(r2.getIheight() + 1);
                    r2.setIy(r2.getIy() - 1);
                }
                r1.setIx(r1.getIx() - 1);
                r1.setIwidth(r1.getIwidth() + 2);
                r2.setIx(r2.getIx() - 1);
                r2.setIwidth(r2.getIwidth() + 2);
            }
            if (r1.getY() < r2.getY()) {
                r1.setIx((int)r.getX());
                r1.setIwidth((int)r.getWidth());
                r1.setIheight((int)(r2.getY() + r2.getHeight() - r1.getY()));
                this.fillRectangle2D(r1);
            } else if (x <= a) {
                r1.setIx((int)r.getX());
                r1.setIwidth((int)r.getWidth());
                r1.setIheight((int)(r1.getY() + r1.getHeight() - r2.getY()));
                r1.setIy((int)r2.getY());
                this.fillRectangle2D(r1);
            }
        }

        public final void horizontalLine(int x1, int y, int x2) {
            if (y >= this.this$0.getCy1() && y <= this.this$0.getCy2()) {
                if (x1 >= this.this$0.getCx1() && x1 <= this.this$0.getCx2() && x2 >= this.this$0.getCx1() && x2 <= this.this$0.getCx2()) {
                    int x = x1;
                    if (x <= x2) {
                        while (true) {
                            AbstractDensityLayer.access$getUnsafeLineVisitor$p(this.this$0).process(x, y);
                            if (x != x2) {
                                ++x;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    int x = x1;
                    if (x <= x2) {
                        while (true) {
                            AbstractDensityLayer.access$getSafeLineVisitor$p(this.this$0).process(x, y);
                            if (x == x2) break;
                            ++x;
                        }
                    }
                }
            }
        }

        public void fillRectangle2D(Rectangle2D rectangle) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            int x2 = (int)(rectangle.getX() + rectangle.getWidth()) - 1;
            int n = (int)rectangle.getHeight();
            for (int y = 0; y < n; ++y) {
                this.horizontalLine((int)rectangle.getX(), (int)(rectangle.getY() + (double)y), x2);
            }
        }

        public void fillRectangle(int x, int y, int width, int height) {
            int x2 = x + width;
            for (int h = 0; h < height; ++h) {
                this.horizontalLine(x, y + h, x2);
            }
        }

        public void translate(int x, int y) {
            throw new UnsupportedOperationException();
        }

        public void rotate(double theta) {
            throw new UnsupportedOperationException();
        }

        public void beginPath() {
            throw new UnsupportedOperationException();
        }

        public void moveTo(double x, double y) {
            throw new UnsupportedOperationException();
        }

        public void lineTo(double x, double y) {
            throw new UnsupportedOperationException();
        }

        public void closePath() {
            throw new UnsupportedOperationException();
        }

        public void stroke() {
            throw new UnsupportedOperationException();
        }

        public void fill() {
            throw new UnsupportedOperationException();
        }
    };
    public static final int $stable = 8;
    @NotNull
    private static final LineDrawer lineDrawer = new BresenhamLineDrawer();
    private static final double flatness = 0.33333;

    @NotNull
    protected final int[] getOverlay() {
        if (this.overlay != null) {
            return this.overlay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"overlay");
        return null;
    }

    protected final void setOverlay(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.overlay = nArray;
    }

    public final int getWidth() {
        return this.width;
    }

    protected final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    protected final void setHeight(int n) {
        this.height = n;
    }

    protected final int getCx1() {
        return this.cx1;
    }

    protected final void setCx1(int n) {
        this.cx1 = n;
    }

    protected final int getCy1() {
        return this.cy1;
    }

    protected final void setCy1(int n) {
        this.cy1 = n;
    }

    protected final int getCx2() {
        return this.cx2;
    }

    protected final void setCx2(int n) {
        this.cx2 = n;
    }

    protected final int getCy2() {
        return this.cy2;
    }

    protected final void setCy2(int n) {
        this.cy2 = n;
    }

    @NotNull
    protected final IGraphics getG() {
        return this.g;
    }

    public static final /* synthetic */ LineDrawer access$getLineDrawer$cp() {
        return lineDrawer;
    }

    public static final /* synthetic */ LineDrawer.LineVisitor access$getUnsafeLineVisitor$p(AbstractDensityLayer $this) {
        return $this.unsafeLineVisitor;
    }

    public static final /* synthetic */ LineDrawer.LineVisitor access$getSafeLineVisitor$p(AbstractDensityLayer $this) {
        return $this.safeLineVisitor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/mkui/canvas/AbstractDensityLayer$Companion;", "", "<init>", "()V", "lineDrawer", "Lorg/mkui/graphics/line/LineDrawer;", "flatness", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/mkui/canvas/AbstractDensityLayer$SafeLineVisitor;", "Lorg/mkui/graphics/line/LineDrawer$LineVisitor;", "<init>", "(Lorg/mkui/canvas/AbstractDensityLayer;)V", "process", "", "x", "", "y", "mkui"})
    private final class SafeLineVisitor
    implements LineDrawer.LineVisitor {
        @Override
        public void process(int x, int y) {
            if (x >= 0 && y >= 0 && x < AbstractDensityLayer.this.getWidth() && y < AbstractDensityLayer.this.getHeight()) {
                int i = y * AbstractDensityLayer.this.getWidth() + x;
                int[] nArray = AbstractDensityLayer.this.getOverlay();
                int n = nArray[i];
                nArray[i] = n + 1;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/mkui/canvas/AbstractDensityLayer$UnsafeLineVisitor;", "Lorg/mkui/graphics/line/LineDrawer$LineVisitor;", "<init>", "(Lorg/mkui/canvas/AbstractDensityLayer;)V", "process", "", "x", "", "y", "mkui"})
    private final class UnsafeLineVisitor
    implements LineDrawer.LineVisitor {
        @Override
        public void process(int x, int y) {
            int i = y * AbstractDensityLayer.this.getWidth() + x;
            int[] nArray = AbstractDensityLayer.this.getOverlay();
            int n = nArray[i];
            nArray[i] = n + 1;
        }
    }
}

