/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Color;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AbstractAveragingLayer;
import org.mkui.canvas.JavaFXLayer;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/mkui/canvas/AveragingJavaFXLayer;", "Lorg/mkui/canvas/AbstractAveragingLayer;", "Lorg/mkui/canvas/JavaFXLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "antialiasing", "", "<init>", "(Lorg/mkui/graphics/IDrawing;Z)V", "image", "Ljavafx/scene/image/WritableImage;", "prepare", "", "width", "", "height", "resize", "render", "g", "Ljavafx/scene/canvas/GraphicsContext;", "createAntiAliasedImage", "img", "clear", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAveragingJavaFXLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AveragingJavaFXLayer.kt\norg/mkui/canvas/AveragingJavaFXLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public final class AveragingJavaFXLayer
extends AbstractAveragingLayer
implements JavaFXLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean antialiasing;
    @NotNull
    private final IDrawing iDrawing;
    @Nullable
    private WritableImage image;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = false;

    public AveragingJavaFXLayer(@NotNull IDrawing iDrawing, boolean antialiasing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.antialiasing = antialiasing;
        this.iDrawing = iDrawing;
        this.resize(this.getWidth(), this.getHeight());
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.iDrawing.draw(this.getG(), null, this.getWidth(), this.getHeight(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            WritableImage writableImage = this.image;
            Intrinsics.checkNotNull((Object)writableImage);
            PixelWriter pixelWriter = writableImage.getPixelWriter();
            int n = this.getOverlay().length;
            for (int i = 0; i < n; ++i) {
                int count = this.getOverlay()[i];
                if (count > 0) {
                    boolean bl;
                    float[] c = this.getRgb()[i];
                    float red = c[0] / (float)count;
                    float green = c[1] / (float)count;
                    float blue = c[2] / (float)count;
                    boolean bl2 = bl = red >= 0.0f && red <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-AveragingJavaFXLayer$prepare$42 = false;
                        String $i$a$-assert-AveragingJavaFXLayer$prepare$42 = red + ", " + c[0] + ", " + count;
                        throw new AssertionError((Object)$i$a$-assert-AveragingJavaFXLayer$prepare$42);
                    }
                    boolean bl3 = bl = green >= 0.0f && green <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-AveragingJavaFXLayer$prepare$52 = false;
                        String $i$a$-assert-AveragingJavaFXLayer$prepare$52 = green + ", " + c[1] + ", " + count;
                        throw new AssertionError((Object)$i$a$-assert-AveragingJavaFXLayer$prepare$52);
                    }
                    boolean bl4 = bl = blue >= 0.0f && blue <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl5 = false;
                        String string = blue + ", " + c[2] + ", " + count;
                        throw new AssertionError((Object)string);
                    }
                    Color color = new Color(red, green, blue);
                    pixelWriter.setArgb(i % width, i / width, color.getRGB());
                    continue;
                }
                pixelWriter.setArgb(i % width, i / width, 0xFFFFFF);
            }
        }
        if (this.antialiasing) {
            this.image = this.createAntiAliasedImage(this.image);
        }
    }

    public final void resize(int width, int height) {
        if ((this.getWidth() != width || this.getHeight() != height) && width > 0 && height > 0) {
            WritableImage bufferedImage = new WritableImage(width, height);
            int[] o = new int[width * height];
            int n = 0;
            int n2 = width * height;
            float[][] fArrayArray = new float[n2][];
            while (n < n2) {
                int n3 = n++;
                fArrayArray[n3] = new float[3];
            }
            float[][] rgb = fArrayArray;
            n2 = ((Object[])rgb).length;
            for (int i = 0; i < n2; ++i) {
                rgb[i] = new float[3];
            }
            this.setWidth(width);
            this.setHeight(height);
            this.image = bufferedImage;
            this.setOverlay(o);
            this.setRgb(rgb);
            this.setCx1(0);
            this.setCy1(0);
            this.setCx2(width - 1);
            this.setCy2(height - 1);
        } else {
            this.clear();
        }
    }

    @Override
    public void render(@Nullable GraphicsContext g2) {
        if (this.iDrawing.isActive() && this.image != null) {
            GraphicsContext graphicsContext = g2;
            Intrinsics.checkNotNull((Object)graphicsContext);
            graphicsContext.drawImage((Image)this.image, 0.0, 0.0);
        }
    }

    private final WritableImage createAntiAliasedImage(WritableImage img) {
        return img;
    }

    public final void clear() {
        if (this.image != null) {
            Arrays.fill(this.getOverlay(), 0);
            float[][] fArray = this.getRgb();
            int n = ((Object[])fArray).length;
            for (int i = 0; i < n; ++i) {
                float[] c = fArray[i];
                c[0] = 0.0f;
                c[1] = 0.0f;
                c[2] = 0.0f;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/mkui/canvas/AveragingJavaFXLayer$Companion;", "", "<init>", "()V", "MULTITHREADED", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

