/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.JavaFXIGraphics;
import org.mkui.canvas.JavaFXLayer;
import org.mkui.canvas.PaletteProvider;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\b\u0010\u0010J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/mkui/canvas/BufferedJavaFXLayer;", "Lorg/mkui/canvas/JavaFXLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "antialiasing", "", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "<init>", "(Lorg/mkui/graphics/IDrawing;ZLorg/mkui/canvas/PaletteProvider;)V", "(Lorg/mkui/graphics/IDrawing;Z)V", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "alpha", "", "(Lorg/mkui/graphics/IDrawing;ZLjavafx/scene/paint/Color;Ljava/lang/Double;)V", "Ljava/lang/Double;", "width", "", "height", "image", "Ljavafx/scene/canvas/Canvas;", "screenImage", "Ljavafx/scene/image/WritableImage;", "prepare", "", "resize", "clear", "render", "g", "Ljavafx/scene/canvas/GraphicsContext;", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class BufferedJavaFXLayer
implements JavaFXLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    @Nullable
    private PaletteProvider paletteProvider;
    @Nullable
    private Double alpha;
    @Nullable
    private Color color;
    private int width;
    private int height;
    @Nullable
    private Canvas image;
    @Nullable
    private WritableImage screenImage;
    public static final int $stable = 8;

    public BufferedJavaFXLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.paletteProvider = paletteProvider;
    }

    public BufferedJavaFXLayer(@NotNull IDrawing iDrawing, boolean antialiasing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    public BufferedJavaFXLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @NotNull Color color, @Nullable Double alpha) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.color = color;
        this.alpha = alpha;
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && this.image != null) {
            Canvas canvas = this.image;
            Intrinsics.checkNotNull((Object)canvas);
            GraphicsContext g2 = canvas.getGraphicsContext2D();
            if (this.antialiasing) {
                // empty if block
            }
            if (this.paletteProvider != null) {
                PaletteProvider paletteProvider = this.paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider);
                Color start = paletteProvider.getPalette().getColor(0.0);
                PaletteProvider paletteProvider2 = this.paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider2);
                Color end = paletteProvider2.getPalette().getColor(1.0);
                float s = (float)start.getRed() / 255.0f;
                float e = (float)end.getRed() / 255.0f;
                if (e > s) {
                    if (this.alpha == null) {
                        float alpha = s / e;
                        g2.setGlobalAlpha((double)alpha);
                    }
                } else if (this.alpha == null) {
                    float alpha = (1.0f - s) / (1.0f - e);
                    g2.setGlobalAlpha((double)alpha);
                }
            }
            if (this.color != null) {
                Color color = this.color;
                Intrinsics.checkNotNull((Object)color);
                g2.setStroke((Paint)color);
                Color color2 = this.color;
                Intrinsics.checkNotNull((Object)color2);
                g2.setFill((Paint)color2);
            }
            if (this.alpha != null) {
                Double d = this.alpha;
                Intrinsics.checkNotNull((Object)d);
                g2.setGlobalAlpha(d.doubleValue());
            }
            Intrinsics.checkNotNull((Object)g2);
            this.iDrawing.draw(new JavaFXIGraphics(g2), null, this.width, this.height, new Rectangle(0, 0, this.width, this.height));
            Canvas canvas2 = this.image;
            Intrinsics.checkNotNull((Object)canvas2);
            BufferedJavaFXLayer.Companion.copySrcIntoDstAt(canvas2, this.screenImage);
        }
    }

    public final void resize(int width, int height) {
        if ((this.width != width || this.height != height) && width > 0 && height > 0) {
            this.image = new Canvas((double)width, (double)height);
            this.screenImage = new WritableImage(width, height);
            this.width = width;
            this.height = height;
        } else {
            this.clear();
        }
    }

    public final void clear() {
        if (this.iDrawing.isActive() && this.image != null) {
            Canvas canvas = this.image;
            Intrinsics.checkNotNull((Object)canvas);
            GraphicsContext g2 = canvas.getGraphicsContext2D();
            Canvas canvas2 = this.image;
            Intrinsics.checkNotNull((Object)canvas2);
            double d = canvas2.getWidth();
            Canvas canvas3 = this.image;
            Intrinsics.checkNotNull((Object)canvas3);
            g2.clearRect(0.0, 0.0, d, canvas3.getHeight());
        }
    }

    @Override
    public void render(@Nullable GraphicsContext g2) {
        GraphicsContext graphicsContext = g2;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.drawImage((Image)this.screenImage, 0.0, 0.0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/mkui/canvas/BufferedJavaFXLayer$Companion;", "", "<init>", "()V", "copySrcIntoDstAt", "", "src", "Ljavafx/scene/canvas/Canvas;", "dst", "Ljavafx/scene/image/WritableImage;", "runAndWait", "action", "Ljava/lang/Runnable;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final void copySrcIntoDstAt(Canvas src, WritableImage dst) {
            this.runAndWait(() -> Companion.copySrcIntoDstAt$lambda$0(src, dst));
        }

        public final void runAndWait(@Nullable Runnable action) {
            if (action == null) {
                throw new NullPointerException("action");
            }
            if (Platform.isFxApplicationThread()) {
                action.run();
                return;
            }
            CountDownLatch doneLatch = new CountDownLatch(1);
            Platform.runLater(() -> Companion.runAndWait$lambda$0(action, doneLatch));
            try {
                doneLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private static final void copySrcIntoDstAt$lambda$0(Canvas $src, WritableImage $dst) {
            SnapshotParameters parameters = new SnapshotParameters();
            parameters.setFill((Paint)Color.TRANSPARENT);
            $src.snapshot(parameters, $dst);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void runAndWait$lambda$0(Runnable $action, CountDownLatch $doneLatch) {
            try {
                $action.run();
            }
            finally {
                $doneLatch.countDown();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

