/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AveragingJavaFXLayer;
import org.mkui.canvas.BufferedJavaFXLayer;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.DensityJavaFXLayer;
import org.mkui.canvas.DirectJavaFXLayer;
import org.mkui.canvas.GraphicsContextDrawing;
import org.mkui.canvas.JavaFXLayer;
import org.mkui.canvas.JavaFXMouseEvent;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelEvent;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.canvas.ResizableCanvas;
import org.mkui.component.CPInteractiveComponent;
import org.mkui.graphics.CPGraphicsContext2D;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IDrawingListener;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0001NB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006J.\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u001a\u0010+\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\tH\u0016J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\u001fH\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\fH\u0016J\u0018\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0014J\u0006\u00109\u001a\u00020\u001fJ\u0006\u0010:\u001a\u00020\u001fJ\u0010\u0010;\u001a\u00020\u001f2\u0006\u00104\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001f2\u0006\u00104\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001f2\u0006\u00104\u001a\u00020<H\u0016J\u0010\u0010@\u001a\u00020\u001f2\u0006\u00104\u001a\u00020>H\u0016J\u000e\u0010A\u001a\u00020\u001f2\u0006\u00104\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u001f2\u0006\u00104\u001a\u00020DJ\u000e\u0010E\u001a\u00020\u001f2\u0006\u00104\u001a\u00020FJ\u000e\u0010K\u001a\u00020\u001f2\u0006\u00104\u001a\u00020BJ\u000e\u0010L\u001a\u00020\u001f2\u0006\u00104\u001a\u00020DJ\u000e\u0010M\u001a\u00020\u001f2\u0006\u00104\u001a\u00020FR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010G\u001a\u00020H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006O"}, d2={"Lorg/mkui/canvas/CPCanvas;", "Lorg/mkui/component/CPInteractiveComponent;", "<init>", "()V", "layers", "", "Lorg/mkui/canvas/JavaFXLayer;", "drawings", "", "Lorg/mkui/graphics/IDrawing;", "Lorg/mkui/graphics/IDrawingListener;", "listeners", "Lorg/mkui/canvas/CanvasListener;", "showTiming", "Lcom/macrofocus/common/properties/MutableProperty;", "", "getShowTiming", "()Lcom/macrofocus/common/properties/MutableProperty;", "nativeComponent", "Ljavafx/scene/layout/StackPane;", "getNativeComponent", "()Ljavafx/scene/layout/StackPane;", "canvas", "Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "listener", "Ljavafx/beans/InvalidationListener;", "getListener", "()Ljavafx/beans/InvalidationListener;", "addLayer", "", "d", "Lorg/mkui/canvas/GraphicsContextDrawing;", "addNativeLayer", "addDensityLayer", "rendering", "Lorg/mkui/canvas/Rendering;", "iDrawing", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "addAveragingLayer", "addBufferedLayer", "registerDrawing", "drawing", "removeAllLayers", "getWidth", "", "getHeight", "addCanvasListener", "l", "notifySizeChanged", "width", "", "height", "refresh", "redraw", "addMouseListener", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "removeMouseListener", "removeMouseMotionListener", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "addKeyListener", "Lorg/mkui/canvas/KeyListener;", "addContextMenuListener", "Lorg/mkui/canvas/ContextMenuListener;", "igraphics", "Lorg/mkui/graphics/IGraphics;", "getIgraphics", "()Lorg/mkui/graphics/IGraphics;", "removeMouseWheelListener", "removeKeyListener", "removeContextMenuListener", "CanvasComponent", "mkui"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPInteractiveComponent {
    @NotNull
    private final List<JavaFXLayer> layers = new CopyOnWriteArrayList();
    @NotNull
    private final Map<IDrawing, IDrawingListener> drawings = new ConcurrentHashMap();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final MutableProperty<Boolean> showTiming = (MutableProperty)new SimpleProperty((Object)false);
    @NotNull
    private final StackPane nativeComponent = new StackPane();
    @NotNull
    private final CanvasComponent canvas = new CanvasComponent();
    @NotNull
    private final InvalidationListener listener = arg_0 -> CPCanvas.listener$lambda$0(this, arg_0);
    public static final int $stable = 8;

    public CPCanvas() {
        this.canvas.widthProperty().addListener(this.listener);
        this.canvas.heightProperty().addListener(this.listener);
        ObservableList observableList = this.nativeComponent.getChildren();
        Intrinsics.checkNotNull((Object)observableList);
        observableList.add((Object)this.canvas);
        this.canvas.widthProperty().bind((ObservableValue)this.nativeComponent.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.nativeComponent.heightProperty());
        this.canvas.schedulePrepare();
    }

    @NotNull
    public final MutableProperty<Boolean> getShowTiming() {
        return this.showTiming;
    }

    @NotNull
    public final StackPane getNativeComponent() {
        return this.nativeComponent;
    }

    @NotNull
    public final CanvasComponent getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final InvalidationListener getListener() {
        return this.listener;
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(new JavaFXLayer(d, this){
            final /* synthetic */ GraphicsContextDrawing $d;
            final /* synthetic */ CPCanvas this$0;
            {
                this.$d = $d;
                this.this$0 = $receiver;
            }

            public void prepare(int width, int height) {
            }

            public void render(GraphicsContext g2) {
                GraphicsContext graphicsContext = g2;
                Intrinsics.checkNotNull((Object)graphicsContext);
                this.$d.draw(new CPGraphicsContext2D(graphicsContext), this.this$0.getWidth(), this.this$0.getHeight());
            }
        });
    }

    public final void addNativeLayer(@NotNull JavaFXLayer d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(d);
    }

    public void addDensityLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing, @Nullable Pressure pressure, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        JavaFXLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                layer = new DensityJavaFXLayer(iDrawing, 0, 0, true, pressure, paletteProvider);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 2: {
                double alpha = 0.5;
                PaletteProvider paletteProvider2 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider2);
                layer = new BufferedJavaFXLayer(iDrawing, true, paletteProvider2.getPalette().getColor(1.0), alpha);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 3: {
                PaletteProvider paletteProvider3 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider3);
                layer = new BufferedJavaFXLayer(iDrawing, true, paletteProvider3.getPalette().getColor(1.0), null);
                boolean bl = this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ JavaFXLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        JavaFXLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                layer = new AveragingJavaFXLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 2: {
                layer = new BufferedJavaFXLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 3: {
                layer = new BufferedJavaFXLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ JavaFXLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        DirectJavaFXLayer layer = new DirectJavaFXLayer(iDrawing);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(this){
            final /* synthetic */ CPCanvas this$0;
            {
                this.this$0 = $receiver;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().scheduleRender();
            }
        });
        this.canvas.schedulePrepare();
    }

    public void addBufferedLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        BufferedJavaFXLayer layer = new BufferedJavaFXLayer(iDrawing, true);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ BufferedJavaFXLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    private final void registerDrawing(IDrawing drawing, IDrawingListener listener2) {
        this.drawings.put(drawing, listener2);
        drawing.addIDrawingListener(listener2);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            IDrawing key = entry.getKey();
            IDrawingListener value = entry.getValue();
            key.removeIDrawingListener(value);
        }
        this.drawings.clear();
    }

    public double getWidth() {
        return this.nativeComponent.getWidth();
    }

    public double getHeight() {
        return this.nativeComponent.getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener2 : this.listeners) {
            listener2.sizeChange(width, height);
        }
    }

    public final void refresh() {
        this.canvas.schedulePrepare();
    }

    public final void redraw() {
        this.canvas.scheduleRender();
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.setOnMouseClicked(arg_0 -> CPCanvas.addMouseListener$lambda$0(l, arg_0));
        this.canvas.setOnMousePressed(arg_0 -> CPCanvas.addMouseListener$lambda$1(l, arg_0));
        this.canvas.setOnMouseReleased(arg_0 -> CPCanvas.addMouseListener$lambda$2(l, arg_0));
        this.canvas.setOnMouseEntered(arg_0 -> CPCanvas.addMouseListener$lambda$3(l, arg_0));
        this.canvas.setOnMouseExited(arg_0 -> CPCanvas.addMouseListener$lambda$4(l, arg_0));
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.setOnMouseDragged(arg_0 -> CPCanvas.addMouseMotionListener$lambda$0(l, arg_0));
        this.canvas.setOnMouseMoved(arg_0 -> CPCanvas.addMouseMotionListener$lambda$1(l, arg_0));
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public void removeMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        throw new NotImplementedError(null, 1, null);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.setOnScroll(arg_0 -> CPCanvas.addMouseWheelListener$lambda$0(l, arg_0));
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    @NotNull
    public final IGraphics getIgraphics() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void removeMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    public final void removeKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    public final void removeContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    private static final void listener$lambda$0(CPCanvas this$0, Observable it) {
        this$0.notifySizeChanged((int)this$0.getWidth(), (int)this$0.getHeight());
        this$0.canvas.schedulePrepare();
    }

    private static final void addMouseListener$lambda$0(MouseListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseClicked(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseListener$lambda$1(MouseListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mousePressed(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseListener$lambda$2(MouseListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseReleased(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseListener$lambda$3(MouseListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseEntered(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseListener$lambda$4(MouseListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseExited(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseMotionListener$lambda$0(MouseMotionListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseDragged(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseMotionListener$lambda$1(MouseMotionListener $l, MouseEvent event) {
        MouseEvent mouseEvent = event;
        Intrinsics.checkNotNull((Object)mouseEvent);
        $l.mouseMoved(new JavaFXMouseEvent(mouseEvent));
    }

    private static final void addMouseWheelListener$lambda$0(MouseWheelListener $l, ScrollEvent event) {
        $l.mouseWheelMoved(new MouseWheelEvent(event){
            final /* synthetic */ ScrollEvent $event;
            {
                this.$event = $event;
            }

            public int getX() {
                return (int)this.$event.getX();
            }

            public int getY() {
                return (int)this.$event.getY();
            }

            public double getWheelRotation() {
                return -this.$event.getDeltaY();
            }
        });
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0006\u0010\u0013\u001a\u00020\u000eR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "Lorg/mkui/canvas/ResizableCanvas;", "<init>", "(Lorg/mkui/canvas/CPCanvas;)V", "dirtyLayers", "", "Lorg/mkui/canvas/JavaFXLayer;", "prepareTimer", "Lcom/macrofocus/common/timer/CPTimer;", "getPrepareTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "renderTimer", "getRenderTimer", "CanvasComponent", "", "schedulePrepare", "layer", "prepare", "render", "scheduleRender", "mkui"})
    public final class CanvasComponent
    extends ResizableCanvas {
        @NotNull
        private final Set<JavaFXLayer> dirtyLayers = new HashSet();
        @NotNull
        private final CPTimer prepareTimer = CPHelper.Companion.getInstance().createTimer("CanvasPrepareTimer", 40, true, new CPTimerListener(this){
            final /* synthetic */ CanvasComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void timerTriggered() {
                CanvasComponent.access$prepare(this.this$0);
            }
        });
        @NotNull
        private final CPTimer renderTimer = CPHelper.Companion.getInstance().createTimer("CanvasRenderTimer", 40, false, new CPTimerListener(CPCanvas.this, this){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ CanvasComponent this$1;
            {
                this.this$0 = $receiver;
                this.this$1 = $receiver2;
            }

            public void timerTriggered() {
                if (Platform.isFxApplicationThread()) {
                    if (this.this$0.getCanvas().isVisible()) {
                        CanvasComponent.access$render(this.this$1);
                    }
                } else {
                    Platform.runLater(() -> renderTimer.1.timerTriggered$lambda$0(this.this$0, this.this$1));
                }
            }

            private static final void timerTriggered$lambda$0(CPCanvas this$0, CanvasComponent this$1) {
                if (this$0.getCanvas().isVisible()) {
                    CanvasComponent.access$render(this$1);
                }
            }
        });

        @NotNull
        protected final CPTimer getPrepareTimer() {
            return this.prepareTimer;
        }

        @NotNull
        protected final CPTimer getRenderTimer() {
            return this.renderTimer;
        }

        private final void CanvasComponent() {
        }

        public final void schedulePrepare(@NotNull JavaFXLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            this.dirtyLayers.add(layer);
            this.prepareTimer.restart();
        }

        public final void schedulePrepare() {
            for (JavaFXLayer layer : CPCanvas.this.layers) {
                this.dirtyLayers.add(layer);
            }
            this.prepareTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void prepare() {
            double width = this.getWidth();
            double height = this.getHeight();
            ArrayList dirtyLayers = null;
            Set<JavaFXLayer> set = this.dirtyLayers;
            synchronized (set) {
                boolean bl = false;
                dirtyLayers = new ArrayList(this.dirtyLayers);
                this.dirtyLayers.clear();
                Unit unit = Unit.INSTANCE;
            }
            Iterator iterator = ((List)dirtyLayers).iterator();
            while (iterator.hasNext()) {
                JavaFXLayer layer;
                JavaFXLayer javaFXLayer = layer = (JavaFXLayer)iterator.next();
                Intrinsics.checkNotNull((Object)javaFXLayer);
                javaFXLayer.prepare((int)width, (int)height);
            }
            this.scheduleRender();
        }

        private final void render() {
            GraphicsContext graphicsContext2D = this.getGraphicsContext2D();
            graphicsContext2D.clearRect(0.0, 0.0, CPCanvas.this.getCanvas().getWidth(), CPCanvas.this.getCanvas().getHeight());
            for (JavaFXLayer layer : CPCanvas.this.layers) {
                graphicsContext2D.save();
                layer.render(graphicsContext2D);
                graphicsContext2D.restore();
            }
            double width = this.getWidth();
            double height = this.getHeight();
        }

        public final void scheduleRender() {
            this.renderTimer.restart();
        }

        public static final /* synthetic */ void access$prepare(CanvasComponent $this) {
            $this.prepare();
        }

        public static final /* synthetic */ void access$render(CanvasComponent $this) {
            $this.render();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rendering.values().length];
            try {
                nArray[Rendering.Density.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.AlphaBlended.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Opaque.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

