/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AbstractDensityLayer;
import org.mkui.canvas.JavaFXLayer;
import org.mkui.canvas.PaletteProvider;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u0006R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/mkui/canvas/DensityJavaFXLayer;", "Lorg/mkui/canvas/AbstractDensityLayer;", "Lorg/mkui/canvas/JavaFXLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "width", "", "height", "antialiasing", "", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "palette", "Lorg/mkui/canvas/PaletteProvider;", "<init>", "(Lorg/mkui/graphics/IDrawing;IIZLorg/mkui/graphics/pressure/Pressure;Lorg/mkui/canvas/PaletteProvider;)V", "image", "Ljavafx/scene/image/WritableImage;", "prepare", "", "resize", "render", "g", "Ljavafx/scene/canvas/GraphicsContext;", "createAntiAliasedImage", "img", "clear", "computeMax", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class DensityJavaFXLayer
extends AbstractDensityLayer
implements JavaFXLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean antialiasing;
    @NotNull
    private final IDrawing iDrawing;
    @Nullable
    private WritableImage image;
    @Nullable
    private final Pressure pressure;
    @Nullable
    private final PaletteProvider palette;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = false;

    public DensityJavaFXLayer(@NotNull IDrawing iDrawing, int width, int height, boolean antialiasing, @Nullable Pressure pressure, @Nullable PaletteProvider palette) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.antialiasing = antialiasing;
        this.iDrawing = iDrawing;
        this.resize(width, height);
        this.pressure = pressure;
        this.palette = palette;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            this.iDrawing.draw(this.getG(), null, this.getWidth(), this.getHeight(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            int m = this.computeMax();
            Pressure pressure = this.pressure;
            Intrinsics.checkNotNull((Object)pressure);
            double min = pressure.transform(1.0);
            Pressure pressure2 = this.pressure;
            Intrinsics.checkNotNull((Object)pressure2);
            double max = pressure2.transform(m);
            WritableImage writableImage = this.image;
            Intrinsics.checkNotNull((Object)writableImage);
            PixelWriter pixelWriter = writableImage.getPixelWriter();
            double range = max - min;
            int n = this.getOverlay().length;
            for (int i = 0; i < n; ++i) {
                int v = this.getOverlay()[i];
                if (v > 0) {
                    Pressure pressure3 = this.pressure;
                    Intrinsics.checkNotNull((Object)pressure3);
                    double value = pressure3.transform(v);
                    PaletteProvider paletteProvider = this.palette;
                    Intrinsics.checkNotNull((Object)paletteProvider);
                    int color = (int)(value * (double)(paletteProvider.getPalette().getColorCount() - 1) / range);
                    pixelWriter.setColor(i % width, i / width, this.palette.getPalette().getColorAt(color));
                    continue;
                }
                pixelWriter.setArgb(i % width, i / width, 0xFFFFFF);
            }
            if (this.antialiasing) {
                this.image = this.createAntiAliasedImage(this.image);
            }
        }
    }

    public final void resize(int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            WritableImage bufferedImage = new WritableImage(width, height);
            int[] o = new int[width * height];
            this.setWidth(width);
            this.setHeight(height);
            this.image = bufferedImage;
            this.setOverlay(o);
            this.setCx1(0);
            this.setCy1(0);
            this.setCx2(width - 1);
            this.setCy2(height - 1);
        } else {
            this.clear();
        }
    }

    @Override
    public void render(@Nullable GraphicsContext g2) {
        if (this.iDrawing.isActive() && this.image != null) {
            GraphicsContext graphicsContext = g2;
            Intrinsics.checkNotNull((Object)graphicsContext);
            graphicsContext.drawImage((Image)this.image, 0.0, 0.0);
        }
    }

    private final WritableImage createAntiAliasedImage(WritableImage img) {
        return img;
    }

    public final void clear() {
        if (this.image != null) {
            Arrays.fill(this.getOverlay(), 0);
        }
    }

    public final int computeMax() {
        int max = 0;
        for (int v : this.getOverlay()) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/mkui/canvas/DensityJavaFXLayer$Companion;", "", "<init>", "()V", "MULTITHREADED", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

