/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.JavaFXFontMetrics;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.IGraphics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\b\u0007\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\f\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0017J\u0012\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010*\u001a\u00020\t2\u000e\u0010+\u001a\n\u0018\u00010,j\u0004\u0018\u0001`-H\u0016J\u0010\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J \u00103\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\u0010\u00107\u001a\u0002052\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00108\u001a\u0002052\u0006\u0010/\u001a\u000200H\u0016J\b\u00109\u001a\u00020\u0007H\u0016J\b\u0010:\u001a\u00020\u0007H\u0016J\u0018\u0010;\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0016J\u0010\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\u0007H\u0016J\b\u0010>\u001a\u00020\tH\u0016J\u0018\u0010?\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0016J\u0018\u0010@\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0016J\b\u0010A\u001a\u00020\tH\u0016J\b\u0010B\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/mkui/canvas/JavaFXIGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "context", "Ljavafx/scene/canvas/GraphicsContext;", "<init>", "(Ljavafx/scene/canvas/GraphicsContext;)V", "getLineWidth", "", "setLineWidth", "", "lineWidth", "setLineDash", "dashPattern", "", "getColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "setColor", "color", "setGlobalAlpha", "alpha", "draw", "geometry", "Lorg/mkui/geom/Shape;", "getContext", "fill", "drawLine", "x1", "", "y1", "x2", "y2", "drawRectangle", "rectangle", "Lorg/mkui/geom/Rectangle2D;", "fillRectangle2D", "fillCircle", "drawPath", "path", "setTextBaseline", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "setFont", "font", "Ljavafx/scene/text/Font;", "Lorg/mkui/font/MkFont;", "getStringBounds", "text", "", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "drawString", "x", "", "y", "getStringWidth", "getStringHeight", "getAscent", "getDescent", "translate", "rotate", "theta", "beginPath", "moveTo", "lineTo", "closePath", "stroke", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class JavaFXIGraphics
extends AbstractIGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphicsContext context;
    public static final int $stable = 8;

    public JavaFXIGraphics(@NotNull GraphicsContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public double getLineWidth() {
        return this.context.getLineWidth();
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.context.setLineWidth(lineWidth);
    }

    @Override
    public void setLineDash(@Nullable float[] dashPattern) {
        double[] dArray = JavaFXIGraphics.Companion.convertFloatsToDoubles(dashPattern);
        this.context.setLineDashes(Arrays.copyOf(dArray, dArray.length));
    }

    @Override
    @NotNull
    public Color getColor() {
        Paint paint = this.context.getFill();
        Intrinsics.checkNotNull((Object)paint, (String)"null cannot be cast to non-null type javafx.scene.paint.Color");
        return MkColorKt.colorOf((Color)paint);
    }

    @Override
    public void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.context.setFill((Paint)color);
        this.context.setStroke((Paint)color);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.context.setGlobalAlpha(alpha);
    }

    @Override
    protected void draw(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (this.context != null) {
            GraphicsContext context = this.getContext();
            this.drawPath(geometry);
            context.stroke();
        }
    }

    @NotNull
    public final GraphicsContext getContext() {
        return this.context;
    }

    @Override
    protected void fill(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (this.context != null) {
            GraphicsContext context = this.getContext();
            this.drawPath(geometry);
            context.fill();
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.strokeLine(x1, y1, x2, y2);
    }

    public final void drawRectangle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        GraphicsContext context = this.getContext();
        context.rect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    @Override
    public void fillRectangle2D(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.context.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    @Override
    public void fillCircle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.context.fillOval(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public final void drawPath(@NotNull Shape path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GraphicsContext context = this.getContext();
        PathIterator iterator = Shape.getPathIterator$default(path, null, 1, null);
        double[] coords = new double[6];
        context.beginPath();
        while (!iterator.isDone()) {
            int segment = iterator.currentSegment(coords);
            switch (segment) {
                case 0: {
                    context.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    context.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    context.quadraticCurveTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    context.bezierCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    context.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Segment " + segment);
                }
            }
            iterator.next();
        }
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        switch (textBaseline == null ? -1 : WhenMappings.$EnumSwitchMapping$0[textBaseline.ordinal()]) {
            case 1: {
                this.context.setTextBaseline(VPos.TOP);
                break;
            }
            case 2: {
                this.context.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case 3: {
                this.context.setTextBaseline(VPos.CENTER);
                break;
            }
            case 4: {
                this.context.setTextBaseline(VPos.BASELINE);
                break;
            }
            case 5: {
                throw new UnsupportedOperationException();
            }
            case 6: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setFont(@Nullable Font font) {
        Font font2 = font;
        Intrinsics.checkNotNull((Object)font2);
        this.context.setFont(font2);
    }

    @Override
    @NotNull
    public Rectangle2D getStringBounds(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Text t = new Text(text);
        t.setFont(this.context.getFont());
        Bounds bounds = t.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"getLayoutBounds(...)");
        Bounds stringBounds = bounds;
        return new Rectangle2D.Double(stringBounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @Override
    @NotNull
    public CPFontMetrics getFontMetrics() {
        return new JavaFXFontMetrics(this.context);
    }

    @Override
    public void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.context.fillText(text, (double)x, (double)y);
    }

    @Override
    public float getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (float)this.getStringBounds(text).getWidth();
    }

    @Override
    public float getStringHeight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (float)this.getStringBounds(text).getHeight();
    }

    @Override
    public double getAscent() {
        return this.context.getFont().getSize();
    }

    @Override
    public double getDescent() {
        return 0.0;
    }

    @Override
    public void translate(int x, int y) {
        this.context.translate((double)x, (double)y);
    }

    @Override
    public void rotate(double theta) {
        this.context.rotate(Math.toDegrees(theta));
    }

    @Override
    public void beginPath() {
        this.context.beginPath();
    }

    @Override
    public void moveTo(double x, double y) {
        this.context.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.context.lineTo(x, y);
    }

    @Override
    public void closePath() {
        this.context.closePath();
    }

    @Override
    public void stroke() {
        this.context.stroke();
    }

    @Override
    public void fill() {
        this.context.fill();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/mkui/canvas/JavaFXIGraphics$Companion;", "", "<init>", "()V", "convertFloatsToDoubles", "", "input", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final double[] convertFloatsToDoubles(float[] input) {
            Intrinsics.checkNotNull((Object)input);
            double[] output = new double[input.length];
            int n = input.length;
            for (int i = 0; i < n; ++i) {
                output[i] = input[i];
            }
            return output;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IGraphics.TextBaseline.values().length];
            try {
                nArray[IGraphics.TextBaseline.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Middle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Alphabetic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Hanging.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Ideographic.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

