/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.coloring.implementation;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.coloring.MutableColoring;
import org.mkui.coloring.implementation.AbstractColoring;
import org.mkui.coloring.implementation.SimpleColoringEvent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0096\u0082\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00028\u00002\u000e\u0010\u0019\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u0016\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u000e\u0010\u0019\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u0016\u00a2\u0006\u0002\u0010\u001eR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/mkui/coloring/implementation/SimpleColoring;", "E", "Lorg/mkui/coloring/implementation/AbstractColoring;", "Lorg/mkui/coloring/MutableColoring;", "<init>", "()V", "coloring", "", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "coloredCount", "", "getColoredCount", "()I", "isColored", "", "element", "(Ljava/lang/Object;)Z", "getColor", "(Ljava/lang/Object;)Ljavafx/scene/paint/Color;", "iterator", "", "clearColoring", "", "setColor", "color", "(Ljava/lang/Object;Ljavafx/scene/paint/Color;)V", "setColorElements", "elements", "", "(Ljava/lang/Iterable;Ljavafx/scene/paint/Color;)V", "mkui"})
@StabilityInferred(parameters=0)
public final class SimpleColoring<E>
extends AbstractColoring<E>
implements MutableColoring<E> {
    @NotNull
    private final Map<E, Color> coloring = new HashMap();
    public static final int $stable = 8;

    @Override
    public int getColoredCount() {
        return this.coloring.size();
    }

    @Override
    public boolean isColored(E element) {
        return this.coloring.containsKey(element);
    }

    @Override
    @Nullable
    public Color getColor(E element) {
        return this.coloring.get(element);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.coloring.keySet().iterator();
    }

    @Override
    public void clearColoring() {
        Set changes = new HashSet();
        for (E e : this) {
            changes.add(e);
        }
        this.coloring.clear();
        this.notifyColoringChanged(new SimpleColoringEvent(changes));
    }

    @Override
    public void setColor(E element, @Nullable Color color) {
        if (color != null) {
            Set changes = new HashSet();
            changes.add(element);
            this.coloring.put(element, color);
            this.notifyColoringChanged(new SimpleColoringEvent(changes));
        } else if (this.isColored(element)) {
            Set changes = new HashSet();
            changes.add(element);
            this.coloring.remove(element);
            this.notifyColoringChanged(new SimpleColoringEvent(changes));
        }
    }

    @Override
    public void setColorElements(@NotNull Iterable<? extends E> elements, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (color != null) {
            Set changes = new HashSet();
            for (E element : elements) {
                changes.add(element);
                this.coloring.put(element, color);
            }
            if (changes.size() > 0) {
                this.notifyColoringChanged(new SimpleColoringEvent(changes));
            }
        } else {
            Set changes = new HashSet();
            for (E element : elements) {
                if (!this.isColored(element)) continue;
                changes.add(element);
                this.coloring.remove(element);
            }
            if (changes.size() > 0) {
                this.notifyColoringChanged(new SimpleColoringEvent(changes));
            }
        }
    }
}

