/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.component.input;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Spinner;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.component.input.FontPicker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/mkui/component/input/FontPickerContent;", "Ljavafx/scene/layout/GridPane;", "fontPicker", "Lorg/mkui/component/input/FontPicker;", "<init>", "(Lorg/mkui/component/input/FontPicker;)V", "newFont", "Ljavafx/scene/text/Font;", "previewLabel", "Ljavafx/scene/control/Label;", "fontComboBox", "Ljavafx/scene/control/ComboBox;", "", "sizeSpinner", "Ljavafx/scene/control/Spinner;", "", "boldCheckBox", "Ljavafx/scene/control/CheckBox;", "italicCheckBox", "initGui", "", "changeFont", "updateSelection", "font", "mkui"})
@StabilityInferred(parameters=0)
public final class FontPickerContent
extends GridPane {
    @NotNull
    private final FontPicker fontPicker;
    @Nullable
    private Font newFont;
    @Nullable
    private Label previewLabel;
    @Nullable
    private ComboBox<String> fontComboBox;
    @Nullable
    private Spinner<Number> sizeSpinner;
    @Nullable
    private CheckBox boldCheckBox;
    @Nullable
    private CheckBox italicCheckBox;
    public static final int $stable = 8;

    public FontPickerContent(@NotNull FontPicker fontPicker) {
        Intrinsics.checkNotNullParameter((Object)((Object)fontPicker), (String)"fontPicker");
        this.fontPicker = fontPicker;
        this.getStyleClass().add((Object)"font-picker-popup");
        this.initGui();
    }

    private final void initGui() {
        double d;
        this.setPrefSize(200.0, 230.0);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("font-picker.css").toExternalForm());
        Object[] objectArray = new ColumnConstraints[]{new ColumnConstraints(40.0), new ColumnConstraints(160.0)};
        this.getColumnConstraints().addAll(objectArray);
        objectArray = new RowConstraints[]{new RowConstraints(20.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(30.0), new RowConstraints(30.0), new RowConstraints(30.0)};
        this.getRowConstraints().addAll(objectArray);
        this.add((Node)new Label("Preview:"), 0, 0, 2, 1);
        Label label = this.previewLabel = new Label("ABCDEF abcdef 0123456");
        Intrinsics.checkNotNull((Object)label);
        label.setMaxWidth(Double.MAX_VALUE);
        Label label2 = this.previewLabel;
        Intrinsics.checkNotNull((Object)label2);
        label2.setMaxHeight(Double.MAX_VALUE);
        Label label3 = this.previewLabel;
        Intrinsics.checkNotNull((Object)label3);
        label3.getStyleClass().add((Object)"preview-label");
        this.add((Node)this.previewLabel, 0, 1, 2, 2);
        this.add((Node)new Label("Font:"), 0, 3, 1, 1);
        List families = Font.getFamilies();
        this.fontComboBox = new ComboBox(FXCollections.observableList((List)families));
        ComboBox<String> comboBox = this.fontComboBox;
        Intrinsics.checkNotNull(comboBox);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        this.add((Node)this.fontComboBox, 1, 3, 1, 1);
        this.add((Node)new Label("Size:"), 0, 4, 1, 1);
        if (this.fontPicker.getValue() != null) {
            Object object = this.fontPicker.getValue();
            Intrinsics.checkNotNull((Object)object);
            d = ((Font)object).getSize();
        } else {
            d = 12.0;
        }
        this.sizeSpinner = new Spinner(1.0, 100.0, d);
        Spinner<Number> spinner = this.sizeSpinner;
        Intrinsics.checkNotNull(spinner);
        spinner.setEditable(true);
        Spinner<Number> spinner2 = this.sizeSpinner;
        Intrinsics.checkNotNull(spinner2);
        spinner2.setPrefWidth(70.0);
        this.add((Node)this.sizeSpinner, 1, 4, 1, 1);
        this.add((Node)new Label("Style:"), 0, 5, 1, 1);
        this.boldCheckBox = new CheckBox("Bold");
        this.italicCheckBox = new CheckBox("Italic");
        HBox styleHBox = new HBox(10.0);
        styleHBox.setAlignment(Pos.CENTER_LEFT);
        Object[] objectArray2 = new Node[]{this.boldCheckBox, this.italicCheckBox};
        styleHBox.getChildren().addAll(objectArray2);
        this.add((Node)styleHBox, 1, 5, 1, 1);
        Button okButton = new Button("OK");
        okButton.setPrefWidth(55.0);
        Button cancelButton = new Button("Cancel");
        cancelButton.setPrefWidth(55.0);
        HBox buttonsHBox = new HBox(5.0);
        buttonsHBox.setAlignment(Pos.CENTER_RIGHT);
        Object[] objectArray3 = new Node[]{okButton, cancelButton};
        buttonsHBox.getChildren().addAll(objectArray3);
        this.add((Node)buttonsHBox, 1, 6, 1, 1);
        if (this.fontPicker.getValue() != null) {
            ComboBox<String> comboBox2 = this.fontComboBox;
            Intrinsics.checkNotNull(comboBox2);
            SingleSelectionModel singleSelectionModel = comboBox2.getSelectionModel();
            Object object = this.fontPicker.getValue();
            Intrinsics.checkNotNull((Object)object);
            singleSelectionModel.select((Object)((Font)object).getName());
        } else {
            ComboBox<String> comboBox3 = this.fontComboBox;
            Intrinsics.checkNotNull(comboBox3);
            comboBox3.getSelectionModel().select(0);
        }
        ComboBox<String> comboBox4 = this.fontComboBox;
        Intrinsics.checkNotNull(comboBox4);
        comboBox4.valueProperty().addListener(arg_0 -> FontPickerContent.initGui$lambda$0(this, arg_0));
        ComboBox<String> comboBox5 = this.fontComboBox;
        Intrinsics.checkNotNull(comboBox5);
        comboBox5.setCellFactory(FontPickerContent::initGui$lambda$1);
        StringConverter spinnerFormatter2 = (StringConverter)new StringConverter<Number>(this){
            final /* synthetic */ FontPickerContent this$0;
            {
                this.this$0 = $receiver;
            }

            public Number fromString(String val) {
                Intrinsics.checkNotNullParameter((Object)val, (String)"val");
                Spinner spinner = FontPickerContent.access$getSizeSpinner$p(this.this$0);
                Intrinsics.checkNotNull((Object)spinner);
                String oldVal = ((Number)spinner.getValue()).toString();
                try {
                    int result = Integer.parseInt(val);
                    if (result >= 1 && result <= 100) {
                        return result;
                    }
                    throw new Exception("");
                }
                catch (Exception e) {
                    Spinner spinner2 = FontPickerContent.access$getSizeSpinner$p(this.this$0);
                    Intrinsics.checkNotNull((Object)spinner2);
                    spinner2.getEditor().setText(oldVal);
                    Spinner spinner3 = FontPickerContent.access$getSizeSpinner$p(this.this$0);
                    Intrinsics.checkNotNull((Object)spinner3);
                    Object object = spinner3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    return (Number)object;
                }
            }

            public String toString(Number val) {
                Intrinsics.checkNotNullParameter((Object)val, (String)"val");
                return val.toString();
            }
        };
        Spinner<Number> spinner3 = this.sizeSpinner;
        Intrinsics.checkNotNull(spinner3);
        spinner3.getValueFactory().setConverter(spinnerFormatter2);
        Spinner<Number> spinner4 = this.sizeSpinner;
        Intrinsics.checkNotNull(spinner4);
        spinner4.valueProperty().addListener(arg_0 -> FontPickerContent.initGui$lambda$2(this, arg_0));
        CheckBox checkBox = this.boldCheckBox;
        Intrinsics.checkNotNull((Object)checkBox);
        checkBox.selectedProperty().addListener(arg_0 -> FontPickerContent.initGui$lambda$3(this, arg_0));
        CheckBox checkBox2 = this.italicCheckBox;
        Intrinsics.checkNotNull((Object)checkBox2);
        checkBox2.selectedProperty().addListener(arg_0 -> FontPickerContent.initGui$lambda$4(this, arg_0));
        okButton.setOnAction(arg_0 -> FontPickerContent.initGui$lambda$5(this, arg_0));
        cancelButton.setOnAction(arg_0 -> FontPickerContent.initGui$lambda$6(this, arg_0));
        this.changeFont();
    }

    private final void changeFont() {
        Font font;
        CheckBox checkBox = this.boldCheckBox;
        Intrinsics.checkNotNull((Object)checkBox);
        FontWeight weight = checkBox.isSelected() ? FontWeight.BOLD : FontWeight.NORMAL;
        CheckBox checkBox2 = this.italicCheckBox;
        Intrinsics.checkNotNull((Object)checkBox2);
        FontPosture posture = checkBox2.isSelected() ? FontPosture.ITALIC : FontPosture.REGULAR;
        Spinner<Number> spinner = this.sizeSpinner;
        Intrinsics.checkNotNull(spinner);
        double size = ((Number)spinner.getValue()).doubleValue();
        ComboBox<String> comboBox = this.fontComboBox;
        Intrinsics.checkNotNull(comboBox);
        String family = (String)comboBox.getValue();
        this.newFont = font = Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
        Label label = this.previewLabel;
        Intrinsics.checkNotNull((Object)label);
        label.setFont(font);
    }

    public final void updateSelection(@Nullable Font font) {
        this.newFont = font;
        Label label = this.previewLabel;
        Intrinsics.checkNotNull((Object)label);
        label.setFont(font);
    }

    private static final void initGui$lambda$0(FontPickerContent this$0, Observable observable2) {
        this$0.changeFont();
    }

    private static final ListCell initGui$lambda$1(ListView listView) {
        ListCell cell2 = (ListCell)new ListCell<String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item);
                    this.setFont(new Font(item, 12.0));
                }
            }
        };
        cell2.setPrefWidth(120.0);
        return cell2;
    }

    private static final void initGui$lambda$2(FontPickerContent this$0, Observable observable2) {
        this$0.changeFont();
    }

    private static final void initGui$lambda$3(FontPickerContent this$0, Observable observable2) {
        this$0.changeFont();
    }

    private static final void initGui$lambda$4(FontPickerContent this$0, Observable observable2) {
        this$0.changeFont();
    }

    private static final void initGui$lambda$5(FontPickerContent this$0, ActionEvent event) {
        this$0.fontPicker.setValue(this$0.newFont);
        this$0.fontPicker.hide();
    }

    private static final void initGui$lambda$6(FontPickerContent this$0, ActionEvent event) {
        this$0.fontPicker.hide();
    }

    public static final /* synthetic */ Spinner access$getSizeSpinner$p(FontPickerContent $this) {
        return $this.sizeSpinner;
    }
}

