/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.PathIterator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0001\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010 \u001a\u00020!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020%H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/mkui/geom/EllipseIterator;", "Lorg/mkui/geom/PathIterator;", "e", "Lorg/mkui/geom/Ellipse2D;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/Ellipse2D;Lorg/mkui/geom/AffineTransform;)V", "x", "", "getX", "()D", "y", "getY", "w", "getW", "h", "getH", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class EllipseIterator
implements PathIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    @Nullable
    private final AffineTransform affine;
    private int index;
    public static final int $stable = 8;
    public static final double CtrlVal = 0.5522847498307933;
    private static final double pcv = 0.7761423749153966;
    private static final double ncv = 0.22385762508460333;
    @NotNull
    private static final double[][] ctrlpts;

    public EllipseIterator(@NotNull Ellipse2D e, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.x = e.getX();
        this.y = e.getY();
        this.w = e.getWidth();
        this.h = e.getHeight();
        this.affine = at;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("ellipse iterator out of bounds");
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                double[] ctrls = ctrlpts[3];
                coords[0] = (float)(this.x + ctrls[4] * this.w);
                coords[1] = (float)(this.y + ctrls[5] * this.h);
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
            double[] ctrls = ctrlpts[this.index - 1];
            coords[0] = (float)(this.x + ctrls[0] * this.w);
            coords[1] = (float)(this.y + ctrls[1] * this.h);
            coords[2] = (float)(this.x + ctrls[2] * this.w);
            coords[3] = (float)(this.y + ctrls[3] * this.h);
            coords[4] = (float)(this.x + ctrls[4] * this.w);
            coords[5] = (float)(this.y + ctrls[5] * this.h);
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block4;
            affineTransform.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("ellipse iterator out of bounds");
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                double[] ctrls = ctrlpts[3];
                coords[0] = this.x + ctrls[4] * this.w;
                coords[1] = this.y + ctrls[5] * this.h;
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
            double[] ctrls = ctrlpts[this.index - 1];
            coords[0] = this.x + ctrls[0] * this.w;
            coords[1] = this.y + ctrls[1] * this.h;
            coords[2] = this.x + ctrls[2] * this.w;
            coords[3] = this.y + ctrls[3] * this.h;
            coords[4] = this.x + ctrls[4] * this.w;
            coords[5] = this.y + ctrls[5] * this.h;
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block4;
            affineTransform.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    static {
        double[][] dArrayArray = new double[4][];
        double[] dArray = new double[]{1.0, 0.7761423749153966, 0.7761423749153966, 1.0, 0.5, 1.0};
        dArrayArray[0] = dArray;
        dArray = new double[]{0.22385762508460333, 1.0, 0.0, 0.7761423749153966, 0.0, 0.5};
        dArrayArray[1] = dArray;
        dArray = new double[]{0.0, 0.22385762508460333, 0.22385762508460333, 0.0, 0.5, 0.0};
        dArrayArray[2] = dArray;
        dArray = new double[]{0.7761423749153966, 0.0, 1.0, 0.22385762508460333, 1.0, 0.5};
        dArrayArray[3] = dArray;
        ctrlpts = dArrayArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/mkui/geom/EllipseIterator$Companion;", "", "<init>", "()V", "CtrlVal", "", "pcv", "ncv", "ctrlpts", "", "", "[[D", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

