/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ShapeMultiPath;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/mkui/geom/curve/ShapeMultiPathIterator;", "Lorg/mkui/geom/PathIterator;", "smp", "Lorg/mkui/geom/curve/ShapeMultiPath;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/curve/ShapeMultiPath;Lorg/mkui/geom/AffineTransform;)V", "ai0", "", "ai1", "windingRule", "getWindingRule", "()I", "n", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "mkui"})
@StabilityInferred(parameters=0)
public final class ShapeMultiPathIterator
implements PathIterator {
    private final int ai0;
    private final int ai1;
    @Nullable
    private final AffineTransform at;
    @NotNull
    private final ShapeMultiPath smp;
    private final int windingRule;
    private int n;
    public static final int $stable = 8;

    public ShapeMultiPathIterator(@NotNull ShapeMultiPath smp, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)smp, (String)"smp");
        this.smp = smp;
        this.at = at;
        int[] bv = smp.getBasisVectors();
        this.ai0 = bv[0];
        this.ai1 = bv[1];
        this.windingRule = smp.getWindingRule();
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public boolean isDone() {
        return this.n >= this.smp.getNumPoints();
    }

    @Override
    public void next() {
        int n = this.n;
        this.n = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] p = this.smp.get(this.n);
            coords[0] = (float)p[this.ai0];
            coords[1] = (float)p[this.ai1];
            if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
                return 4;
            }
            AffineTransform affineTransform = this.at;
            if (affineTransform == null) break block1;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] p = this.smp.get(this.n);
            coords[0] = p[this.ai0];
            coords[1] = p[this.ai1];
            if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
                return 4;
            }
            AffineTransform affineTransform = this.at;
            if (affineTransform == null) break block1;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }
}

