/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.palette.AbstractMutablePalette;
import org.mkui.palette.Cycle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0004j\u0002`\u00050\u0003\"\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0019\u0010\u0013\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u001c\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0014\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eR$\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lorg/mkui/palette/DynamicPalette;", "Lorg/mkui/palette/AbstractMutablePalette;", "colors", "", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "<init>", "([Ljavafx/scene/paint/Color;)V", "", "(Ljava/util/List;)V", "", "getColors", "()Ljava/util/List;", "setColors", "isInverted", "", "()Z", "setInverted", "(Z)V", "getColor", "fraction", "", "(D)Ljavafx/scene/paint/Color;", "lowestFraction", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "getColorAt", "", "(I)Ljavafx/scene/paint/Color;", "mkui"})
@StabilityInferred(parameters=0)
public class DynamicPalette
extends AbstractMutablePalette {
    @NotNull
    private List<Color> colors;
    private boolean isInverted;
    public static final int $stable = 8;

    @NotNull
    protected final List<Color> getColors() {
        return this.colors;
    }

    protected final void setColors(@NotNull List<Color> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    @Override
    public final boolean isInverted() {
        return this.isInverted;
    }

    public final void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    public DynamicPalette(Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = ArraysKt.toMutableList((Object[])colors);
        this.setColorCount(this.colors.size());
    }

    public DynamicPalette(@NotNull List<Color> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.colors = CollectionsKt.toMutableList((Collection)colors);
        this.setColorCount(this.colors.size());
    }

    @Override
    @NotNull
    public Color getColor(double fraction) {
        Color color;
        double fraction2 = fraction;
        boolean inverted = this.isInverted;
        Cycle cycle = this.getCycle();
        switch (cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
                break;
            }
            default: {
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            color = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            color = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            color = this.colors.get(index);
        }
        return color;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public Color getColorAt(int fraction) {
        return this.getColorCount() == this.colors.size() ? (fraction < 0 ? this.getColorAt(0) : (fraction > this.getColorCount() - 1 ? this.getColorAt(this.getColorCount() - 1) : this.colors.get(fraction))) : this.getColor((double)this.getColorCount() / (double)fraction);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Cycle.values().length];
            try {
                nArray[Cycle.REFLECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Cycle.REPEAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

