/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UnsignedKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.Palette;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0002%&B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u001d\b\u0017\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001d\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u001b\u001a\u00060\u0016j\u0002`\u00172\n\u0010\u001c\u001a\u00060\u0016j\u0002`\u00172\n\u0010\u001d\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0007\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"\u00a8\u0006'"}, d2={"Lorg/mkui/palette/InterpolatedPalette;", "Lorg/mkui/palette/FixedPalette;", "entries", "Lcom/macrofocus/common/collection/SortedSet;", "Lorg/mkui/palette/InterpolatedPalette$Entry;", "<init>", "(Lcom/macrofocus/common/collection/SortedSet;)V", "p", "Lorg/mkui/palette/Palette;", "(Lorg/mkui/palette/Palette;)V", "e", "", "([Lorg/mkui/palette/InterpolatedPalette$Entry;)V", "getEntries", "()Lcom/macrofocus/common/collection/SortedSet;", "setEntries", "mode", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/mkui/palette/InterpolatedPalette$Mode;", "updateFixedColorGradient", "", "computeColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "fraction", "", "(D)Ljavafx/scene/paint/Color;", "interpolate", "c1", "c2", "(Ljavafx/scene/paint/Color;Ljavafx/scene/paint/Color;D)Ljavafx/scene/paint/Color;", "", "lowestFraction", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "Mode", "Entry", "mkui"})
@StabilityInferred(parameters=0)
public final class InterpolatedPalette
extends FixedPalette {
    @NotNull
    private SortedSet<Entry> entries;
    @NotNull
    private final MutableProperty<Mode> mode;
    public static final int $stable = 8;

    public InterpolatedPalette(@NotNull SortedSet<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(false, CollectionsKt.emptyList());
        this.entries = entries;
        this.mode = (MutableProperty)new SimpleProperty((Object)Mode.Ramps);
        this.updateFixedColorGradient();
    }

    @NotNull
    public final SortedSet<Entry> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull SortedSet<Entry> sortedSet) {
        Intrinsics.checkNotNullParameter(sortedSet, (String)"<set-?>");
        this.entries = sortedSet;
    }

    public InterpolatedPalette(@NotNull Palette p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this((SortedSet<Entry>)new SortedSet(new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getFraction()));
            }
        }, null, 2, null));
        int n = p.getColorCount();
        for (int i = 0; i < n; ++i) {
            Color c = p.getColorAt(i);
            this.entries.add((Object)new Entry((double)i / (double)(p.getColorCount() - 1), c));
        }
        this.updateFixedColorGradient();
    }

    public InterpolatedPalette(Entry ... e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this((SortedSet<Entry>)new SortedSet(new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getFraction()));
            }
        }, (Collection)ArraysKt.asList((Object[])e)));
        this.updateFixedColorGradient();
    }

    private final void updateFixedColorGradient() {
        if (!this.entries.isEmpty()) {
            List colors = new ArrayList();
            for (int i = 0; i < 256; ++i) {
                double fraction = 1.0 * (double)i / (double)255;
                Color color = this.computeColor(fraction);
                if (color == null) {
                    throw new IllegalStateException("Null color " + fraction + ", " + color);
                }
                colors.add(color);
            }
            this.setColors(colors);
            this.setColorCount(colors.size());
        } else {
            this.setColors(CollectionsKt.emptyList());
            this.setColorCount(0);
        }
    }

    private final Color computeColor(double fraction) {
        if (!this.entries.isEmpty()) {
            Entry previous = null;
            for (Object e : this.entries) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Entry current = (Entry)e;
                if (previous != null && previous.getFraction() <= fraction && fraction <= current.getFraction()) {
                    double v = (fraction - previous.getFraction()) / (current.getFraction() - previous.getFraction());
                    return this.interpolate(previous.getColor(), current.getColor(), v);
                }
                previous = current;
            }
            if (fraction < ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getColor();
            }
            if (fraction > ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getColor();
            }
        }
        return null;
    }

    private final Color interpolate(Color c1, Color c2, double p) {
        Color color;
        switch (WhenMappings.$EnumSwitchMapping$0[((Mode)((Object)this.mode.getValue())).ordinal()]) {
            case 1: {
                if (p == 0.0) {
                    return c1;
                }
                if (p == 1.0) {
                    color = c2;
                    break;
                }
                color = MkColorKt.colorOf((int)(UnsignedKt.uintToDouble((int)(MkColorKt.getURed(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getURed(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUAlpha(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUAlpha(c2) & 0xFF)) * p));
                break;
            }
            case 2: {
                color = c1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return color;
    }

    @NotNull
    public final Set<Entry> getEntries() {
        return (Set)this.entries;
    }

    @Override
    protected double getLowestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction() : super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction() : super.getHighestFraction();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0082\u0004J\n\u0010\u0014\u001a\u00020\u000fH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/mkui/palette/InterpolatedPalette$Entry;", "", "fraction", "", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "<init>", "(DLjavafx/scene/paint/Color;)V", "getFraction", "()D", "Ljavafx/scene/paint/Color;", "getColor", "()Ljavafx/scene/paint/Color;", "compareTo", "", "other", "equals", "", "", "hashCode", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class Entry
    implements Comparable<Entry> {
        private final double fraction;
        @NotNull
        private final Color color;
        public static final int $stable = 8;

        public Entry(double fraction, @NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.fraction = fraction;
            this.color = color;
        }

        public final double getFraction() {
            return this.fraction;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(@NotNull Entry other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Double.compare(this.fraction, other.fraction);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Entry cfr_ignored_0 = (Entry)other;
            return this.fraction == ((Entry)other).fraction;
        }

        public int hashCode() {
            return Double.hashCode(this.fraction);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/mkui/palette/InterpolatedPalette$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "Ramps", "Bands", "mkui"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Ramps = new Mode();
        public static final /* enum */ Mode Bands = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Ramps, Mode.Bands};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.Ramps.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.Bands.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

