/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.transform;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.transform.MutableOneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.SimpleOneDScreenTransform;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.transform.AbstractMutableTwoDScreenTransform;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\rJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010&\u001a\u00020*2\u0006\u0010(\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020*H\u0016J\u0018\u00100\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u00102\u001a\u00020#H\u0002J\u0010\u00103\u001a\u00020#2\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u00104\u001a\u000205H\u0096\u0080\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00066"}, d2={"Lorg/mkui/transform/SimpleTwoDScreenTransform;", "Lorg/mkui/transform/AbstractMutableTwoDScreenTransform;", "x", "Lcom/macrofocus/common/interval/BoundedInterval;", "y", "screenWidth", "", "screenHeight", "worldAspectRatio", "", "<init>", "(Lcom/macrofocus/common/interval/BoundedInterval;Lcom/macrofocus/common/interval/BoundedInterval;IID)V", "Lcom/macrofocus/common/transform/MutableOneDScreenTransform;", "(Lcom/macrofocus/common/transform/MutableOneDScreenTransform;Lcom/macrofocus/common/transform/MutableOneDScreenTransform;IID)V", "getScreenWidth", "()I", "setScreenWidth", "(I)V", "getScreenHeight", "setScreenHeight", "value", "Lcom/macrofocus/common/interval/Interval;", "xWorldInterval", "getXWorldInterval", "()Lcom/macrofocus/common/interval/Interval;", "yWorldInterval", "getYWorldInterval", "getX", "()Lcom/macrofocus/common/transform/MutableOneDScreenTransform;", "getY", "maintainAspectRatio", "", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "setIntervals", "", "xInterval", "yInterval", "screenToWorld", "Lorg/mkui/geom/Point2D;", "screen", "Lorg/mkui/geom/Point;", "Lorg/mkui/geom/Rectangle2D;", "Lorg/mkui/geom/Rectangle;", "worldToScreen", "world", "isAffine", "()Z", "setScreenSize", "setMaintainAspectRatio", "updateAspectRatio", "setWorldAspectRatio", "toString", "", "mkui"})
@StabilityInferred(parameters=0)
public final class SimpleTwoDScreenTransform
extends AbstractMutableTwoDScreenTransform {
    private int screenWidth;
    private int screenHeight;
    @NotNull
    private Interval xWorldInterval;
    @NotNull
    private Interval yWorldInterval;
    @NotNull
    private final MutableOneDScreenTransform x;
    @NotNull
    private final MutableOneDScreenTransform y;
    private boolean maintainAspectRatio;
    private double worldAspectRatio;
    @NotNull
    private final IntervalListener intervalListener;
    public static final int $stable = 8;

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(int n) {
        this.screenWidth = n;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(int n) {
        this.screenHeight = n;
    }

    @Override
    @NotNull
    public Interval getXWorldInterval() {
        return this.xWorldInterval;
    }

    @Override
    @NotNull
    public Interval getYWorldInterval() {
        return this.yWorldInterval;
    }

    @Override
    @NotNull
    public MutableOneDScreenTransform getX() {
        return this.x;
    }

    @Override
    @NotNull
    public MutableOneDScreenTransform getY() {
        return this.y;
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth, int screenHeight, double worldAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleTwoDScreenTransform this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(IntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.notifyTransformChanged(new ScreenTransformEvent());
            }
        };
        this.xWorldInterval = (Interval)x;
        this.yWorldInterval = (Interval)y;
        this.x = (MutableOneDScreenTransform)new SimpleOneDScreenTransform(x, screenWidth);
        this.y = (MutableOneDScreenTransform)new SimpleOneDScreenTransform(y, screenHeight, true, false);
        this.setScreenWidth(screenWidth);
        this.setScreenHeight(screenHeight);
        this.worldAspectRatio = worldAspectRatio;
        this.getXWorldInterval().addIntervalListener(this.intervalListener);
        this.getYWorldInterval().addIntervalListener(this.intervalListener);
    }

    public /* synthetic */ SimpleTwoDScreenTransform(BoundedInterval boundedInterval, BoundedInterval boundedInterval2, int n, int n2, double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            d = 1.0;
        }
        this(boundedInterval, boundedInterval2, n, n2, d);
    }

    public SimpleTwoDScreenTransform(@NotNull MutableOneDScreenTransform x, @NotNull MutableOneDScreenTransform y, int screenWidth, int screenHeight, double worldAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.intervalListener = new /* invalid duplicate definition of identical inner class */;
        this.xWorldInterval = x.getWorldInterval();
        this.yWorldInterval = y.getWorldInterval();
        this.x = x;
        this.y = y;
        this.setScreenWidth(screenWidth);
        this.setScreenHeight(screenHeight);
        this.worldAspectRatio = worldAspectRatio;
        this.getXWorldInterval().addIntervalListener(this.intervalListener);
        this.getYWorldInterval().addIntervalListener(this.intervalListener);
    }

    @Override
    public void setIntervals(@NotNull BoundedInterval xInterval, @NotNull BoundedInterval yInterval) {
        Intrinsics.checkNotNullParameter((Object)xInterval, (String)"xInterval");
        Intrinsics.checkNotNullParameter((Object)yInterval, (String)"yInterval");
        this.getXWorldInterval().removeIntervalListener(this.intervalListener);
        this.getYWorldInterval().removeIntervalListener(this.intervalListener);
        this.xWorldInterval = (Interval)xInterval;
        this.yWorldInterval = (Interval)yInterval;
        this.getXWorldInterval().addIntervalListener(this.intervalListener);
        this.getX().setWorldInterval(xInterval);
        this.getYWorldInterval().addIntervalListener(this.intervalListener);
        this.getY().setWorldInterval(yInterval);
    }

    @Override
    @NotNull
    public Point2D screenToWorld(@NotNull Point screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        return new Point2D.Double(this.getX().screenToWorld(screen.getIx()), this.getY().screenToWorld(screen.getIy()));
    }

    @Override
    @NotNull
    public Rectangle2D screenToWorld(@NotNull Rectangle screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        double x1 = this.getX().screenToWorld(screen.getIx());
        double y1 = this.getY().screenToWorld(screen.getIy());
        double x2 = this.getX().screenToWorld(screen.getIx() + screen.getIwidth());
        double y2 = this.getY().screenToWorld(screen.getIy() + screen.getIheight());
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    @NotNull
    public Point worldToScreen(@NotNull Point2D world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new Point(this.getX().worldToScreen(world.getX()), this.getY().worldToScreen(world.getY()));
    }

    @Override
    @NotNull
    public Rectangle worldToScreen(@NotNull Rectangle2D world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int x1 = this.getX().worldToScreen(world.getX());
        int y2 = this.getY().worldToScreen(world.getY());
        int x2 = this.getX().worldToScreen(world.getX() + world.getWidth());
        int y1 = this.getY().worldToScreen(world.getY() + world.getHeight());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public void setScreenSize(int screenWidth, int screenHeight) {
        if (this.getScreenWidth() != screenWidth || this.getScreenHeight() != screenHeight) {
            this.setScreenWidth(screenWidth);
            this.setScreenHeight(screenHeight);
            this.updateAspectRatio();
            this.getX().setScreenSize(screenWidth);
            this.getY().setScreenSize(screenHeight);
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @Override
    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        if (this.maintainAspectRatio != maintainAspectRatio) {
            this.maintainAspectRatio = maintainAspectRatio;
            this.updateAspectRatio();
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    private final void updateAspectRatio() {
        double width = this.getScreenWidth();
        double height = (double)this.getScreenHeight() * this.worldAspectRatio;
        if (this.maintainAspectRatio && !(width == height)) {
            if (width < height) {
                this.getX().setScreenMargins(0);
                this.getY().setScreenMargins((int)((double)this.getScreenHeight() - (double)this.getScreenWidth() / this.worldAspectRatio));
            } else {
                this.getX().setScreenMargins((int)((double)this.getScreenWidth() - (double)this.getScreenHeight() * this.worldAspectRatio));
                this.getY().setScreenMargins(0);
            }
        }
    }

    @Override
    public void setWorldAspectRatio(double worldAspectRatio) {
        this.worldAspectRatio = worldAspectRatio;
        this.updateAspectRatio();
    }

    @NotNull
    public String toString() {
        return "SimpleTwoDScreenTransform{screenWidth=" + this.getScreenWidth() + ", screenHeight=" + this.getScreenHeight() + ", xInterval=" + this.getXWorldInterval() + ", yInterval=" + this.getYWorldInterval() + "}";
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth, int screenHeight) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this(x, y, screenWidth, screenHeight, 0.0, 16, null);
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this(x, y, screenWidth, 0, 0.0, 24, null);
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this(x, y, 0, 0, 0.0, 28, null);
    }
}

