/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.filter;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.filter.FilterEvent;
import com.macrofocus.common.filter.FilterListener;
import com.macrofocus.common.filter.MutableFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/common/filter/AbstractFilter;", "E", "Lcom/macrofocus/common/filter/MutableFilter;", "<init>", "()V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "listeners", "", "Lcom/macrofocus/common/filter/FilterListener;", "addFilterListener", "", "listener", "addWeakFilterListener", "removeFilterListener", "removeFilterListeners", "notifyFilteredChanged", "event", "Lcom/macrofocus/common/filter/FilterEvent;", "WeakFilterListener", "Companion", "macrofocus-common"})
public abstract class AbstractFilter<E>
implements MutableFilter<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isEnabled = true;
    @NotNull
    private final List<FilterListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    private static final long serialVersionUID = 6388032080849307737L;

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public void addFilterListener(@NotNull FilterListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakFilterListener(@NotNull FilterListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(new WeakFilterListener(listener2));
    }

    @Override
    public void removeFilterListener(@NotNull FilterListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakFilterListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            FilterListener<E> toRemove = null;
            for (FilterListener<E> filterListener : this.listeners) {
                FilterListener<E> comparable = null;
                comparable = filterListener instanceof WeakFilterListener ? ((WeakFilterListener)filterListener).getReference() : filterListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = filterListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeFilterListeners() {
        this.listeners.clear();
    }

    protected final void notifyFilteredChanged(@NotNull FilterEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (FilterListener<E> listener2 : this.listeners) {
            listener2.filterChanged(event);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/common/filter/AbstractFilter$Companion;", "", "<init>", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/macrofocus/common/filter/AbstractFilter$WeakFilterListener;", "Lcom/macrofocus/common/filter/FilterListener;", "listener", "<init>", "(Lcom/macrofocus/common/filter/AbstractFilter;Lcom/macrofocus/common/filter/FilterListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "filterChanged", "", "event", "Lcom/macrofocus/common/filter/FilterEvent;", "reference", "getReference", "()Lcom/macrofocus/common/filter/FilterListener;", "macrofocus-common"})
    private final class WeakFilterListener
    implements FilterListener<E> {
        @NotNull
        private final WeakReference<FilterListener<E>> l_ref;

        public WeakFilterListener(FilterListener<E> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }

        @Override
        public void filterChanged(@NotNull FilterEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            FilterListener l = this.getReference();
            if (l != null) {
                l.filterChanged(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.common.filter.FilterListener<E of com.macrofocus.common.filter.AbstractFilter>");
                AbstractFilter.this.removeFilterListener(this);
            }
        }

        @Nullable
        public final FilterListener<E> getReference() {
            return this.l_ref.get();
        }
    }
}

