/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.filter;

import com.macrofocus.common.filter.AbstractMutableFilter;
import com.macrofocus.common.filter.SimpleFilterEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u001d\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\bH\u0016J,\u0010\u001e\u001a\u00020\u00142\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0086\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/macrofocus/common/filter/SimpleFilter;", "E", "Lcom/macrofocus/common/filter/AbstractMutableFilter;", "<init>", "()V", "filtered", "", "", "", "filteredCount", "", "getFilteredCount", "()I", "isActive", "", "()Z", "isFiltered", "element", "(Ljava/lang/Object;)Z", "clearFilter", "", "clearFilterBy", "locksmith", "isFilteredBy", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "setFiltered", "(Ljava/lang/Object;ZLjava/lang/Object;)V", "setFilteredIterable", "elements", "", "setFilteredState", "unfiltered", "iterator", "", "macrofocus-common"})
public final class SimpleFilter<E>
extends AbstractMutableFilter<E> {
    @NotNull
    private final Map<E, Set<Object>> filtered = new HashMap();

    @Override
    public int getFilteredCount() {
        return this.filtered.size();
    }

    @Override
    public boolean isActive() {
        return !this.filtered.isEmpty();
    }

    @Override
    public boolean isFiltered(E element) {
        return this.filtered.containsKey(element);
    }

    @Override
    public void clearFilter() {
        if (this.isEnabled() && this.isActive()) {
            Set changes = new HashSet();
            changes.addAll((Collection)this.filtered.keySet());
            this.filtered.clear();
            this.notifyFilteredChanged(new SimpleFilterEvent(this, SetsKt.emptySet(), changes));
        }
    }

    @Override
    public void clearFilterBy(@NotNull Object locksmith) {
        Intrinsics.checkNotNullParameter((Object)locksmith, (String)"locksmith");
        if (this.isEnabled() && this.isActive()) {
            List toRemove = new ArrayList();
            for (E element : this.filtered.keySet()) {
                Set<Object> set;
                Intrinsics.checkNotNull(this.filtered.get(element));
                if (!CollectionsKt.contains((Iterable)set, (Object)locksmith)) continue;
                TypeIntrinsics.asMutableCollection((Object)set).remove(locksmith);
                if (!set.isEmpty()) continue;
                toRemove.add(element);
            }
            if (!((Collection)toRemove).isEmpty()) {
                Set changes = new HashSet();
                for (Object e : toRemove) {
                    changes.add(e);
                    this.filtered.remove(e);
                }
                this.notifyFilteredChanged(new SimpleFilterEvent(this, SetsKt.emptySet(), changes));
            }
        }
    }

    @Override
    public boolean isFilteredBy(E element, @NotNull Object locksmith) {
        Set<Object> set;
        Intrinsics.checkNotNullParameter((Object)locksmith, (String)"locksmith");
        return this.filtered.containsKey(element) ? (set = this.filtered.get(element)) != null && set.contains(locksmith) : false;
    }

    @Override
    public void setFiltered(E element, boolean filtered2, @NotNull Object locksmith) {
        Intrinsics.checkNotNullParameter((Object)locksmith, (String)"locksmith");
        if (this.isEnabled()) {
            if (filtered2) {
                if (!this.filtered.containsKey(element)) {
                    Set set = new HashSet();
                    set.add(locksmith);
                    this.filtered.put(element, set);
                    Set changes = new HashSet();
                    changes.add(element);
                    this.notifyFilteredChanged(new SimpleFilterEvent(this, changes, SetsKt.emptySet()));
                } else {
                    Set<Object> set = this.filtered.get(element);
                    Intrinsics.checkNotNull(set);
                    Set<Object> set2 = set;
                    set2.add(locksmith);
                }
            } else if (this.filtered.containsKey(element)) {
                Set<Object> set = this.filtered.get(element);
                Intrinsics.checkNotNull(set);
                Set<Object> set3 = set;
                TypeIntrinsics.asMutableCollection((Object)set3).remove(locksmith);
                if (set3.isEmpty()) {
                    this.filtered.remove(element);
                    Set changes = new HashSet();
                    changes.add(element);
                    this.notifyFilteredChanged(new SimpleFilterEvent(this, SetsKt.emptySet(), changes));
                }
            }
        }
    }

    @Override
    public void setFilteredIterable(@NotNull Iterable<? extends E> elements, boolean filtered2, @NotNull Object locksmith) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)locksmith, (String)"locksmith");
        if (this.isEnabled()) {
            Set changes = new HashSet();
            for (E element : elements) {
                Set<Object> set;
                if (filtered2) {
                    boolean bl;
                    if (!this.filtered.containsKey(element)) {
                        set = new HashSet();
                        set.add(locksmith);
                        this.filtered.put(element, set);
                        bl = changes.add(element);
                        continue;
                    }
                    Intrinsics.checkNotNull(this.filtered.get(element));
                    bl = set.add(locksmith);
                    continue;
                }
                if (!this.filtered.containsKey(element)) continue;
                Intrinsics.checkNotNull(this.filtered.get(element));
                TypeIntrinsics.asMutableCollection((Object)set).remove(locksmith);
                if (!set.isEmpty()) continue;
                this.filtered.remove(element);
                changes.add(element);
            }
            if (changes.size() > 0) {
                if (filtered2) {
                    this.notifyFilteredChanged(new SimpleFilterEvent(this, changes, SetsKt.emptySet()));
                } else {
                    this.notifyFilteredChanged(new SimpleFilterEvent(this, SetsKt.emptySet(), changes));
                }
            }
        }
    }

    @Override
    public void setFilteredState(@NotNull Iterable<? extends E> filtered2, @NotNull Iterable<? extends E> unfiltered2, @NotNull Object locksmith) {
        Intrinsics.checkNotNullParameter(filtered2, (String)"filtered");
        Intrinsics.checkNotNullParameter(unfiltered2, (String)"unfiltered");
        Intrinsics.checkNotNullParameter((Object)locksmith, (String)"locksmith");
        if (this.isEnabled()) {
            Set<Object> set;
            Set f = new HashSet();
            Set u = new HashSet();
            for (E element : filtered2) {
                boolean bl;
                if (!this.filtered.containsKey(element)) {
                    set = new HashSet();
                    set.add(locksmith);
                    this.filtered.put(element, set);
                    bl = f.add(element);
                    continue;
                }
                Intrinsics.checkNotNull(this.filtered.get(element));
                bl = set.add(locksmith);
            }
            for (E element : unfiltered2) {
                if (!this.filtered.containsKey(element)) continue;
                Intrinsics.checkNotNull(this.filtered.get(element));
                TypeIntrinsics.asMutableCollection((Object)set).remove(locksmith);
                if (!set.isEmpty()) continue;
                this.filtered.remove(element);
                u.add(element);
            }
            if (f.size() > 0 || u.size() > 0) {
                this.notifyFilteredChanged(new SimpleFilterEvent(this, f, u));
            }
        }
    }

    @NotNull
    public final Iterator<E> iterator() {
        return this.filtered.keySet().iterator();
    }
}

