/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.interval.AbstractBoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.PropertyClosedInterval;
import com.macrofocus.common.properties.MutableProperty;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB-\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0011\u0010+\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010-\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0012\u0010.\u001a\u00020,2\b\u0010\u0003\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00100\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0012\u00101\u001a\u00020,2\b\u0010\u0003\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0016J(\u00109\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0016J\b\u0010<\u001a\u00020\u001cH\u0016J\n\u0010=\u001a\u00020>H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R$\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R$\u0010\n\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u000e\"\u0004\b%\u0010\u0010R$\u0010&\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u000e\"\u0004\b(\u0010\u0010R$\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u000e\"\u0004\b*\u0010\u0010R\u0014\u00102\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00103R\u0014\u00105\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00103\u00a8\u0006?"}, d2={"Lcom/macrofocus/common/interval/SimpleBoundedInterval;", "Lcom/macrofocus/common/interval/AbstractBoundedInterval;", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "minimum", "", "maximum", "<init>", "(Lcom/macrofocus/common/interval/MutableInterval;DD)V", "start", "extent", "(DDDD)V", "getMinimum", "()D", "setMinimum", "(D)V", "getMaximum", "setMaximum", "minimumExtent", "getMinimumExtent", "setMinimumExtent", "maximumExtent", "getMaximumExtent", "setMaximumExtent", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "setValue", "", "value", "startProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "getStartProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "endProperty", "getEndProperty", "getStart", "setStart", "end", "getEnd", "setEnd", "getExtent", "setExtent", "contains", "", "containsStartEnd", "containsInterval", "Lcom/macrofocus/common/interval/Interval;", "overlaps", "overlapsInterval", "isDegenerate", "()Z", "isInverted", "isInvertedScale", "setMinMax", "min", "max", "setMinMaxExtent", "minExtent", "maxExtent", "reset", "toString", "", "macrofocus-common"})
public final class SimpleBoundedInterval
extends AbstractBoundedInterval
implements MutableBoundedInterval {
    @NotNull
    private final MutableInterval interval;
    private double minimum;
    private double maximum;
    private double minimumExtent;
    private double maximumExtent;
    @NotNull
    private final IntervalListener intervalListener;

    public SimpleBoundedInterval(@NotNull MutableInterval interval, double minimum, double maximum) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        this.interval = interval;
        this.minimum = minimum;
        this.maximum = maximum;
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleBoundedInterval this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(IntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.notifyIntervalChanged(event);
            }
        };
        this.setMinimumExtent(0.0);
        this.setMaximumExtent(maximum - minimum);
        this.interval.addWeakIntervalListener(this.intervalListener);
    }

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(double minimum) {
        if (!(this.minimum == minimum)) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.minimum = minimum;
            this.setMaximumExtent(this.getMaximum() - this.minimum);
            event.setNewValues(this.minimum, this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(double maximum) {
        if (!(this.maximum == maximum)) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.getMinimum(), this.maximum, this.getMinimumExtent(), this.getMaximumExtent());
            this.maximum = maximum;
            this.setMaximumExtent(this.getMaximum() - this.getMinimum());
            event.setNewValues(this.getMinimum(), this.maximum, this.getMinimumExtent(), this.getMaximumExtent());
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @Override
    public double getMinimumExtent() {
        return this.minimumExtent;
    }

    @Override
    public void setMinimumExtent(double minimumExtent) {
        if (!(this.minimumExtent == minimumExtent)) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.getMinimum(), this.getMaximum(), this.minimumExtent, this.getMaximumExtent());
            this.minimumExtent = minimumExtent;
            event.setNewValues(this.getMinimum(), this.getMaximum(), this.minimumExtent, this.getMaximumExtent());
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @Override
    public double getMaximumExtent() {
        return this.maximumExtent;
    }

    @Override
    public void setMaximumExtent(double maximumExtent) {
        if (!(this.maximumExtent == maximumExtent)) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.maximumExtent);
            this.maximumExtent = maximumExtent;
            event.setNewValues(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.maximumExtent);
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @JvmOverloads
    public SimpleBoundedInterval(double start, double extent, double minimum, double maximum) {
        this(new PropertyClosedInterval(start, extent), minimum, maximum);
    }

    public /* synthetic */ SimpleBoundedInterval(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = d;
        }
        if ((n & 8) != 0) {
            d4 = d + d2;
        }
        this(d, d2, d3, d4);
    }

    @Override
    public void setValue(double value, double extent) {
        this.interval.setValue(value, extent);
    }

    @Override
    @NotNull
    public MutableProperty<Double> getStartProperty() {
        return this.interval.getStartProperty();
    }

    @Override
    @NotNull
    public MutableProperty<Double> getEndProperty() {
        return this.interval.getEndProperty();
    }

    @Override
    public double getStart() {
        return this.interval.getStart();
    }

    @Override
    public void setStart(double value) {
        this.interval.setStart(value);
    }

    @Override
    public double getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public void setEnd(double value) {
        this.interval.setEnd(value);
    }

    @Override
    public double getExtent() {
        return this.interval.getExtent();
    }

    @Override
    public void setExtent(double value) {
        this.interval.setExtent(value);
    }

    @Override
    public boolean contains(double value) {
        return this.interval.contains(value);
    }

    @Override
    public boolean containsStartEnd(double start, double end) {
        return this.interval.containsStartEnd(start, end);
    }

    @Override
    public boolean containsInterval(@Nullable Interval interval) {
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        return interval2.containsInterval(interval);
    }

    @Override
    public boolean overlaps(double start, double end) {
        return this.interval.overlaps(start, end);
    }

    @Override
    public boolean overlapsInterval(@Nullable Interval interval) {
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        return interval2.overlapsInterval(interval);
    }

    @Override
    public boolean isDegenerate() {
        return this.interval.isDegenerate();
    }

    @Override
    public boolean isInverted() {
        return this.interval.isInverted();
    }

    @Override
    public boolean isInvertedScale() {
        return this.getMinimum() > this.getMaximum();
    }

    @Override
    public void setMinMax(double min, double max) {
        if (!(this.getMinimum() == min) || !(this.getMaximum() == max)) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.setMinimum(min);
            this.setMaximum(max);
            this.setMaximumExtent(max - min);
            event.setNewValues(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @Override
    public void setMinMaxExtent(double min, double max, double minExtent, double maxExtent) {
        if (!(this.getMinimum() == min && this.getMaximum() == max && this.getMinimumExtent() == minExtent && this.getMaximumExtent() == this.getMaximumExtent())) {
            BoundedIntervalEvent event = new BoundedIntervalEvent(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.setMinimum(min);
            this.setMaximum(max);
            this.setMinimumExtent(minExtent);
            this.setMaximumExtent(maxExtent);
            event.setNewValues(this.getMinimum(), this.getMaximum(), this.getMinimumExtent(), this.getMaximumExtent());
            this.notifyBoundedIntervalChanged(event);
        }
    }

    @Override
    public void reset() {
        this.setValue(this.getMinimum(), Math.min(this.getMinimum() + this.getMaximumExtent(), this.getMaximum()) - this.getMinimum());
    }

    @NotNull
    public String toString() {
        return "SimpleBoundedInterval{start=" + this.interval.getStart() + ", end=" + this.interval.getEnd() + ", extent=" + this.interval.getExtent() + ", minimum=" + this.getMinimum() + ", maximum=" + this.getMaximum() + ", minimumExtent=" + this.getMinimumExtent() + ", maximumExtent=" + this.getMaximumExtent() + "}";
    }

    @JvmOverloads
    public SimpleBoundedInterval(double start, double extent, double minimum) {
        this(start, extent, minimum, 0.0, 8, null);
    }

    @JvmOverloads
    public SimpleBoundedInterval(double start, double extent) {
        this(start, extent, 0.0, 0.0, 12, null);
    }
}

