/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.interval.AbstractBoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.scale.Transform;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0011\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u000eH\u0096\u0002J\u0018\u0010%\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0012\u0010&\u001a\u00020$2\b\u0010\u0003\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0012\u0010)\u001a\u00020$2\b\u0010\u0003\u001a\u0004\u0018\u00010'H\u0016J\u0018\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0016J(\u00107\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u00020\u0012H\u0016J\n\u0010A\u001a\u00020BH\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R$\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001b\"\u0004\b\"\u0010\u001dR\u0014\u0010*\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010+R\u0014\u0010-\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R$\u0010.\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u001b\"\u0004\b0\u0010\u001dR$\u00101\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR$\u0010:\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u001b\"\u0004\b<\u0010\u001dR$\u0010=\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\u001b\"\u0004\b?\u0010\u001d\u00a8\u0006C"}, d2={"Lcom/macrofocus/common/interval/TransformBoundedInterval;", "Lcom/macrofocus/common/interval/AbstractBoundedInterval;", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "interval", "scale", "Lcom/macrofocus/common/properties/MutableProperty;", "Lcom/macrofocus/common/scale/Transform;", "<init>", "(Lcom/macrofocus/common/interval/MutableBoundedInterval;Lcom/macrofocus/common/properties/MutableProperty;)V", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "boundedIntervalListener", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "transform", "", "value", "inverse", "setValue", "", "extent", "startProperty", "getStartProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "endProperty", "getEndProperty", "start", "getStart", "()D", "setStart", "(D)V", "end", "getEnd", "setEnd", "getExtent", "setExtent", "contains", "", "containsStartEnd", "containsInterval", "Lcom/macrofocus/common/interval/Interval;", "overlaps", "overlapsInterval", "isDegenerate", "()Z", "isInverted", "isInvertedScale", "minimum", "getMinimum", "setMinimum", "maximum", "getMaximum", "setMaximum", "setMinMax", "min", "max", "setMinMaxExtent", "minExtent", "maxExtent", "minimumExtent", "getMinimumExtent", "setMinimumExtent", "maximumExtent", "getMaximumExtent", "setMaximumExtent", "reset", "toString", "", "macrofocus-common"})
public final class TransformBoundedInterval
extends AbstractBoundedInterval
implements MutableBoundedInterval {
    @NotNull
    private final MutableBoundedInterval interval;
    @Nullable
    private final MutableProperty<Transform> scale;
    @NotNull
    private final IntervalListener intervalListener;
    @NotNull
    private final BoundedIntervalListener boundedIntervalListener;

    public TransformBoundedInterval(@NotNull MutableBoundedInterval interval, @Nullable MutableProperty<Transform> scale) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        this.interval = interval;
        this.scale = scale;
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ TransformBoundedInterval this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(IntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                double oldStart = TransformBoundedInterval.access$transform(this.this$0, event.getOldStart());
                double oldEnd = TransformBoundedInterval.access$transform(this.this$0, event.getOldEnd());
                IntervalEvent e = new IntervalEvent(oldStart, oldEnd, oldEnd - oldStart);
                double newStart = TransformBoundedInterval.access$transform(this.this$0, event.getNewStart());
                double newEnd = TransformBoundedInterval.access$transform(this.this$0, event.getNewEnd());
                e.setNewValues(newStart, newEnd, newEnd - newStart);
                this.this$0.notifyIntervalChanged(e);
            }
        };
        this.boundedIntervalListener = new BoundedIntervalListener(this){
            final /* synthetic */ TransformBoundedInterval this$0;
            {
                this.this$0 = $receiver;
            }

            public void boundedIntervalChanged(BoundedIntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.notifyBoundedIntervalChanged(event);
            }
        };
        this.interval.addWeakIntervalListener(this.intervalListener);
    }

    private final double transform(double value) {
        Object object = this.scale;
        return object != null && (object = object.getValue()) != null && (object = object.getTransform()) != null ? ((Number)object.invoke((Object)value)).doubleValue() : value;
    }

    private final double inverse(double value) {
        double d;
        if (this.scale != null) {
            Function1<Double, Double> function1 = this.scale.getValue().getInverse();
            Intrinsics.checkNotNull(function1);
            d = ((Number)function1.invoke((Object)value)).doubleValue();
        } else {
            d = value;
        }
        return d;
    }

    @Override
    public void setValue(double value, double extent) {
        double start = this.inverse(value);
        this.interval.setValue(start, this.inverse(value + extent) - start);
    }

    @Override
    @NotNull
    public MutableProperty<Double> getStartProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public MutableProperty<Double> getEndProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStart() {
        return this.transform(this.interval.getStart());
    }

    @Override
    public void setStart(double value) {
        this.interval.setStart(this.inverse(value));
    }

    @Override
    public double getEnd() {
        return this.transform(this.interval.getEnd());
    }

    @Override
    public void setEnd(double value) {
        this.interval.setEnd(this.inverse(value));
    }

    @Override
    public double getExtent() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public void setExtent(double extent) {
        this.interval.setExtent(this.inverse(this.transform(this.interval.getStart()) + extent) - this.interval.getStart());
    }

    @Override
    public boolean contains(double value) {
        return this.interval.contains(this.inverse(value));
    }

    @Override
    public boolean containsStartEnd(double start, double end) {
        return this.interval.containsStartEnd(this.inverse(start), this.inverse(end));
    }

    @Override
    public boolean containsInterval(@Nullable Interval interval) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean overlaps(double start, double end) {
        return this.interval.overlaps(this.inverse(start), this.inverse(end));
    }

    @Override
    public boolean overlapsInterval(@Nullable Interval interval) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDegenerate() {
        return this.getExtent() == 0.0;
    }

    @Override
    public boolean isInverted() {
        return this.getEnd() < this.getStart();
    }

    @Override
    public boolean isInvertedScale() {
        return this.getMinimum() > this.getMaximum();
    }

    @Override
    public double getMinimum() {
        return this.transform(this.interval.getMinimum());
    }

    @Override
    public void setMinimum(double minimum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMaximum() {
        return this.transform(this.interval.getMaximum());
    }

    @Override
    public void setMaximum(double maximum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMinMax(double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMinMaxExtent(double min, double max, double minExtent, double maxExtent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMinimumExtent() {
        return this.transform(this.interval.getMinimum() + this.interval.getMinimumExtent()) - this.transform(this.interval.getMinimum());
    }

    @Override
    public void setMinimumExtent(double minimumExtent) {
        System.out.println((Object)"Operation TransformBoundedInterval:setMinimumExtent not supported");
    }

    @Override
    public double getMaximumExtent() {
        return this.transform(this.interval.getMinimum() + this.interval.getMaximumExtent()) - this.transform(this.interval.getMinimum());
    }

    @Override
    public void setMaximumExtent(double maximumExtent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.interval.reset();
    }

    @NotNull
    public String toString() {
        return "TransformBoundedInterval{start=" + this.interval.getStart() + ", getStart()=" + this.getStart() + ", end=" + this.interval.getEnd() + ", getEnd()=" + this.getEnd() + ", extent=" + this.interval.getExtent() + ", getExtent()=" + this.getExtent() + ", getMinimum()=" + this.getMinimum() + ", getMaxmimum()=" + this.getMaximum() + ", getMinimumExtent()=" + this.getMinimumExtent() + ", getMaximumExtent()=" + this.getMaximumExtent() + ", isDegenerate()=" + this.isDegenerate() + ", isInverted()=" + this.isInverted() + ", isInvertedScale()=" + this.isInvertedScale() + "}";
    }

    public static final /* synthetic */ double access$transform(TransformBoundedInterval $this, double value) {
        return $this.transform(value);
    }
}

