/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.collection.ArrayFnKt;
import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonValue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\t\u0010\u0012\u001a\u00020\fH\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0017\u0010\u0019\u001a\u0002H\u001a\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0005H\u0002J \u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/macrofocus/common/json/JsonTokenizer;", "", "serverJsonFactory", "Lcom/macrofocus/common/json/JsonFactory;", "json", "", "<init>", "(Lcom/macrofocus/common/json/JsonFactory;Ljava/lang/String;)V", "jsonFactory", "lenient", "", "pushBackBuffer", "", "position", "back", "", "c", "", "next", "n", "nextNonWhitespace", "nextString", "startChar", "nextUntilOneOf", "chars", "nextValue", "T", "Lcom/macrofocus/common/json/JsonValue;", "()Lcom/macrofocus/common/json/JsonValue;", "parseArray", "Lcom/macrofocus/common/json/JsonArray;", "parseObject", "Lcom/macrofocus/common/json/JsonObject;", "getNumberForLiteral", "Lcom/macrofocus/common/json/JsonNumber;", "literal", "getValueForLiteral", "read", "buffer", "", "pos", "len", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nJsonTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonTokenizer.kt\ncom/macrofocus/common/json/JsonTokenizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public final class JsonTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonFactory jsonFactory;
    private final boolean lenient;
    private int pushBackBuffer;
    @NotNull
    private final String json;
    private int position;
    private static final int INVALID_CHAR = -1;
    @NotNull
    private static final String STOPCHARS = ",:]}/\\\"[{;=#";

    public JsonTokenizer(@NotNull JsonFactory serverJsonFactory, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)serverJsonFactory, (String)"serverJsonFactory");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.lenient = true;
        this.pushBackBuffer = -1;
        this.jsonFactory = serverJsonFactory;
        this.json = json;
    }

    public final void back(char c) {
        this.pushBackBuffer = c;
    }

    public final void back(int c) {
        this.back((char)c);
    }

    public final int next() {
        int n;
        if (this.pushBackBuffer != -1) {
            int c = this.pushBackBuffer;
            this.pushBackBuffer = -1;
            return c;
        }
        if (this.position < this.json.length()) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.json.charAt(n2);
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final String next(int n) throws JsonException {
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.pushBackBuffer != -1) {
            buffer[0] = (char)this.pushBackBuffer;
            pos = 1;
            this.pushBackBuffer = -1;
        }
        int len = 0;
        while (pos < n) {
            int n2;
            int it = n2 = this.read(buffer, pos, n - pos);
            boolean bl = false;
            len = it;
            if (n2 == -1) break;
            pos += len;
        }
        if (pos < n) {
            throw new JsonException("TODO");
        }
        return StringsKt.concatToString((char[])buffer);
    }

    public final int nextNonWhitespace() {
        int c;
        while (CharsKt.isWhitespace((char)((char)(c = this.next())))) {
        }
        return c;
    }

    @NotNull
    public final String nextString(int startChar) throws JsonException {
        boolean bl;
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        boolean bl2 = bl = c == 34 || this.lenient && c == 39;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        while (true) {
            c = this.next();
            block0 : switch (c) {
                case 10: 
                case 13: {
                    throw new JsonException("");
                }
                case -1: {
                    throw new JsonException("Invalid string: closing " + startChar + " is not found");
                }
                case 92: {
                    StringBuilder stringBuilder;
                    c = this.next();
                    switch (c) {
                        case 98: {
                            stringBuilder = buffer.append('\b');
                            break block0;
                        }
                        case 116: {
                            stringBuilder = buffer.append('\t');
                            break block0;
                        }
                        case 110: {
                            stringBuilder = buffer.append('\n');
                            break block0;
                        }
                        case 114: {
                            stringBuilder = buffer.append('\r');
                            break block0;
                        }
                        case 117: {
                            stringBuilder = buffer.append((char)Integer.parseInt(this.next(4), CharsKt.checkRadix((int)16)));
                            break block0;
                        }
                    }
                    stringBuilder = buffer.append((char)c);
                    break;
                }
                default: {
                    if (c == startChar) {
                        String string = buffer.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        return string;
                    }
                    StringBuilder stringBuilder = buffer.append((char)c);
                }
            }
        }
    }

    @NotNull
    public final String nextUntilOneOf(@NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        while (c != -1) {
            if (CharsKt.isWhitespace((char)((char)c)) || StringsKt.indexOf$default((CharSequence)chars, (char)((char)c), (int)0, (boolean)false, (int)6, null) >= 0) {
                this.back(c);
                break;
            }
            buffer.append((char)c);
            c = this.next();
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final <T extends JsonValue> T nextValue() throws JsonException {
        int c = this.nextNonWhitespace();
        this.back(c);
        return (T)(switch (c) {
            case 34, 39 -> this.jsonFactory.create(this.nextString(c));
            case 123 -> this.parseObject();
            case 91 -> this.parseArray();
            default -> this.getValueForLiteral(this.nextUntilOneOf(STOPCHARS));
        });
    }

    @NotNull
    public final JsonArray parseArray() throws JsonException {
        boolean bl;
        JsonArray array = this.jsonFactory.createArray();
        int c = this.nextNonWhitespace();
        boolean bl2 = bl = c == 91;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        block4: while (true) {
            if ((c = this.nextNonWhitespace()) == 93) {
                return array;
            }
            this.back(c);
            array.set(array.length(), (JsonValue)this.nextValue());
            int d = this.nextNonWhitespace();
            switch (d) {
                case 93: {
                    return array;
                }
                case 44: {
                    continue block4;
                }
            }
            break;
        }
        throw new JsonException("Invalid array: expected , or ]");
    }

    @NotNull
    public final JsonObject parseObject() throws JsonException {
        block18: {
            JsonObject object = this.jsonFactory.createObject();
            int c = this.nextNonWhitespace();
            if (c != 123) {
                throw new JsonException("Payload does not begin with '{'.  Got " + c + "(" + (char)c + ")");
            }
            block13: while (true) {
                c = this.nextNonWhitespace();
                switch (c) {
                    case 125: {
                        return object;
                    }
                    case 34: 
                    case 39: {
                        this.back(c);
                        String key = this.nextString(c);
                        if (this.nextNonWhitespace() != 58) {
                            throw new JsonException("Invalid object: expecting \":\"");
                        }
                        object.put(key, (JsonValue)this.nextValue());
                        switch (this.nextNonWhitespace()) {
                            case 44: {
                                continue block13;
                            }
                            case 125: {
                                return object;
                            }
                        }
                        throw new JsonException("Invalid object: expecting } or ,");
                    }
                    case 44: {
                        continue block13;
                    }
                }
                if ((!this.lenient || !Character.isDigit((char)c)) && !Character.isLetterOrDigit((char)c)) break block18;
                StringBuilder keyBuffer = new StringBuilder();
                keyBuffer.append(c);
                while (Character.isDigit((char)(c = this.next())) || Character.isLetterOrDigit((char)c)) {
                    keyBuffer.append(c);
                }
                this.back(c);
                if (this.nextNonWhitespace() != 58) {
                    throw new JsonException("Invalid object: expecting \":\"");
                }
                String string = keyBuffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                object.put(string, (JsonValue)this.nextValue());
                switch (this.nextNonWhitespace()) {
                    case 44: {
                        continue block13;
                    }
                    case 125: {
                        return object;
                    }
                }
                break;
            }
            throw new JsonException("Invalid object: expecting } or ,");
        }
        throw new JsonException("Invalid object: ");
    }

    private final JsonNumber getNumberForLiteral(String literal) throws JsonException {
        JsonNumber jsonNumber;
        try {
            jsonNumber = this.jsonFactory.create(Double.parseDouble(literal));
        }
        catch (NumberFormatException e) {
            throw new JsonException("Invalid number literal: " + literal);
        }
        return jsonNumber;
    }

    private final JsonValue getValueForLiteral(String literal) throws JsonException {
        if (Intrinsics.areEqual((Object)"", (Object)literal)) {
            throw new JsonException("Missing value");
        }
        if (Intrinsics.areEqual((Object)"null", (Object)literal) || Intrinsics.areEqual((Object)"undefined", (Object)literal)) {
            return this.jsonFactory.createNull();
        }
        if (Intrinsics.areEqual((Object)"true", (Object)literal)) {
            return this.jsonFactory.create(true);
        }
        if (Intrinsics.areEqual((Object)"false", (Object)literal)) {
            return this.jsonFactory.create(false);
        }
        char c = literal.charAt(0);
        if (c == '-' || Character.isDigit(c)) {
            return this.getNumberForLiteral(literal);
        }
        throw new JsonException("Invalid literal: \"" + literal + "\"");
    }

    private final int read(char[] buffer, int pos, int len) {
        int maxLen = Math.min(this.json.length() - this.position, len);
        String string = this.json.substring(this.position, this.position + maxLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String src = string;
        char[] cArray = src.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] result = cArray;
        ArrayFnKt.arraycopy(result, 0, buffer, pos, maxLen);
        this.position += maxLen;
        return maxLen;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/macrofocus/common/json/JsonTokenizer$Companion;", "", "<init>", "()V", "INVALID_CHAR", "", "STOPCHARS", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

