/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.math.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0019\b\u0016\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\n\u00a2\u0006\u0004\b\u0005\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0005\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0005\u0010\u0011B\u0019\b\u0016\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\n\u00a2\u0006\u0004\b\u0005\u0010\u0012J\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0000J\u001b\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\n2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010)\u001a\u00020*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010+\u001a\u0004\u0018\u00010\rR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010.R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010.\u00a8\u00061"}, d2={"Lcom/macrofocus/common/math/Range;", "", "min", "", "max", "<init>", "(DD)V", "roleModel", "(Lcom/macrofocus/common/math/Range;)V", "ranges", "", "([Lcom/macrofocus/common/math/Range;)V", "data", "", "([D)V", "valids", "", "([D[I)V", "([[D)V", "toString", "", "range", "getRange", "()D", "scale", "log", "getSubRanges", "count", "", "(I)[Lcom/macrofocus/common/math/Range;", "contains", "", "value", "getClippedValue", "makeSymmetrical", "ensureWidth", "width", "widenAbsolute", "extent", "widenRelative", "ratio", "widen", "", "toDoubleArray", "getMin", "setMin", "(D)V", "getMax", "setMax", "macrofocus-common"})
public final class Range {
    private double min;
    private double max;

    @NotNull
    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }

    public final double getRange() {
        if (MathKt.isInfinite(this.max - this.min)) {
            return Double.NaN;
        }
        return this.max - this.min;
    }

    public Range(double min, double max) {
        this.min = Double.NaN;
        this.max = Double.NaN;
        if (min <= max) {
            this.min = min;
            this.max = max;
        }
    }

    public Range(@NotNull Range roleModel) {
        Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.min = roleModel.min;
        this.max = roleModel.max;
    }

    public Range(@NotNull Range[] ranges) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        this.min = Double.NaN;
        this.max = Double.NaN;
        if (ranges.length >= 1) {
            Range range = ranges[0];
            Intrinsics.checkNotNull((Object)range);
            this.min = range.min;
            Range range2 = ranges[0];
            Intrinsics.checkNotNull((Object)range2);
            this.max = range2.max;
            int n = ranges.length;
            for (int i = 1; i < n; ++i) {
                Range range3 = ranges[i];
                Intrinsics.checkNotNull((Object)range3);
                this.min = Math.min(this.min, range3.min);
                Range range4 = ranges[i];
                Intrinsics.checkNotNull((Object)range4);
                this.max = Math.max(this.max, range4.max);
            }
        }
    }

    public Range(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.widen(data);
    }

    public Range(@NotNull double[] data, @NotNull int[] valids) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)valids, (String)"valids");
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.widen(data, valids);
    }

    public Range(@NotNull double[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.min = Double.NaN;
        this.max = Double.NaN;
        int n = ((Object[])data).length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = data[i];
            Intrinsics.checkNotNull((Object)dArray);
            this.widen(dArray);
        }
    }

    @NotNull
    public final Range scale(double scale) {
        return new Range(this.min * scale, this.max * scale);
    }

    @NotNull
    public final Range log() {
        return new Range(Math.log(this.min), Math.log(this.max));
    }

    @NotNull
    public final Range[] getSubRanges(int count) {
        Range[] result = new Range[count];
        double min = this.min;
        double range = this.getRange();
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = new Range(min + range * (double)i / (double)result.length, min + range * (double)(i + 1) / (double)result.length);
        }
        return result;
    }

    public final boolean contains(double value) {
        return value >= this.min && value <= this.max;
    }

    public final double getClippedValue(double value) {
        return Math.min(this.max, Math.max(this.min, value));
    }

    @NotNull
    public final Range makeSymmetrical() {
        double extent = Math.max(-this.min, this.max);
        return new Range(-extent, extent);
    }

    @NotNull
    public final Range ensureWidth(double width) {
        double halfDiff = (width - this.getRange()) / (double)2.0f;
        if (halfDiff <= 0.0) {
            return this;
        }
        return new Range(this.min - halfDiff, this.max + halfDiff);
    }

    @NotNull
    public final Range widenAbsolute(double extent) {
        return new Range(this.min - extent, this.max + extent);
    }

    @NotNull
    public final Range widenRelative(double ratio) {
        double extend = (this.max - this.min) * ratio;
        return this.widenAbsolute(extend);
    }

    public final void widen(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.min = Math.min(data[i], this.min);
            this.max = Math.max(data[i], this.max);
        }
    }

    public final void widen(@NotNull double[] data, @NotNull int[] valids) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)valids, (String)"valids");
        int n = valids.length;
        for (int i = 0; i < n; ++i) {
            this.min = Math.min(data[valids[i]], this.min);
            this.max = Math.max(data[valids[i]], this.max);
        }
    }

    @Nullable
    public final double[] toDoubleArray() {
        double[] dArray = new double[]{this.min, this.max};
        return dArray;
    }

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }
}

