/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0004:\u0001#B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/macrofocus/common/properties/SimpleArrayProperty;", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "", "Lcom/macrofocus/common/properties/MutableProperty;", "value", "<init>", "([Ljava/lang/Object;)V", "array", "[Ljava/lang/Object;", "getValue", "()[Ljava/lang/Object;", "setValue", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "append", "(Ljava/lang/Object;)V", "removeAt", "(I)Ljava/lang/Object;", "set", "contains", "", "(Ljava/lang/Object;)Z", "get", "indexOf", "(Ljava/lang/Object;)I", "toString", "", "Companion", "macrofocus-common"})
public final class SimpleArrayProperty<T>
extends AbstractMutableProperty<T[]>
implements MutableProperty<T[]> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T[] array;

    public SimpleArrayProperty(@NotNull T[] value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        T[] TArray = Arrays.copyOf(value, value.length);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
        this.array = TArray;
    }

    @Override
    @NotNull
    public T[] getValue() {
        return this.array;
    }

    @Override
    public void setValue(@NotNull T[] value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.getValue() != value) {
            T[] TArray = Arrays.copyOf(this.array, this.array.length);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            T[] old = TArray;
            this.array = value;
            this.notifyPropertyChanged(new PropertyEvent<T[]>(old, value));
        }
    }

    public final int getSize() {
        return this.array.length;
    }

    public final void add(int index, T element) {
        T[] TArray = Arrays.copyOf(this.array, this.array.length);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
        T[] old = TArray;
        this.array = ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.copyOfRange((Object[])this.array, (int)0, (int)index), element), (Object[])ArraysKt.copyOfRange((Object[])this.array, (int)index, (int)this.array.length));
        T[] present = this.getValue();
        this.notifyPropertyChanged(new PropertyEvent<T[]>(old, present));
    }

    public final void append(T value) {
        T[] TArray = Arrays.copyOf(this.array, this.array.length);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
        T[] old = TArray;
        this.array = ArraysKt.plus((Object[])this.array, value);
        T[] present = this.getValue();
        this.notifyPropertyChanged(new PropertyEvent<T[]>(old, present));
    }

    public final T removeAt(int index) {
        T[] TArray = Arrays.copyOf(this.array, this.array.length);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
        T[] old = TArray;
        this.array = ArraysKt.plus((Object[])ArraysKt.copyOfRange((Object[])this.array, (int)0, (int)index), (Object[])ArraysKt.copyOfRange((Object[])this.array, (int)(index + 1), (int)this.array.length));
        T[] present = this.getValue();
        this.notifyPropertyChanged(new PropertyEvent<T[]>(old, present));
        return old[index];
    }

    public final void set(int index, T value) {
        if (this.array[index] != value) {
            T[] old = this.array;
            T[] TArray = Arrays.copyOf(this.array, this.array.length);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            T[] TArray2 = TArray;
            TArray2[index] = value;
            this.array = TArray2;
            T[] present = this.getValue();
            this.notifyPropertyChanged(new PropertyEvent<T[]>(old, present));
        }
    }

    public final boolean contains(T value) {
        return ArraysKt.contains((Object[])this.array, value);
    }

    public final T get(int index) {
        return this.array[index];
    }

    public final int indexOf(T value) {
        return ArraysKt.indexOf((Object[])this.array, value);
    }

    @NotNull
    public String toString() {
        return "SimpleArrayProperty{value=" + this.getValue() + "}";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/properties/SimpleArrayProperty$Companion;", "", "<init>", "()V", "newInstance", "Lcom/macrofocus/common/properties/SimpleArrayProperty;", "T", "value", "", "([Ljava/lang/Object;)Lcom/macrofocus/common/properties/SimpleArrayProperty;", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SimpleArrayProperty<T> newInstance(@NotNull T[] value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new SimpleArrayProperty<T>(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

