/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.AbstractProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\rH\u0096\u0082\u0004J+\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000fH\u0016J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000fH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R(\u0010\u0006\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties;", "Lcom/macrofocus/common/properties/AbstractProperties;", "", "Lcom/macrofocus/common/properties/MutableProperties;", "<init>", "()V", "propertyMap", "", "Lcom/macrofocus/common/properties/SimpleProperties$ExposedProperty;", "", "listenerMap", "Lcom/macrofocus/common/properties/PropertyListener;", "iterator", "", "createProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "T", "name", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/macrofocus/common/properties/MutableProperty;", "addProperty", "property", "replaceProperty", "getValue", "setValue", "", "getProperty", "NamedPropertyListener", "ExposedProperty", "macrofocus-common"})
public class SimpleProperties
extends AbstractProperties<String>
implements MutableProperties<String> {
    @NotNull
    private final Map<String, ExposedProperty<Object>> propertyMap = new HashMap();
    @NotNull
    private final Map<String, PropertyListener<Object>> listenerMap = new HashMap();

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.propertyMap.keySet().iterator();
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> createProperty(@Nullable String name, T value) {
        MutableProperty property = SimpleProperty.Companion.newInstance(value);
        return this.addProperty(name, property);
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> addProperty(@Nullable String name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<T> exposedProperty = new ExposedProperty<T>(property);
        this.propertyMap.put(name, exposedProperty);
        NamedPropertyListener listener2 = new NamedPropertyListener(name);
        exposedProperty.addPropertyListener(listener2);
        this.listenerMap.put(name, listener2);
        return exposedProperty;
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> replaceProperty(@Nullable String name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setSecretProperty(property);
        return property;
    }

    @Override
    @Nullable
    public Object getValue(@Nullable String name) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty.getValue();
    }

    @Override
    public void setValue(@Nullable String name, @Nullable Object value) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setValue(value);
    }

    @Override
    @NotNull
    public MutableProperty<Object> getProperty(@Nullable String name) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties$ExposedProperty;", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "Lcom/macrofocus/common/properties/MutableProperty;", "secret", "<init>", "(Lcom/macrofocus/common/properties/SimpleProperties;Lcom/macrofocus/common/properties/MutableProperty;)V", "listener", "Lcom/macrofocus/common/properties/PropertyListener;", "getListener", "()Lcom/macrofocus/common/properties/PropertyListener;", "setListener", "(Lcom/macrofocus/common/properties/PropertyListener;)V", "setSecretProperty", "", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "macrofocus-common"})
    private final class ExposedProperty<T>
    extends AbstractMutableProperty<T>
    implements MutableProperty<T> {
        @NotNull
        private MutableProperty<T> secret;
        @NotNull
        private PropertyListener<T> listener;

        public ExposedProperty(MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            this.listener = new PropertyListener<T>(this){
                final /* synthetic */ ExposedProperty<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void propertyChanged(PropertyEvent<T> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    this.this$0.notifyPropertyChanged(event);
                }
            };
            this.secret = secret;
            this.secret.addPropertyListener(this.listener);
        }

        @NotNull
        public final PropertyListener<T> getListener() {
            return this.listener;
        }

        public final void setListener(@NotNull PropertyListener<T> propertyListener) {
            Intrinsics.checkNotNullParameter(propertyListener, (String)"<set-?>");
            this.listener = propertyListener;
        }

        public final void setSecretProperty(@NotNull MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            if (this.secret != secret) {
                this.secret.removePropertyListener(this.listener);
                T oldValue = this.secret.getValue();
                T newValue = secret.getValue();
                this.secret = secret;
                this.secret.addPropertyListener(this.listener);
                if (oldValue != newValue) {
                    this.notifyPropertyChanged(new PropertyEvent<T>(oldValue, newValue));
                }
            }
        }

        @Override
        public T getValue() {
            return this.secret.getValue();
        }

        @Override
        public void setValue(T value) {
            this.secret.setValue(value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties$NamedPropertyListener;", "Lcom/macrofocus/common/properties/PropertyListener;", "", "name", "", "<init>", "(Lcom/macrofocus/common/properties/SimpleProperties;Ljava/lang/String;)V", "propertyChanged", "", "event", "Lcom/macrofocus/common/properties/PropertyEvent;", "macrofocus-common"})
    private final class NamedPropertyListener
    implements PropertyListener<Object> {
        @Nullable
        private final String name;

        public NamedPropertyListener(String name) {
            this.name = name;
        }

        @Override
        public void propertyChanged(@NotNull PropertyEvent<Object> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            SimpleProperties.this.notifyPropertyChanged(this.name, event);
        }
    }
}

