/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.AbstractMutableSelection;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SimpleSelectionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0014\u001a\u00020\nH\u0016J)\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001a\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\u00112\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001a\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0082\u0004R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lcom/macrofocus/common/selection/PropertySelection;", "E", "Lcom/macrofocus/common/selection/AbstractMutableSelection;", "Lcom/macrofocus/common/selection/MutableSelection;", "property", "Lcom/macrofocus/common/properties/MutableProperty;", "", "<init>", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "clearSelection", "", "isActive", "()Z", "isSelected", "element", "(Ljava/lang/Object;)Z", "setSelectedElement", "", "(Ljava/lang/Object;)V", "setSelectedState", "selected", "(Ljava/lang/Object;Z)V", "setSelectedIterableState", "", "setSelectedElementsState", "elements", "", "(Z[Ljava/lang/Object;)Z", "setSelectedElements", "([Ljava/lang/Object;)V", "setSelectedIterable", "selectedCount", "", "getSelectedCount", "()I", "selectedSet", "", "getSelectedSet", "()Ljava/util/Set;", "iterator", "", "macrofocus-common"})
public final class PropertySelection<E>
extends AbstractMutableSelection<E>
implements MutableSelection<E> {
    @NotNull
    private final MutableProperty<List<E>> property;

    public PropertySelection(@NotNull MutableProperty<List<E>> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this.property = property;
        final MutableSelection self = this;
        this.property.addPropertyListener(new PropertyListener<List<? extends E>>(){

            @Override
            public void propertyChanged(PropertyEvent<List<E>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.notifySelectedChanged(new SimpleSelectionEvent(self, CollectionsKt.union((Iterable)CollectionsKt.toSet((Iterable)event.getNewValue()), (Iterable)CollectionsKt.toSet((Iterable)event.getOldValue()))));
            }
        });
    }

    @Override
    public boolean clearSelection() {
        boolean bl;
        if (this.isEnabled() && this.isActive()) {
            this.property.setValue(CollectionsKt.emptyList());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isActive() {
        return !((Collection)this.property.getValue()).isEmpty() && this.isEnabled();
    }

    @Override
    public boolean isSelected(@Nullable E element) {
        return Intrinsics.areEqual(this.property.getValue(), element);
    }

    @Override
    public void setSelectedElement(E element) {
        if (!this.property.getValue().contains(element)) {
            this.property.setValue(CollectionsKt.plus((Collection)this.property.getValue(), element));
        }
    }

    @Override
    public void setSelectedState(E element, boolean selected2) {
        if (this.isEnabled()) {
            if (selected2) {
                if (!this.property.getValue().contains(element)) {
                    this.property.setValue(CollectionsKt.plus((Collection)this.property.getValue(), element));
                }
            } else if (this.property.getValue().contains(element)) {
                this.property.setValue(CollectionsKt.minus((Iterable)this.property.getValue(), element));
            }
        }
    }

    @Override
    public boolean setSelectedIterableState(@NotNull Iterable<? extends E> element, boolean selected2) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setSelectedElementsState(boolean selected2, E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedElements(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedIterable(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSelectedCount() {
        return this.isActive() ? 1 : 0;
    }

    @Override
    @NotNull
    public Set<E> getSelectedSet() {
        return this.isActive() ? CollectionsKt.toSet((Iterable)this.property.getValue()) : SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.property.getValue().iterator();
    }
}

