/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.hierarchy;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.hierarchy.BreadthFirstIterator;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.HierarchyEvent;
import com.macrofocus.hierarchy.HierarchyListener;
import com.macrofocus.hierarchy.LeavesEnumeration;
import com.macrofocus.hierarchy.PostorderEnumeration;
import com.macrofocus.hierarchy.PreorderEnumeration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001OB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0015\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00018\u00002\b\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00028\u00002\b\u0010 \u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00018\u00002\b\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00028\u00002\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00028\u00002\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010)\u001a\u00020&2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010,2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J-\u00101\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u00104J-\u00105\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u00104J-\u00106\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u00104J\b\u00107\u001a\u00020\u000fH\u0004J\u001b\u00108\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u001b\u0010;\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u001b\u0010<\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u001b\u0010=\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0016J\u001f\u0010>\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010@\u0018\u00010?2\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010AJ\u001d\u0010B\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00028\u00002\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010!J\u0013\u0010C\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010DJ\u0013\u0010E\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010DJ)\u0010>\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010@\u0018\u00010?2\b\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020&H\u0004\u00a2\u0006\u0002\u0010FJ\u0015\u0010G\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010H\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u0015\u0010I\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u0017\u0010J\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u0017\u0010K\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u0015\u0010L\u001a\u00020&2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\n\u0010M\u001a\u00020NH\u0096\u0080\u0004R(\u0010\u0005\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006P"}, d2={"Lcom/macrofocus/hierarchy/AbstractHierarchy;", "T", "Lcom/macrofocus/hierarchy/Hierarchy;", "<init>", "()V", "listeners", "", "Lcom/macrofocus/hierarchy/HierarchyListener;", "getListeners", "()Ljava/util/List;", "setListeners", "(Ljava/util/List;)V", "notifyListeners", "", "addHierarchyListener", "", "listener", "addWeakHierarchyListener", "removeHierarchyListener", "hierarchyListener", "removeHierarchyListeners", "setNotifyListeners", "enable", "isRoot", "node", "(Ljava/lang/Object;)Z", "getNextSibling", "parent", "child", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "isNodeSibling", "aNode", "anotherNode", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "getPreviousSibling", "getChildAfter", "getChildBefore", "depth", "", "getDepth", "()I", "getLevel", "(Ljava/lang/Object;)I", "getPath", "", "(Ljava/lang/Object;)Ljava/util/List;", "isAncestor", "ancestor", "descendant", "notifyHierarchyNodeInserted", "index", "isAdjusting", "(Ljava/lang/Object;Ljava/lang/Object;IZ)V", "notifyHierarchyNodeChanged", "notifyHierarchyNodeRemoved", "notifyHierarchyStructureChanged", "preorderIterator", "", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "breadthFirstIterator", "depthFirstIterator", "leavesIterator", "getPathToRoot", "", "", "(Ljava/lang/Object;)[Ljava/lang/Object;", "isNodeChild", "getFirstChild", "(Ljava/lang/Object;)Ljava/lang/Object;", "getLastChild", "(Ljava/lang/Object;I)[Ljava/lang/Object;", "isLeaf", "getFirstLeaf", "getLastLeaf", "getNextLeaf", "getPreviousLeaf", "getLeafCount", "toString", "", "WeakHierarchyListener", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nAbstractHierarchy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractHierarchy.kt\ncom/macrofocus/hierarchy/AbstractHierarchy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,609:1\n1#2:610\n*E\n"})
public abstract class AbstractHierarchy<T>
implements Hierarchy<T> {
    @Nullable
    private transient List<HierarchyListener<T>> listeners;
    private boolean notifyListeners = true;

    @Nullable
    public List<HierarchyListener<T>> getListeners() {
        return this.listeners;
    }

    public void setListeners(@Nullable List<HierarchyListener<T>> list) {
        this.listeners = list;
    }

    @Override
    public void addHierarchyListener(@NotNull HierarchyListener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (this.getListeners() == null) {
            this.setListeners(CollectionFactory.INSTANCE.copyOnWriteArrayList());
        }
        Iterable iterable = this.getListeners();
        Intrinsics.checkNotNull((Object)iterable);
        iterable.add(listener2);
    }

    @Override
    public void addWeakHierarchyListener(@NotNull HierarchyListener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (this.getListeners() == null) {
            this.setListeners(CollectionFactory.INSTANCE.copyOnWriteArrayList());
        }
        WeakHierarchyListener weakListener = new WeakHierarchyListener(listener2);
        Iterable iterable = this.getListeners();
        Intrinsics.checkNotNull((Object)iterable);
        iterable.add(listener2);
    }

    @Override
    public void removeHierarchyListener(@NotNull HierarchyListener<T> hierarchyListener) {
        Intrinsics.checkNotNullParameter(hierarchyListener, (String)"hierarchyListener");
        if (this.getListeners() != null) {
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            iterable.remove(hierarchyListener);
            Iterable iterable2 = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable2);
            if (iterable2.isEmpty()) {
                this.setListeners(null);
            }
        }
    }

    @Override
    public void removeHierarchyListeners() {
        if (this.getListeners() != null) {
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            iterable.clear();
            Iterable iterable2 = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable2);
            if (iterable2.isEmpty()) {
                this.setListeners(null);
            }
        }
    }

    @Override
    public void setNotifyListeners(boolean enable) {
        boolean bl;
        boolean it = bl = enable;
        boolean bl2 = false;
        this.notifyListeners = it;
        if (bl) {
            this.notifyListeners = enable;
            if (enable) {
                this.notifyHierarchyStructureChanged();
            }
        }
    }

    @Override
    public boolean isRoot(T node) {
        return this.getRoot() == node;
    }

    @Nullable
    public final T getNextSibling(@Nullable T parent, T child) {
        T t;
        T retval = null;
        T t2 = parent;
        if (t2 != null) {
            T it = t2;
            boolean bl = false;
            t = this.getChildAfter(it, child);
        } else {
            t = null;
        }
        retval = t;
        return retval;
    }

    public final boolean isNodeSibling(T aNode, @Nullable T anotherNode) {
        T myParent;
        boolean retval = false;
        retval = anotherNode == null ? false : (anotherNode == this ? true : (myParent = this.getParent(aNode)) != null && myParent == this.getParent(anotherNode));
        return retval;
    }

    @Nullable
    public final T getPreviousSibling(@Nullable T parent, T node) {
        T t;
        T retval = null;
        T t2 = parent;
        if (t2 != null) {
            T it = t2;
            boolean bl = false;
            t = this.getChildBefore(it, node);
        } else {
            t = null;
        }
        retval = t;
        return retval;
    }

    @Nullable
    public final T getChildAfter(T parent, @Nullable T child) {
        if (child == null) {
            boolean $i$a$-requireNotNull-AbstractHierarchy$getChildAfter$22 = false;
            String $i$a$-requireNotNull-AbstractHierarchy$getChildAfter$22 = "argument is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-AbstractHierarchy$getChildAfter$22.toString());
        }
        int index = this.getIndexOfChild(parent, child);
        if (!(index != -1)) {
            boolean bl = false;
            String string = "node is not a child";
            throw new IllegalArgumentException(string.toString());
        }
        return index < this.getChildCount(parent) - 1 ? (T)this.getChild(parent, index + 1) : null;
    }

    @Nullable
    public final T getChildBefore(T parent, @Nullable T child) {
        if (child == null) {
            boolean $i$a$-requireNotNull-AbstractHierarchy$getChildBefore$22 = false;
            String $i$a$-requireNotNull-AbstractHierarchy$getChildBefore$22 = "argument is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-AbstractHierarchy$getChildBefore$22.toString());
        }
        int index = this.getIndexOfChild(parent, child);
        if (!(index != -1)) {
            boolean bl = false;
            String string = "argument is not a child";
            throw new IllegalArgumentException(string.toString());
        }
        return index > 0 ? (T)this.getChild(parent, index - 1) : null;
    }

    @Override
    public int getDepth() {
        T last = null;
        Iterable<T> it = this.breadthFirstIterator();
        for (T t : it) {
            last = t;
        }
        if (last == null) {
            throw new Error("nodes should be null");
        }
        return this.getLevel(last) - this.getLevel(this.getRoot());
    }

    @Override
    public int getLevel(T node) {
        Object ancestor = null;
        int levels = 0;
        ancestor = node;
        while (true) {
            Object var4_4;
            Object v0 = ancestor;
            Intrinsics.checkNotNull(v0);
            Object it = var4_4 = this.getParent(v0);
            boolean bl = false;
            ancestor = it;
            if (var4_4 == null) break;
            ++levels;
        }
        return levels;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<T> getPath(T node) {
        List<T> list;
        Object[] path = this.getPathToRoot(node, 0);
        if (path != null) {
            void var3_3;
            List list2 = new ArrayList(path.length);
            for (Object o : path) {
                list2.add(o);
            }
            list = var3_3;
        } else {
            list = null;
        }
        return list;
    }

    public final boolean isAncestor(T ancestor, T descendant) {
        T descendant2 = descendant;
        while (descendant2 != null) {
            if (descendant2 == ancestor) {
                return true;
            }
            descendant2 = this.getParent(descendant2);
        }
        return false;
    }

    protected final void notifyHierarchyNodeInserted(T child, T parent, int index, boolean isAdjusting) {
        if (this.getListeners() != null && this.notifyListeners) {
            HierarchyEvent<T> event = new HierarchyEvent<T>(this, HierarchyEvent.Type.Inserted, child, parent, index, isAdjusting);
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            for (HierarchyListener listener2 : iterable) {
                listener2.hierarchyNodeInserted(event);
            }
        }
    }

    @Override
    public void notifyHierarchyNodeChanged(T child, T parent, int index, boolean isAdjusting) {
        if (this.getListeners() != null && this.notifyListeners) {
            HierarchyEvent<T> event = new HierarchyEvent<T>(this, HierarchyEvent.Type.Changed, child, parent, index, isAdjusting);
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            for (HierarchyListener listener2 : iterable) {
                listener2.hierarchyNodeChanged(event);
            }
        }
    }

    protected final void notifyHierarchyNodeRemoved(T child, T parent, int index, boolean isAdjusting) {
        if (this.getListeners() != null && this.notifyListeners) {
            HierarchyEvent<T> event = new HierarchyEvent<T>(this, HierarchyEvent.Type.Removed, child, parent, index, isAdjusting);
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            for (HierarchyListener listener2 : iterable) {
                listener2.hierarchyNodeRemoved(event);
            }
        }
    }

    protected final void notifyHierarchyStructureChanged() {
        if (this.getListeners() != null && this.notifyListeners) {
            HierarchyEvent<Object> event = new HierarchyEvent<Object>(this, HierarchyEvent.Type.StructureChanged, null, null, -1, false);
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            for (HierarchyListener listener2 : iterable) {
                listener2.hierarchyStructureChanged(event);
            }
        }
    }

    @Override
    @NotNull
    public Iterable<T> preorderIterator(T parent) {
        return new Iterable<T>(this, parent){
            final /* synthetic */ AbstractHierarchy<T> this$0;
            final /* synthetic */ T $parent;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
            }

            public Iterator<T> iterator() {
                return new PreorderEnumeration<T>(this.this$0, this.$parent);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<T> breadthFirstIterator(T parent) {
        return new Iterable<T>(this, parent){
            final /* synthetic */ AbstractHierarchy<T> this$0;
            final /* synthetic */ T $parent;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
            }

            public Iterator<T> iterator() {
                return new BreadthFirstIterator<T>(this.this$0, this.$parent);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<T> depthFirstIterator(T parent) {
        return new Iterable<T>(this, parent){
            final /* synthetic */ AbstractHierarchy<T> this$0;
            final /* synthetic */ T $parent;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
            }

            public Iterator<T> iterator() {
                return new PostorderEnumeration<T>(this.this$0, this.$parent);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<T> leavesIterator(T parent) {
        return new Iterable<T>(this, parent){
            final /* synthetic */ AbstractHierarchy<T> this$0;
            final /* synthetic */ T $parent;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
            }

            public Iterator<T> iterator() {
                return new LeavesEnumeration<T>(this.this$0, this.$parent);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<T> preorderIterator() {
        return this.preorderIterator(this.getRoot());
    }

    @Override
    @NotNull
    public Iterable<T> breadthFirstIterator() {
        return this.breadthFirstIterator(this.getRoot());
    }

    @Override
    @NotNull
    public Iterable<T> depthFirstIterator() {
        return this.depthFirstIterator(this.getRoot());
    }

    @Override
    @NotNull
    public Iterable<T> leavesIterator() {
        return this.leavesIterator(this.getRoot());
    }

    @Override
    @Nullable
    public Object[] getPathToRoot(T aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    public final boolean isNodeChild(T parent, @Nullable T aNode) {
        boolean retval = false;
        retval = aNode == null ? false : (this.getChildCount(parent) == 0 ? false : this.getParent(aNode) == parent);
        return retval;
    }

    public final T getFirstChild(T node) {
        if (this.getChildCount(node) == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChild(node, 0);
    }

    public final T getLastChild(T node) {
        if (this.getChildCount(node) == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChild(node, this.getChildCount(node) - 1);
    }

    @Nullable
    protected final Object[] getPathToRoot(@Nullable T aNode, int depth) {
        int depth2 = depth;
        Object[] retNodes = null;
        if (aNode == null) {
            if (depth2 == 0) {
                return null;
            }
            retNodes = new Object[depth2];
        } else {
            retNodes = aNode == this.getRoot() ? new Object[depth2] : this.getPathToRoot(this.getParent(aNode), ++depth2);
            Intrinsics.checkNotNull((Object)retNodes);
            retNodes[retNodes.length - depth2] = aNode;
        }
        return retNodes;
    }

    @Override
    public boolean isLeaf(T node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public T getFirstLeaf(T node) {
        T node2 = node;
        while (!this.isLeaf(node2)) {
            node2 = this.getFirstChild(node2);
        }
        return node2;
    }

    @Override
    public T getLastLeaf(T node) {
        T node2 = node;
        while (!this.isLeaf(node2)) {
            node2 = this.getLastChild(node2);
        }
        return node2;
    }

    @Override
    @Nullable
    public T getNextLeaf(T node) {
        Object v1;
        block5: {
            T myParent;
            block4: {
                Object nextSibling = null;
                T t = this.getParent(node);
                if (t == null) {
                    return null;
                }
                myParent = t;
                nextSibling = this.getNextSibling(myParent, node);
                v1 = nextSibling;
                if (v1 == null) break block4;
                Object it = v1;
                boolean bl = false;
                Object v2 = this.getFirstLeaf(it);
                v1 = v2;
                if (v2 != null) break block5;
            }
            v1 = this.getNextLeaf(myParent);
        }
        return v1;
    }

    @Override
    @Nullable
    public T getPreviousLeaf(T node) {
        Object v1;
        block5: {
            T myParent;
            block4: {
                Object previousSibling = null;
                T t = this.getParent(node);
                if (t == null) {
                    return null;
                }
                myParent = t;
                previousSibling = this.getPreviousSibling(myParent, node);
                v1 = previousSibling;
                if (v1 == null) break block4;
                Object it = v1;
                boolean bl = false;
                Object v2 = this.getLastLeaf(it);
                v1 = v2;
                if (v2 != null) break block5;
            }
            v1 = this.getPreviousLeaf(myParent);
        }
        return v1;
    }

    @Override
    public int getLeafCount(T node) {
        int count = 0;
        Iterable<T> it = this.breadthFirstIterator(node);
        for (T t : it) {
            if (!this.isLeaf(t)) continue;
            ++count;
        }
        if (count < 1) {
            throw new Error("hierarchy has zero leaves");
        }
        return count;
    }

    @NotNull
    public String toString() {
        int n;
        int count = 0;
        if (this.getListeners() != null) {
            Iterable iterable = this.getListeners();
            Intrinsics.checkNotNull((Object)iterable);
            n = iterable.size();
        } else {
            n = 0;
        }
        count = n;
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "[listeners=" + count + "]";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/macrofocus/hierarchy/AbstractHierarchy$WeakHierarchyListener;", "Lcom/macrofocus/hierarchy/HierarchyListener;", "listener", "<init>", "(Lcom/macrofocus/hierarchy/AbstractHierarchy;Lcom/macrofocus/hierarchy/HierarchyListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "hierarchyNodeInserted", "", "event", "Lcom/macrofocus/hierarchy/HierarchyEvent;", "hierarchyNodeChanged", "hierarchyNodeRemoved", "hierarchyStructureChanged", "reference", "getReference", "()Lcom/macrofocus/hierarchy/HierarchyListener;", "toString", "", "macrofocus-common"})
    private final class WeakHierarchyListener
    implements HierarchyListener<T> {
        @NotNull
        private final WeakReference<HierarchyListener<T>> l_ref;

        public WeakHierarchyListener(HierarchyListener<T> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }

        @Override
        public void hierarchyNodeInserted(@NotNull HierarchyEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            HierarchyListener l = this.getReference();
            if (l != null) {
                l.hierarchyNodeInserted(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.hierarchy.HierarchyListener<T of com.macrofocus.hierarchy.AbstractHierarchy>");
                AbstractHierarchy.this.removeHierarchyListener(this);
            }
        }

        @Override
        public void hierarchyNodeChanged(@NotNull HierarchyEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            HierarchyListener l = this.getReference();
            if (l != null) {
                l.hierarchyNodeChanged(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.hierarchy.HierarchyListener<T of com.macrofocus.hierarchy.AbstractHierarchy>");
                AbstractHierarchy.this.removeHierarchyListener(this);
            }
        }

        @Override
        public void hierarchyNodeRemoved(@NotNull HierarchyEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            HierarchyListener l = this.getReference();
            if (l != null) {
                l.hierarchyNodeRemoved(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.hierarchy.HierarchyListener<T of com.macrofocus.hierarchy.AbstractHierarchy>");
                AbstractHierarchy.this.removeHierarchyListener(this);
            }
        }

        @Override
        public void hierarchyStructureChanged(@NotNull HierarchyEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            HierarchyListener l = this.getReference();
            if (l != null) {
                l.hierarchyStructureChanged(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.hierarchy.HierarchyListener<T of com.macrofocus.hierarchy.AbstractHierarchy>");
                AbstractHierarchy.this.removeHierarchyListener(this);
            }
        }

        private final HierarchyListener<T> getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            HierarchyListener l = this.getReference();
            return l != null ? "Weak[" + l + "]" : super.toString();
        }
    }
}

