/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.hierarchy;

import com.macrofocus.hierarchy.Hierarchy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007J*\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/macrofocus/hierarchy/HierarchyHelper;", "", "<init>", "()V", "print", "", "hierarchy", "Lcom/macrofocus/hierarchy/Hierarchy;", "it", "", "parent", "indent", "", "macrofocus-common"})
public final class HierarchyHelper {
    @NotNull
    public static final HierarchyHelper INSTANCE = new HierarchyHelper();

    private HierarchyHelper() {
    }

    public final void print(@NotNull Hierarchy<Object> hierarchy, @NotNull Iterable<? extends Object> it) {
        Intrinsics.checkNotNullParameter(hierarchy, (String)"hierarchy");
        Intrinsics.checkNotNullParameter(it, (String)"it");
        for (Object object : it) {
            int n = hierarchy.getLevel(object);
            for (int i = 0; i < n; ++i) {
                System.out.print((Object)" ");
            }
            System.out.println((Object)("L" + hierarchy.getLevel(object) + ": " + object));
        }
        System.out.println((Object)("The hierarchy's depth is " + hierarchy.getDepth()));
        System.out.println((Object)("The hierarchy has " + hierarchy.getLeafCount(hierarchy.getRoot()) + " leaves"));
    }

    public final void print(@NotNull Hierarchy<Object> hierarchy) {
        Intrinsics.checkNotNullParameter(hierarchy, (String)"hierarchy");
        Object object = hierarchy.getRoot();
        Intrinsics.checkNotNull((Object)object);
        this.print(hierarchy, object, 0);
        System.out.println((Object)("The hierarchy's depth is " + hierarchy.getDepth()));
        System.out.println((Object)("The hierarchy has " + hierarchy.getLeafCount(hierarchy.getRoot()) + " leaves"));
    }

    private final void print(Hierarchy<Object> hierarchy, Object parent, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print((Object)" ");
        }
        System.out.println((Object)("L" + hierarchy.getLevel(parent) + ": " + parent));
        Iterable<Object> iterable = hierarchy.getChildren(parent);
        Intrinsics.checkNotNull(iterable);
        for (Object node : iterable) {
            this.print(hierarchy, node, indent + 4);
        }
    }
}

