/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.hierarchy;

import com.macrofocus.hierarchy.AbstractHierarchy;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.MutableHierarchy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0014\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010#\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010&2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J%\u0010(\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010*J\u001d\u0010(\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J#\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00028\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016\u00a2\u0006\u0002\u0010/J#\u00100\u001a\u00020-2\u0006\u0010\u0016\u001a\u00028\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016\u00a2\u0006\u0002\u0010/J\u0016\u00101\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J%\u00102\u001a\u00020-2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020-H\u0016J\u001d\u00105\u001a\u00020-2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J%\u00105\u001a\u00020-2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00107J-\u00108\u001a\u00020-2\u0006\u00109\u001a\u00028\u00002\u0006\u0010:\u001a\u00028\u00002\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\u00020-2\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J#\u0010?\u001a\u00020-2\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010@R\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/macrofocus/hierarchy/SimpleHierarchy;", "T", "Lcom/macrofocus/hierarchy/AbstractHierarchy;", "Lcom/macrofocus/hierarchy/MutableHierarchy;", "root", "<init>", "(Ljava/lang/Object;)V", "hierarchy", "Lcom/macrofocus/hierarchy/Hierarchy;", "(Lcom/macrofocus/hierarchy/Hierarchy;)V", "getRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "parentChildren", "", "", "childParent", "getParent", "child", "(Ljava/lang/Object;)Ljava/lang/Object;", "hasChild", "", "parent", "(Ljava/lang/Object;)Z", "getChildren", "", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "getChild", "index", "", "(Ljava/lang/Object;I)Ljava/lang/Object;", "getChildCount", "(Ljava/lang/Object;)I", "getIndexOfChild", "(Ljava/lang/Object;Ljava/lang/Object;)I", "containsChild", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "getChildList", "", "(Ljava/lang/Object;)Ljava/util/List;", "addChild", "isAdjusting", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "setChildren", "", "children", "(Ljava/lang/Object;Ljava/util/List;)V", "addChildren", "removeChildren", "insertChild", "(Ljava/lang/Object;ILjava/lang/Object;)V", "removeAll", "removeChild", "(Ljava/lang/Object;Ljava/lang/Object;)V", "(Ljava/lang/Object;Ljava/lang/Object;Z)V", "moveChild", "oldParent", "newParent", "insertionPoint", "(Ljava/lang/Object;Ljava/lang/Object;ILjava/lang/Object;)V", "copyFrom", "source", "recursiveCopyFrom", "(Lcom/macrofocus/hierarchy/Hierarchy;Ljava/lang/Object;)V", "macrofocus-common"})
public final class SimpleHierarchy<T>
extends AbstractHierarchy<T>
implements MutableHierarchy<T> {
    private final T root;
    @NotNull
    private final Map<T, List<T>> parentChildren;
    @NotNull
    private final Map<T, T> childParent;

    public SimpleHierarchy(T root) {
        this.root = root;
        this.parentChildren = new HashMap();
        this.childParent = new HashMap();
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    public SimpleHierarchy(@NotNull Hierarchy<T> hierarchy) {
        Intrinsics.checkNotNullParameter(hierarchy, (String)"hierarchy");
        this(hierarchy.getRoot());
        super.copyFrom(hierarchy);
    }

    @Override
    @Nullable
    public T getParent(T child) {
        return this.childParent.get(child);
    }

    @Override
    public boolean hasChild(T parent) {
        return this.parentChildren.containsKey(parent);
    }

    @Override
    @Nullable
    public Iterable<T> getChildren(T parent) {
        return this.getChildList(parent);
    }

    @Override
    public T getChild(T parent, int index) {
        List<T> list = this.getChildList(parent);
        Intrinsics.checkNotNull(list);
        return list.get(index);
    }

    @Override
    public int getChildCount(T parent) {
        List<T> list = this.getChildList(parent);
        Intrinsics.checkNotNull(list);
        return list.size();
    }

    @Override
    public int getIndexOfChild(T parent, T child) {
        List<T> list = this.getChildList(parent);
        Intrinsics.checkNotNull(list);
        return list.indexOf(child);
    }

    @Override
    public boolean containsChild(T parent, T child) {
        List<T> list = this.getChildList(parent);
        Intrinsics.checkNotNull(list);
        return list.contains(child);
    }

    @Override
    public boolean containsChild(T child) {
        return this.childParent.containsKey(child);
    }

    @Override
    @Nullable
    public List<T> getChildList(T parent) {
        return this.parentChildren.containsKey(parent) ? this.parentChildren.get(parent) : CollectionsKt.emptyList();
    }

    private final T addChild(T parent, T child, boolean isAdjusting) {
        List<T> list;
        if (!this.parentChildren.containsKey(child)) {
            list = null;
            if (!this.parentChildren.containsKey(parent)) {
                list = new ArrayList();
                this.parentChildren.put(parent, list);
            } else {
                List<T> list2 = this.parentChildren.get(parent);
                Intrinsics.checkNotNull(list2);
                list = list2;
            }
        } else {
            throw new IllegalArgumentException("Child " + child + " already exists");
        }
        list.add(child);
        this.childParent.put(child, parent);
        int index = list.size() - 1;
        this.notifyHierarchyNodeInserted(child, parent, index, isAdjusting);
        return child;
    }

    @Override
    public T addChild(T parent, T child) {
        return this.addChild(parent, child, false);
    }

    @Override
    public void setChildren(T parent, @NotNull List<? extends T> children) {
        Object child;
        int i;
        Intrinsics.checkNotNullParameter(children, (String)"children");
        List toRemove = new ArrayList();
        Iterable<T> iterable = this.getChildren(parent);
        Intrinsics.checkNotNull(iterable);
        for (T child2 : iterable) {
            toRemove.add(child2);
        }
        int n = ((Collection)toRemove).size();
        for (i = 0; i < n; ++i) {
            child = toRemove.get(i);
            this.removeChild(parent, child, children.size() > 0 || i < toRemove.size() - 1);
        }
        n = ((Collection)children).size();
        for (i = 0; i < n; ++i) {
            child = children.get(i);
            this.addChild(parent, child, i < children.size() - 1);
        }
    }

    @Override
    public void addChildren(T parent, @NotNull List<? extends T> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        int n = ((Collection)children).size();
        for (int i = 0; i < n; ++i) {
            T child = children.get(i);
            this.addChild(parent, child, i < children.size() - 1);
        }
    }

    @Override
    public void removeChildren(@NotNull List<? extends T> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        int n = ((Collection)children).size();
        for (int i = 0; i < n; ++i) {
            T child = children.get(i);
            T t = this.getParent(child);
            Intrinsics.checkNotNull(t);
            this.removeChild(t, child, i < children.size() - 1);
        }
    }

    @Override
    public void insertChild(T parent, int index, T child) {
        List<T> list;
        if (!this.parentChildren.containsKey(child)) {
            list = null;
            if (!this.parentChildren.containsKey(parent)) {
                list = new ArrayList();
                this.parentChildren.put(parent, list);
            } else {
                List<T> list2 = this.parentChildren.get(parent);
                Intrinsics.checkNotNull(list2);
                list = list2;
            }
        } else {
            throw new IllegalArgumentException("Child " + child + " already exists");
        }
        list.add(index, child);
        this.childParent.put(child, parent);
        this.notifyHierarchyNodeInserted(child, parent, index, false);
    }

    @Override
    public void removeAll() {
        this.parentChildren.clear();
        this.childParent.clear();
        this.notifyHierarchyStructureChanged();
    }

    @Override
    public void removeChild(T parent, T child) {
        this.removeChild(parent, child, false);
    }

    private final void removeChild(T parent, T child, boolean isAdjusting) {
        int index;
        if (!this.parentChildren.containsKey(child)) {
            if (this.childParent.containsKey(child)) {
                this.childParent.remove(child);
            }
            index = this.getIndexOfChild(parent, child);
            List<T> list = this.parentChildren.get(parent);
            Intrinsics.checkNotNull(list);
            List<T> list2 = list;
            list2.remove(child);
            if (list2.isEmpty()) {
                this.parentChildren.remove(parent);
            }
        } else {
            throw new IllegalArgumentException("Child " + child + " contains children");
        }
        this.notifyHierarchyNodeRemoved(child, parent, index, isAdjusting);
    }

    @Override
    public void moveChild(T oldParent, T newParent, int insertionPoint, T child) {
        int insertionPoint2 = insertionPoint;
        SimpleHierarchy $this$moveChild_u24lambda_u240 = this;
        boolean bl = false;
        if ($this$moveChild_u24lambda_u240.childParent.containsKey(child)) {
            $this$moveChild_u24lambda_u240.childParent.remove(child);
        }
        int index = $this$moveChild_u24lambda_u240.getIndexOfChild(oldParent, child);
        List<T> list = $this$moveChild_u24lambda_u240.parentChildren.get(oldParent);
        Intrinsics.checkNotNull(list);
        List<T> list2 = list;
        list2.remove(child);
        if (list2.isEmpty()) {
            $this$moveChild_u24lambda_u240.parentChildren.remove(oldParent);
        }
        $this$moveChild_u24lambda_u240.notifyHierarchyNodeRemoved(child, oldParent, index, true);
        List<T> list3 = null;
        if (!this.parentChildren.containsKey(newParent)) {
            list3 = new ArrayList();
            this.parentChildren.put(newParent, list3);
        } else {
            List<T> list4 = this.parentChildren.get(newParent);
            Intrinsics.checkNotNull(list4);
            list3 = list4;
        }
        insertionPoint2 = Math.min(insertionPoint2, list3.size() - 1);
        insertionPoint2 = Math.max(0, insertionPoint2);
        list3.add(insertionPoint2, child);
        this.childParent.put(child, newParent);
        this.notifyHierarchyNodeInserted(child, newParent, insertionPoint2, false);
    }

    private final void copyFrom(Hierarchy<T> source) {
        this.recursiveCopyFrom(source, source.getRoot());
    }

    private final void recursiveCopyFrom(Hierarchy<T> source, T parent) {
        Iterable<T> iterable = source.getChildren(parent);
        Intrinsics.checkNotNull(iterable);
        for (T child : iterable) {
            this.addChild(parent, child);
            if (!source.hasChild(child)) continue;
            this.recursiveCopyFrom(source, child);
        }
    }
}

