/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.legacy.TreeSet;
import org.locationtech.jts.util.Assert;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\b\u0016\u0018\u0000 *2\u00020\u0001:\u0002)*B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ+\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J+\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002J#\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010$\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010&J!\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lorg/locationtech/jts/algorithm/ConvexHull;", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/GeometryFactory;)V", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "(Lorg/locationtech/jts/geom/Geometry;)V", "inputPts", "[Lorg/locationtech/jts/geom/Coordinate;", "convexHull", "getConvexHull", "()Lorg/locationtech/jts/geom/Geometry;", "toCoordinateArray", "stack", "", "Lorg/locationtech/jts/legacy/Stack;", "(Ljava/util/List;)[Lorg/locationtech/jts/geom/Coordinate;", "reduce", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "padArray3", "preSort", "grahamScan", "c", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/List;", "isBetween", "", "c1", "c2", "c3", "computeOctRing", "computeOctPts", "lineOrPolygon", "coordinates", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Geometry;", "cleanRing", "original", "RadialComparator", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nConvexHull.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvexHull.kt\norg/locationtech/jts/algorithm/ConvexHull\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,469:1\n21#2:470\n21#2:471\n21#2:472\n21#2:473\n21#2:474\n21#2:475\n37#3,2:476\n*S KotlinDebug\n*F\n+ 1 ConvexHull.kt\norg/locationtech/jts/algorithm/ConvexHull\n*L\n197#1:470\n198#1:471\n199#1:472\n208#1:473\n209#1:474\n211#1:475\n391#1:476,2\n*E\n"})
public class ConvexHull {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geomFactory;
    @NotNull
    private final Coordinate[] inputPts;

    public ConvexHull(@NotNull Coordinate[] pts, @NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        this.inputPts = UniqueCoordinateArrayFilter.Companion.filterCoordinates(pts);
        this.geomFactory = geomFactory;
    }

    public ConvexHull(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this(ConvexHull.Companion.extractCoordinates(geometry), geometry.getFactory());
    }

    @NotNull
    public final Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return this.geomFactory.createGeometryCollection();
        }
        if (this.inputPts.length == 1) {
            return this.geomFactory.createPoint(this.inputPts[0]);
        }
        if (this.inputPts.length == 2) {
            return this.geomFactory.createLineString(this.inputPts);
        }
        Coordinate[] reducedPts = this.inputPts;
        if (this.inputPts.length > 50) {
            reducedPts = this.reduce(this.inputPts);
        }
        Coordinate[] sortedPts = this.preSort(reducedPts);
        List<Coordinate> cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    @NotNull
    protected final Coordinate[] toCoordinateArray(@NotNull List<Coordinate> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Object[] coordinates = new Coordinate[stack.size()];
        int n = ((Collection)stack).size();
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = stack.get(i);
            coordinates[i] = coordinate;
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordinates);
    }

    private final Coordinate[] reduce(Coordinate[] inputPts) {
        int i;
        Coordinate[] coordinateArray = this.computeOctRing(inputPts);
        if (coordinateArray == null) {
            return inputPts;
        }
        Coordinate[] polyPts = coordinateArray;
        TreeSet<Comparable> reducedSet = new TreeSet<Comparable>(null, null, 3, null);
        int n = polyPts.length;
        for (i = 0; i < n; ++i) {
            reducedSet.add(polyPts[i]);
        }
        n = inputPts.length;
        for (i = 0; i < n; ++i) {
            if (PointLocation.isInRing(inputPts[i], polyPts)) continue;
            reducedSet.add(inputPts[i]);
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray((Collection)((Object)reducedSet));
        return reducedPts.length < 3 ? this.padArray3(reducedPts) : reducedPts;
    }

    private final Coordinate[] padArray3(Coordinate[] pts) {
        Object[] pad = new Coordinate[3];
        int n = pad.length;
        for (int i = 0; i < n; ++i) {
            pad[i] = i < pts.length ? pts[i] : pts[0];
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])pad);
    }

    private final Coordinate[] preSort(Coordinate[] pts) {
        Coordinate t = null;
        int n = pts.length;
        for (int i = 1; i < n; ++i) {
            if (!(pts[i].y < pts[0].y) && (!(pts[i].y == pts[0].y) || !(pts[i].x < pts[0].x))) continue;
            t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        ArraysKt.sortWith((Object[])pts, (Comparator)new RadialComparator(pts[0]), (int)1, (int)pts.length);
        return pts;
    }

    private final List<Coordinate> grahamScan(Coordinate[] c) {
        List $this$push$iv;
        List ps;
        Coordinate p = null;
        List list = ps = (List)new ArrayList();
        Coordinate item$iv = c[0];
        boolean $i$f$push = false;
        $this$push$iv.add(item$iv);
        $this$push$iv = ps;
        item$iv = c[1];
        $i$f$push = false;
        $this$push$iv.add(item$iv);
        $this$push$iv = ps;
        item$iv = c[2];
        $i$f$push = false;
        $this$push$iv.add(item$iv);
        int item$iv2 = c.length;
        for (int i = 3; i < item$iv2; ++i) {
            List $this$push$iv2;
            Object t = StackKt.pop(ps);
            Intrinsics.checkNotNull(t);
            p = (Coordinate)t;
            while (!StackKt.empty(ps)) {
                Object t2 = StackKt.peek(ps);
                Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
                if (Orientation.index((Coordinate)t2, p, c[i]) <= 0) break;
                Object t3 = StackKt.pop(ps);
                Intrinsics.checkNotNull(t3);
                p = (Coordinate)t3;
            }
            List $i$f$push2 = ps;
            Coordinate item$iv3 = p;
            boolean $i$f$push3 = false;
            $this$push$iv2.add(item$iv3);
            $this$push$iv2 = ps;
            item$iv3 = c[i];
            $i$f$push3 = false;
            $this$push$iv2.add(item$iv3);
        }
        List i = ps;
        item$iv = c[0];
        $i$f$push = false;
        $this$push$iv.add(item$iv);
        return ps;
    }

    private final boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (Orientation.index(c1, c2, c3) != 0) {
            return false;
        }
        double d = c1.x;
        Coordinate coordinate = c3;
        Intrinsics.checkNotNull((Object)coordinate);
        if (!(d == coordinate.x)) {
            double d2 = c1.x;
            Coordinate coordinate2 = c2;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (d2 <= coordinate2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (!(c1.y == c3.y)) {
            double d3 = c1.y;
            Coordinate coordinate3 = c2;
            Intrinsics.checkNotNull((Object)coordinate3);
            if (d3 <= coordinate3.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private final Coordinate[] computeOctRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeOctPts(inputPts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private final Coordinate[] computeOctPts(Coordinate[] inputPts) {
        Object[] pts = new Coordinate[8];
        int n = pts.length;
        for (int j = 0; j < n; ++j) {
            pts[j] = inputPts[0];
        }
        n = inputPts.length;
        for (int i = 1; i < n; ++i) {
            double d = inputPts[i].x;
            Object object = pts[0];
            Intrinsics.checkNotNull((Object)object);
            if (d < ((Coordinate)object).x) {
                pts[0] = inputPts[i];
            }
            double d2 = inputPts[i].x - inputPts[i].y;
            Object object2 = pts[1];
            Intrinsics.checkNotNull((Object)object2);
            double d3 = ((Coordinate)object2).x;
            Object object3 = pts[1];
            Intrinsics.checkNotNull((Object)object3);
            if (d2 < d3 - ((Coordinate)object3).y) {
                pts[1] = inputPts[i];
            }
            double d4 = inputPts[i].y;
            Object object4 = pts[2];
            Intrinsics.checkNotNull((Object)object4);
            if (d4 > ((Coordinate)object4).y) {
                pts[2] = inputPts[i];
            }
            double d5 = inputPts[i].x + inputPts[i].y;
            Object object5 = pts[3];
            Intrinsics.checkNotNull((Object)object5);
            double d6 = ((Coordinate)object5).x;
            Object object6 = pts[3];
            Intrinsics.checkNotNull((Object)object6);
            if (d5 > d6 + ((Coordinate)object6).y) {
                pts[3] = inputPts[i];
            }
            double d7 = inputPts[i].x;
            Object object7 = pts[4];
            Intrinsics.checkNotNull((Object)object7);
            if (d7 > ((Coordinate)object7).x) {
                pts[4] = inputPts[i];
            }
            double d8 = inputPts[i].x - inputPts[i].y;
            Object object8 = pts[5];
            Intrinsics.checkNotNull((Object)object8);
            double d9 = ((Coordinate)object8).x;
            Object object9 = pts[5];
            Intrinsics.checkNotNull((Object)object9);
            if (d8 > d9 - ((Coordinate)object9).y) {
                pts[5] = inputPts[i];
            }
            double d10 = inputPts[i].y;
            Object object10 = pts[6];
            Intrinsics.checkNotNull((Object)object10);
            if (d10 < ((Coordinate)object10).y) {
                pts[6] = inputPts[i];
            }
            double d11 = inputPts[i].x + inputPts[i].y;
            Object object11 = pts[7];
            Intrinsics.checkNotNull((Object)object11);
            double d12 = ((Coordinate)object11).x;
            Object object12 = pts[7];
            Intrinsics.checkNotNull((Object)object12);
            if (!(d11 < d12 + ((Coordinate)object12).y)) continue;
            pts[7] = inputPts[i];
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])pts);
    }

    private final Geometry lineOrPolygon(Coordinate[] coordinates) {
        Coordinate[] coordinates2 = coordinates;
        if ((coordinates2 = this.cleanRing(coordinates2)).length == 3) {
            Coordinate[] coordinateArray = new Coordinate[]{coordinates2[0], coordinates2[1]};
            return this.geomFactory.createLineString(coordinateArray);
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinates2);
        return GeometryFactory.createPolygon$default(this.geomFactory, linearRing, null, 2, null);
    }

    private final Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals$default(Assert.INSTANCE, original[0], original[original.length - 1], null, 4, null);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        int i = 0;
        int n = original.length - 2;
        if (i <= n) {
            while (true) {
                Coordinate nextCoordinate;
                Coordinate currentCoordinate;
                if (!(Intrinsics.areEqual((Object)(currentCoordinate = original[i]), (Object)(nextCoordinate = original[i + 1])) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate))) {
                    cleanedRing.add(currentCoordinate);
                    previousDistinctCoordinate = currentCoordinate;
                }
                if (i == n) break;
                ++i;
            }
        }
        cleanedRing.add(original[original.length - 1]);
        Collection $this$toTypedArray$iv = cleanedRing;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/ConvexHull$Companion;", "", "<init>", "()V", "extractCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate[] extractCoordinates(Geometry geom) {
            UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
            geom.apply(filter);
            return filter.getCoordinates();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000b2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u000bB\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/ConvexHull$RadialComparator;", "Ljava/util/Comparator;", "Lorg/locationtech/jts/geom/Coordinate;", "Lkotlin/Comparator;", "origin", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "compare", "", "o1", "o2", "Companion", "kts-core"})
    private static final class RadialComparator
    implements Comparator<Coordinate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Coordinate origin;

        public RadialComparator(@Nullable Coordinate origin) {
            this.origin = origin;
        }

        @Override
        public int compare(@NotNull Coordinate o1, @NotNull Coordinate o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return RadialComparator.Companion.polarCompare(this.origin, o1, o2);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/ConvexHull$RadialComparator$Companion;", "", "<init>", "()V", "polarCompare", "", "o", "Lorg/locationtech/jts/geom/Coordinate;", "p", "q", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
                double d = p.x;
                Coordinate coordinate = o;
                Intrinsics.checkNotNull((Object)coordinate);
                double dxp = d - coordinate.x;
                double dyp = p.y - o.y;
                double dxq = q.x - o.x;
                double dyq = q.y - o.y;
                int orient = Orientation.index(o, p, q);
                if (orient == 1) {
                    return 1;
                }
                if (orient == -1) {
                    return -1;
                }
                double op = dxp * dxp + dyp * dyp;
                double oq = dxq * dxq + dyq * dyq;
                if (op < oq) {
                    return -1;
                }
                return op > oq ? 1 : 0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

