/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.NotRepresentableException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\u0010B)\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u000b\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\u0013R\u001c\u0010\u0014\u001a\u00020\u00058FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\u00058FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/algorithm/HCoordinate;", "", "<init>", "()V", "_x", "", "_y", "_w", "(DDD)V", "(DD)V", "p", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Coordinate;)V", "p1", "p2", "(Lorg/locationtech/jts/algorithm/HCoordinate;Lorg/locationtech/jts/algorithm/HCoordinate;)V", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "q1", "q2", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "x", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "w", "getW", "setW", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
public final class HCoordinate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double w;

    public final double getX() {
        double a = this.x / this.w;
        if (Math.INSTANCE.isNaN(a) || Math.INSTANCE.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        double a = this.y / this.w;
        if (Math.INSTANCE.isNaN(a) || Math.INSTANCE.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getW() {
        return this.w;
    }

    public final void setW(double d) {
        this.w = d;
    }

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double _x, double _y, double _w) {
        this.x = _x;
        this.y = _y;
        this.w = _w;
    }

    public HCoordinate(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.w = 1.0;
    }

    public HCoordinate(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.x = p.x;
        this.y = p.y;
        this.w = 1.0;
    }

    public HCoordinate(@NotNull HCoordinate p1, @NotNull HCoordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.x = p1.getY() * p2.w - p2.getY() * p1.w;
        this.y = p2.getX() * p1.w - p1.getX() * p2.w;
        this.w = p1.getX() * p2.getY() - p2.getX() * p1.getY();
    }

    public HCoordinate(@NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.x = p1.y - p2.y;
        this.y = p2.x - p1.x;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public HCoordinate(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
        Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
        double px = p1.y - p2.y;
        double py = p2.x - p1.x;
        double pw = p1.x * p2.y - p2.x * p1.y;
        double qx = q1.y - q2.y;
        double qy = q2.x - q1.x;
        double qw = q1.x * q2.y - q2.x * q1.y;
        this.x = py * qw - qy * pw;
        this.y = qx * pw - px * qw;
        this.w = px * qy - qx * py;
    }

    @NotNull
    public final Coordinate getCoordinate() {
        Coordinate p = new Coordinate();
        p.x = this.getX();
        p.y = this.getY();
        return p;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/HCoordinate$Companion;", "", "<init>", "()V", "intersection", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "q1", "q2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="use {@link Intersection#intersection(Coordinate, Coordinate, Coordinate, Coordinate)}")
        @NotNull
        public final Coordinate intersection(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) throws NotRepresentableException {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
            Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
            double px = p1.y - p2.y;
            double py = p2.x - p1.x;
            double pw = p1.x * p2.y - p2.x * p1.y;
            double qx = q1.y - q2.y;
            double qy = q2.x - q1.x;
            double qw = q1.x * q2.y - q2.x * q1.y;
            double x = py * qw - qy * pw;
            double y = qx * pw - px * qw;
            double w = px * qy - qx * py;
            double xInt = x / w;
            double yInt = y / w;
            if (Math.INSTANCE.isNaN(xInt) || Math.INSTANCE.isInfinite(xInt) || Math.INSTANCE.isNaN(yInt) || Math.INSTANCE.isInfinite(yInt)) {
                throw new NotRepresentableException();
            }
            return new Coordinate(xInt, yInt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

