/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u001b\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointLine;", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "centroid", "Lorg/locationtech/jts/geom/Coordinate;", "minDistance", "", "value", "interiorPoint", "getInteriorPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "addInterior", "", "geom", "pts", "", "([Lorg/locationtech/jts/geom/Coordinate;)V", "addEndpoints", "add", "point", "Companion", "kts-core"})
public final class InteriorPointLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate centroid;
    private double minDistance;
    @Nullable
    private Coordinate interiorPoint;

    public InteriorPointLine(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.minDistance = Double.MAX_VALUE;
        Coordinate coordinate = g.getCentroid().getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        this.centroid = coordinate;
        this.addInterior(g);
        if (this.interiorPoint == null) {
            this.addEndpoints(g);
        }
    }

    @Nullable
    public final Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private final void addInterior(Geometry geom) {
        if (geom instanceof LineString) {
            this.addInterior(((LineString)geom).getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            Geometry gc = geom;
            int n = ((GeometryCollection)gc).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.addInterior(((GeometryCollection)gc).getGeometryN(i));
            }
        }
    }

    private final void addInterior(Coordinate[] pts) {
        int n = pts.length - 1;
        for (int i = 1; i < n; ++i) {
            this.add(pts[i]);
        }
    }

    private final void addEndpoints(Geometry geom) {
        if (geom instanceof LineString) {
            this.addEndpoints(((LineString)geom).getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            Geometry gc = geom;
            int n = ((GeometryCollection)gc).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.addEndpoints(((GeometryCollection)gc).getGeometryN(i));
            }
        }
    }

    private final void addEndpoints(Coordinate[] pts) {
        this.add(pts[0]);
        this.add(pts[pts.length - 1]);
    }

    private final void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointLine$Companion;", "", "<init>", "()V", "getInteriorPoint", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Coordinate getInteriorPoint(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            InteriorPointLine intPt = new InteriorPointLine(geom);
            return intPt.getInteriorPoint();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

