/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/algorithm/PointLocator;", "", "<init>", "()V", "boundaryRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "(Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "isIn", "", "numBoundaries", "", "intersects", "p", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "locate", "computeLocation", "", "updateLocationInfo", "loc", "locateOnPoint", "pt", "Lorg/locationtech/jts/geom/Point;", "locateOnLineString", "l", "Lorg/locationtech/jts/geom/LineString;", "locateInPolygonRing", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "locateInPolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "kts-core"})
@SourceDebugExtension(value={"SMAP\nPointLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointLocator.kt\norg/locationtech/jts/algorithm/PointLocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class PointLocator {
    @NotNull
    private BoundaryNodeRule boundaryRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
    private boolean isIn;
    private int numBoundaries;

    public PointLocator() {
    }

    public PointLocator(@Nullable BoundaryNodeRule boundaryRule) {
        if (boundaryRule == null) {
            boolean bl = false;
            String string = "Rule must be non-null";
            throw new IllegalArgumentException(string.toString());
        }
        this.boundaryRule = boundaryRule;
    }

    public final boolean intersects(@NotNull Coordinate p, @NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.locate(p, geom) != 2;
    }

    public final int locate(@NotNull Coordinate p, @NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (geom.isEmpty()) {
            return 2;
        }
        if (geom instanceof LineString) {
            return this.locateOnLineString(p, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.locateInPolygon(p, (Polygon)geom);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(p, geom);
        if (this.boundaryRule.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        return this.numBoundaries > 0 || this.isIn ? 0 : 2;
    }

    private final void computeLocation(Coordinate p, Geometry geom) {
        block5: {
            Geometry geometry;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (geom instanceof Point) {
                                this.updateLocationInfo(this.locateOnPoint(p, (Point)geom));
                            }
                            if (!((geometry = geom) instanceof LineString)) break block4;
                            this.updateLocationInfo(this.locateOnLineString(p, (LineString)geom));
                            break block5;
                        }
                        if (!(geometry instanceof Polygon)) break block6;
                        this.updateLocationInfo(this.locateInPolygon(p, (Polygon)geom));
                        break block5;
                    }
                    if (!(geometry instanceof MultiLineString)) break block7;
                    int n = ((MultiLineString)geom).getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        Geometry geometry2 = ((MultiLineString)geom).getGeometryN(i);
                        Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                        LineString l = (LineString)geometry2;
                        this.updateLocationInfo(this.locateOnLineString(p, l));
                    }
                    break block5;
                }
                if (!(geometry instanceof MultiPolygon)) break block8;
                int n = ((MultiPolygon)geom).getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    Geometry geometry3 = ((MultiPolygon)geom).getGeometryN(i);
                    Intrinsics.checkNotNull((Object)geometry3, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                    Polygon poly = (Polygon)geometry3;
                    this.updateLocationInfo(this.locateInPolygon(p, poly));
                }
                break block5;
            }
            if (!(geometry instanceof GeometryCollection)) break block5;
            Iterator geomi = new GeometryCollectionIterator(geom);
            while (geomi.hasNext()) {
                Object e = geomi.next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
                Geometry g2 = (Geometry)e;
                if (g2 == geom) continue;
                this.computeLocation(p, g2);
            }
        }
    }

    private final void updateLocationInfo(int loc) {
        if (loc == 0) {
            this.isIn = true;
        }
        if (loc == 1) {
            int n = this.numBoundaries;
            this.numBoundaries = n + 1;
        }
    }

    private final int locateOnPoint(Coordinate p, Point pt) {
        Coordinate ptCoord;
        Coordinate coordinate = ptCoord = pt.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate.equals2D(p) ? 0 : 2;
    }

    private final int locateOnLineString(Coordinate p, LineString l) {
        if (!l.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        CoordinateSequence seq = l.getCoordinateSequence();
        if (!l.isClosed()) {
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            if (Intrinsics.areEqual((Object)p, (Object)coordinateSequence.getCoordinate(0)) || Intrinsics.areEqual((Object)p, (Object)seq.getCoordinate(seq.size() - 1))) {
                return 1;
            }
        }
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return PointLocation.isOnLine(p, coordinateSequence) ? 0 : 2;
    }

    private final int locateInPolygonRing(Coordinate p, LinearRing ring) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        return !linearRing.getEnvelopeInternal().intersects(p) ? 2 : PointLocation.locateInRing(p, ring.getCoordinates());
    }

    private final int locateInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = poly.getExteriorRing();
        int shellLoc = this.locateInPolygonRing(p, shell);
        if (shellLoc == 2) {
            return 2;
        }
        if (shellLoc == 1) {
            return 1;
        }
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            int holeLoc = this.locateInPolygonRing(p, hole);
            if (holeLoc == 0) {
                return 2;
            }
            if (holeLoc != 1) continue;
            return 1;
        }
        return 0;
    }
}

