/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/algorithm/Rectangle;", "", "<init>", "()V", "createFromSidePts", "Lorg/locationtech/jts/geom/Polygon;", "baseRightPt", "Lorg/locationtech/jts/geom/Coordinate;", "baseLeftPt", "oppositePt", "leftSidePt", "rightSidePt", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "computeLineEquationC", "", "a", "b", "p", "createLineForStandardEquation", "Lorg/locationtech/jts/geom/LineSegment;", "c", "kts-core"})
public final class Rectangle {
    @NotNull
    public static final Rectangle INSTANCE = new Rectangle();

    private Rectangle() {
    }

    @NotNull
    public final Polygon createFromSidePts(@NotNull Coordinate baseRightPt, @NotNull Coordinate baseLeftPt, @NotNull Coordinate oppositePt, @NotNull Coordinate leftSidePt, @NotNull Coordinate rightSidePt, @NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)baseRightPt, (String)"baseRightPt");
        Intrinsics.checkNotNullParameter((Object)baseLeftPt, (String)"baseLeftPt");
        Intrinsics.checkNotNullParameter((Object)oppositePt, (String)"oppositePt");
        Intrinsics.checkNotNullParameter((Object)leftSidePt, (String)"leftSidePt");
        Intrinsics.checkNotNullParameter((Object)rightSidePt, (String)"rightSidePt");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        double dx = baseLeftPt.x - baseRightPt.x;
        double dy = baseLeftPt.y - baseRightPt.y;
        double baseC = this.computeLineEquationC(dx, dy, baseRightPt);
        double oppC = this.computeLineEquationC(dx, dy, oppositePt);
        double leftC = this.computeLineEquationC(-dy, dx, leftSidePt);
        double rightC = this.computeLineEquationC(-dy, dx, rightSidePt);
        LineSegment baseLine = this.createLineForStandardEquation(-dy, dx, baseC);
        LineSegment oppLine = this.createLineForStandardEquation(-dy, dx, oppC);
        LineSegment leftLine = this.createLineForStandardEquation(-dx, -dy, leftC);
        LineSegment rightLine = this.createLineForStandardEquation(-dx, -dy, rightC);
        Coordinate p0 = rightSidePt.equals2D(baseRightPt) ? baseRightPt.copy() : baseLine.lineIntersection(rightLine);
        Coordinate p1 = leftSidePt.equals2D(baseLeftPt) ? baseLeftPt.copy() : baseLine.lineIntersection(leftLine);
        Coordinate p2 = leftSidePt.equals2D(oppositePt) ? oppositePt.copy() : oppLine.lineIntersection(leftLine);
        Coordinate p3 = rightSidePt.equals2D(oppositePt) ? oppositePt.copy() : oppLine.lineIntersection(rightLine);
        Coordinate[] coordinateArray = new Coordinate[]{p0, p1, p2, p3, p0.copy()};
        LinearRing shell = factory.createLinearRing(coordinateArray);
        return GeometryFactory.createPolygon$default(factory, shell, null, 2, null);
    }

    private final double computeLineEquationC(double a, double b, Coordinate p) {
        return a * p.y - b * p.x;
    }

    private final LineSegment createLineForStandardEquation(double a, double b, double c) {
        Coordinate p0 = null;
        Coordinate p1 = null;
        if (Math.abs(b) > Math.abs(a)) {
            p0 = new Coordinate(0.0, c / b);
            p1 = new Coordinate(1.0, c / b - a / b);
        } else {
            p0 = new Coordinate(c / a, 0.0);
            p1 = new Coordinate(c / a - b / a, 1.0);
        }
        return new LineSegment(p0, p1);
    }
}

