/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/algorithm/RectangleLineIntersector;", "", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "diagUp0", "Lorg/locationtech/jts/geom/Coordinate;", "diagUp1", "diagDown0", "diagDown1", "intersects", "", "p0", "p1", "kts-core"})
public final class RectangleLineIntersector {
    @NotNull
    private final Envelope rectEnv;
    @NotNull
    private final LineIntersector li;
    @NotNull
    private final Coordinate diagUp0;
    @NotNull
    private final Coordinate diagUp1;
    @NotNull
    private final Coordinate diagDown0;
    @NotNull
    private final Coordinate diagDown1;

    public RectangleLineIntersector(@NotNull Envelope rectEnv) {
        Intrinsics.checkNotNullParameter((Object)rectEnv, (String)"rectEnv");
        this.rectEnv = rectEnv;
        this.li = new RobustLineIntersector();
        this.diagUp0 = new Coordinate(this.rectEnv.getMinX(), this.rectEnv.getMinY());
        this.diagUp1 = new Coordinate(this.rectEnv.getMaxX(), this.rectEnv.getMaxY());
        this.diagDown0 = new Coordinate(this.rectEnv.getMinX(), this.rectEnv.getMaxY());
        this.diagDown1 = new Coordinate(this.rectEnv.getMaxX(), this.rectEnv.getMinY());
    }

    public final boolean intersects(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Coordinate lp0 = p0;
        Coordinate lp1 = p1;
        Envelope segEnv = new Envelope(lp0, lp1);
        if (!this.rectEnv.intersects(segEnv)) {
            return false;
        }
        if (this.rectEnv.intersects(lp0)) {
            return true;
        }
        if (this.rectEnv.intersects(lp1)) {
            return true;
        }
        if (lp0.compareTo(lp1) > 0) {
            Coordinate tmp = lp0;
            lp0 = lp1;
            lp1 = tmp;
        }
        boolean isSegUpwards = false;
        if (lp1.y > lp0.y) {
            isSegUpwards = true;
        }
        if (isSegUpwards) {
            this.li.computeIntersection(lp0, lp1, this.diagDown0, this.diagDown1);
        } else {
            this.li.computeIntersection(lp0, lp1, this.diagUp0, this.diagUp1);
        }
        return this.li.hasIntersection();
    }
}

