/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.triangulate.tri.Tri;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 &2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001&B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0014\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001eJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\nJ\u0012\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0082\u0004J\u0006\u0010#\u001a\u00020\u000fJ\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0017H\u0002R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u001a\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/locationtech/jts/algorithm/hull/HullTri;", "Lorg/locationtech/jts/triangulate/tri/Tri;", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "value", "", "size", "getSize", "()D", "isMarked", "", "()Z", "setMarked", "(Z)V", "setSizeToBoundary", "", "isRemoved", "boundaryIndex", "", "boundaryIndexCCW", "boundaryIndexCW", "isConnecting", "adjacent2VertexIndex", "isolatedVertexIndex", "triList", "", "lengthOfLongestEdge", "lengthOfBoundary", "compareTo", "o", "hasBoundaryTouch", "isBoundaryTouch", "index", "Companion", "kts-core"})
public final class HullTri
extends Tri
implements Comparable<HullTri> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double size;
    private boolean isMarked;

    public HullTri(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        super(p0, p1, p2);
        this.size = this.lengthOfLongestEdge();
    }

    public final double getSize() {
        return this.size;
    }

    public final boolean isMarked() {
        return this.isMarked;
    }

    public final void setMarked(boolean bl) {
        this.isMarked = bl;
    }

    public final void setSizeToBoundary() {
        this.size = this.lengthOfBoundary();
    }

    public final boolean isRemoved() {
        return !this.hasAdjacent();
    }

    public final int boundaryIndex() {
        if (this.isBoundary(0)) {
            return 0;
        }
        if (this.isBoundary(1)) {
            return 1;
        }
        return this.isBoundary(2) ? 2 : -1;
    }

    public final int boundaryIndexCCW() {
        int index = this.boundaryIndex();
        if (index < 0) {
            return -1;
        }
        int prevIndex = Tri.Companion.prev(index);
        return this.isBoundary(prevIndex) ? prevIndex : index;
    }

    public final int boundaryIndexCW() {
        int index = this.boundaryIndex();
        if (index < 0) {
            return -1;
        }
        int nextIndex = Tri.Companion.next(index);
        return this.isBoundary(nextIndex) ? nextIndex : index;
    }

    public final boolean isConnecting() {
        int adj2Index = this.adjacent2VertexIndex();
        boolean isInterior = this.isInteriorVertex(adj2Index);
        return !isInterior;
    }

    public final int adjacent2VertexIndex() {
        if (this.hasAdjacent(0) && this.hasAdjacent(1)) {
            return 1;
        }
        if (this.hasAdjacent(1) && this.hasAdjacent(2)) {
            return 2;
        }
        return this.hasAdjacent(2) && this.hasAdjacent(0) ? 0 : -1;
    }

    public final int isolatedVertexIndex(@NotNull List<HullTri> triList) {
        Intrinsics.checkNotNullParameter(triList, (String)"triList");
        for (int i = 0; i < 3; ++i) {
            if (this.degree(i, triList) > 1) continue;
            return i;
        }
        return -1;
    }

    public final double lengthOfLongestEdge() {
        return Triangle.Companion.longestSideLength(this.getP0(), this.getP1(), this.getP2());
    }

    public final double lengthOfBoundary() {
        double len = 0.0;
        for (int i = 0; i < 3; ++i) {
            if (this.hasAdjacent(i)) continue;
            len += this.getCoordinate(i).distance(this.getCoordinate(Tri.Companion.next(i)));
        }
        return len;
    }

    @Override
    public int compareTo(@NotNull HullTri o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return this.size == o.size ? -Double.compare(this.getArea(), o.getArea()) : -Double.compare(this.size, o.size);
    }

    public final boolean hasBoundaryTouch() {
        for (int i = 0; i < 3; ++i) {
            if (!this.isBoundaryTouch(i)) continue;
            return true;
        }
        return false;
    }

    private final boolean isBoundaryTouch(int index) {
        if (this.isBoundary(index)) {
            return false;
        }
        return this.isBoundary(Tri.Companion.prev(index)) ? false : !this.isInteriorVertex(index);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/algorithm/hull/HullTri$Companion;", "", "<init>", "()V", "findTri", "Lorg/locationtech/jts/algorithm/hull/HullTri;", "triList", "", "exceptTri", "Lorg/locationtech/jts/triangulate/tri/Tri;", "isAllMarked", "", "clearMarks", "", "markConnected", "triStart", "isConnected", "removedTri", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HullTri findTri(@NotNull List<HullTri> triList, @NotNull Tri exceptTri) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            Intrinsics.checkNotNullParameter((Object)exceptTri, (String)"exceptTri");
            for (HullTri tri : triList) {
                if (tri == exceptTri) continue;
                return tri;
            }
            return null;
        }

        public final boolean isAllMarked(@NotNull List<HullTri> triList) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            for (HullTri tri : triList) {
                if (tri.isMarked()) continue;
                return false;
            }
            return true;
        }

        public final void clearMarks(@NotNull List<HullTri> triList) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            for (HullTri tri : triList) {
                tri.setMarked(false);
            }
        }

        public final void markConnected(@NotNull HullTri triStart, @NotNull Tri exceptTri) {
            Intrinsics.checkNotNullParameter((Object)triStart, (String)"triStart");
            Intrinsics.checkNotNullParameter((Object)exceptTri, (String)"exceptTri");
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)triStart);
            while (!queue.isEmpty()) {
                Object t = StackKt.pop((List)queue);
                Intrinsics.checkNotNull(t);
                HullTri tri = (HullTri)t;
                tri.setMarked(true);
                for (int i = 0; i < 3; ++i) {
                    HullTri adj = (HullTri)tri.getAdjacent(i);
                    if (adj == exceptTri || adj == null || adj.isMarked()) continue;
                    queue.add((Object)adj);
                }
            }
        }

        public final boolean isConnected(@NotNull List<HullTri> triList, @NotNull HullTri removedTri) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            Intrinsics.checkNotNullParameter((Object)removedTri, (String)"removedTri");
            if (triList.isEmpty()) {
                return false;
            }
            this.clearMarks(triList);
            HullTri hullTri = this.findTri(triList, removedTri);
            if (hullTri == null) {
                return false;
            }
            HullTri triStart = hullTri;
            this.markConnected(triStart, removedTri);
            removedTri.setMarked(true);
            return this.isAllMarked(triList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

