/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.densify;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/densify/Densifier;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "distanceTolerance", "", "isValidated", "", "setDistanceTolerance", "", "setValidate", "resultGeometry", "getResultGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "DensifyTransformer", "Companion", "kts-core"})
public final class Densifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private double distanceTolerance;
    private boolean isValidated;

    public Densifier(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.isValidated = true;
    }

    public final void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public final void setValidate(boolean isValidated) {
        this.isValidated = isValidated;
    }

    @NotNull
    public final Geometry getResultGeometry() {
        return new DensifyTransformer(this.distanceTolerance, this.isValidated).transform(this.inputGeom);
    }

    @JvmStatic
    @NotNull
    public static final Geometry densify(@NotNull Geometry geom, double distanceTolerance) {
        return Companion.densify(geom, distanceTolerance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J1\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/densify/Densifier$Companion;", "", "<init>", "()V", "densify", "Lorg/locationtech/jts/geom/Geometry;", "geom", "distanceTolerance", "", "densifyPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "precModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "([Lorg/locationtech/jts/geom/Coordinate;DLorg/locationtech/jts/geom/PrecisionModel;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry densify(@NotNull Geometry geom, double distanceTolerance) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Densifier densifier = new Densifier(geom);
            densifier.setDistanceTolerance(distanceTolerance);
            return densifier.getResultGeometry();
        }

        private final Coordinate[] densifyPoints(Coordinate[] pts, double distanceTolerance, PrecisionModel precModel) {
            LineSegment seg = new LineSegment(null, null, 3, null);
            CoordinateList coordList = new CoordinateList();
            int n = pts.length - 1;
            for (int i = 0; i < n; ++i) {
                seg.p0 = pts[i];
                seg.p1 = pts[i + 1];
                coordList.add(seg.p0, false);
                double len = seg.getLength();
                if (len <= distanceTolerance) continue;
                int densifiedSegCount = (int)Math.INSTANCE.ceil(len / distanceTolerance);
                double densifiedSegLen = len / (double)densifiedSegCount;
                for (int j = 1; j < densifiedSegCount; ++j) {
                    double segFract = (double)j * densifiedSegLen / len;
                    Coordinate p = seg.pointAlong(segFract);
                    if (!Math.INSTANCE.isNaN(seg.p0.getZ()) && !Math.INSTANCE.isNaN(seg.p1.getZ())) {
                        p.setZ(seg.p0.getZ() + segFract * (seg.p1.getZ() - seg.p0.getZ()));
                    }
                    precModel.makePrecise(p);
                    coordList.add(p, false);
                }
            }
            if (!(pts.length == 0)) {
                coordList.add(pts[pts.length - 1], false);
            }
            return coordList.toCoordinateArray();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u001a\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/densify/Densifier$DensifyTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "distanceTolerance", "", "isValidated", "", "<init>", "(DZ)V", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coords", "parent", "Lorg/locationtech/jts/geom/Geometry;", "transformPolygon", "geom", "Lorg/locationtech/jts/geom/Polygon;", "transformMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "createValidArea", "roughAreaGeom", "kts-core"})
    public static final class DensifyTransformer
    extends GeometryTransformer {
        private double distanceTolerance;
        private final boolean isValidated;

        public DensifyTransformer(double distanceTolerance, boolean isValidated) {
            this.distanceTolerance = distanceTolerance;
            this.isValidated = isValidated;
        }

        public final double getDistanceTolerance() {
            return this.distanceTolerance;
        }

        public final void setDistanceTolerance(double d) {
            this.distanceTolerance = d;
        }

        @Override
        @NotNull
        protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coords, @Nullable Geometry parent) {
            CoordinateSequence coordinateSequence = coords;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            Coordinate[] inputPts = coordinateSequence.toCoordinateArray();
            Geometry geometry = parent;
            Intrinsics.checkNotNull((Object)geometry);
            Coordinate[] newPts = Companion.densifyPoints(inputPts, this.distanceTolerance, geometry.getPrecisionModel());
            if (parent instanceof LineString && newPts.length == 1) {
                newPts = new Coordinate[]{};
            }
            GeometryFactory geometryFactory = this.getFactory();
            Intrinsics.checkNotNull((Object)geometryFactory);
            return geometryFactory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        @NotNull
        protected Geometry transformPolygon(@NotNull Polygon geom, @Nullable Geometry parent) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Geometry geometry = super.transformPolygon(geom, parent);
            Intrinsics.checkNotNull((Object)geometry);
            Geometry roughGeom = geometry;
            return parent instanceof MultiPolygon ? roughGeom : this.createValidArea(roughGeom);
        }

        @Override
        @NotNull
        protected Geometry transformMultiPolygon(@NotNull MultiPolygon geom, @Nullable Geometry parent) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Geometry roughGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(roughGeom);
        }

        private final Geometry createValidArea(Geometry roughAreaGeom) {
            return !this.isValidated || roughAreaGeom.isValid() ? roughAreaGeom : roughAreaGeom.buffer(0.0);
        }
    }
}

