/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/geom/Dimension;", "", "<init>", "()V", "P", "", "L", "A", "FALSE", "TRUE", "DONTCARE", "SYM_FALSE", "", "SYM_TRUE", "SYM_DONTCARE", "SYM_P", "SYM_L", "SYM_A", "toDimensionSymbol", "dimensionValue", "toDimensionValue", "dimensionSymbol", "kts-core"})
public final class Dimension {
    @NotNull
    public static final Dimension INSTANCE = new Dimension();
    public static final int P = 0;
    public static final int L = 1;
    public static final int A = 2;
    public static final int FALSE = -1;
    public static final int TRUE = -2;
    public static final int DONTCARE = -3;
    public static final char SYM_FALSE = 'F';
    public static final char SYM_TRUE = 'T';
    public static final char SYM_DONTCARE = '*';
    public static final char SYM_P = '0';
    public static final char SYM_L = '1';
    public static final char SYM_A = '2';

    private Dimension() {
    }

    public final char toDimensionSymbol(int dimensionValue) {
        switch (dimensionValue) {
            case -1: {
                return 'F';
            }
            case -2: {
                return 'T';
            }
            case -3: {
                return '*';
            }
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
        }
        throw new IllegalArgumentException("Unknown dimension value: " + dimensionValue);
    }

    public final int toDimensionValue(char dimensionSymbol) {
        switch (Character.toUpperCase(dimensionSymbol)) {
            case 'F': {
                return -1;
            }
            case 'T': {
                return -2;
            }
            case '*': {
                return -3;
            }
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown dimension symbol: " + dimensionSymbol);
    }
}

