/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 L2\u00020\u0001:\u0001LB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0010\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u000bH\u0016J\u001a\u00104\u001a\u00020\u001a2\b\u00105\u001a\u0004\u0018\u00010\u00012\u0006\u00106\u001a\u00020/H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020;H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020<H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0017J\b\u0010@\u001a\u00020\u0000H\u0014J\b\u0010A\u001a\u000208H\u0016J\b\u0010B\u001a\u00020CH\u0014J\u0012\u0010D\u001a\u00020\u000b2\b\u0010E\u001a\u0004\u0018\u00010?H\u0014J\u001a\u0010D\u001a\u00020\u000b2\b\u0010E\u001a\u0004\u0018\u00010?2\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010J\u001a\u00020\u0000H\u0016J\b\u0010K\u001a\u00020\u0000H\u0014R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0014\u0010%\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\u0014\u0010H\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u001e\u00a8\u0006M"}, d2={"Lorg/locationtech/jts/geom/GeometryCollection;", "Lorg/locationtech/jts/geom/Geometry;", "geometries", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "([Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/GeometryFactory;)V", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "SRID", "", "([Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "getGeometries", "()[Lorg/locationtech/jts/geom/Geometry;", "setGeometries", "([Lorg/locationtech/jts/geom/Geometry;)V", "[Lorg/locationtech/jts/geom/Geometry;", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "isEmpty", "", "()Z", "dimension", "getDimension", "()I", "boundaryDimension", "getBoundaryDimension", "numGeometries", "getNumGeometries", "getGeometryN", "n", "numPoints", "getNumPoints", "geometryType", "", "getGeometryType", "()Ljava/lang/String;", "boundary", "getBoundary", "()Lorg/locationtech/jts/geom/Geometry;", "area", "", "getArea", "()D", "length", "getLength", "equalsExact", "other", "tolerance", "apply", "", "filter", "Lorg/locationtech/jts/geom/CoordinateFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "clone", "", "copyInternal", "normalize", "computeEnvelopeInternal", "Lorg/locationtech/jts/geom/Envelope;", "compareToSameClass", "o", "comp", "Lorg/locationtech/jts/geom/CoordinateSequenceComparator;", "typeCode", "getTypeCode", "reverse", "reverseInternal", "Companion", "kts-core"})
public class GeometryCollection
extends Geometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Geometry[] geometries;
    private static final long serialVersionUID = -5694727726395021467L;

    public GeometryCollection(@Nullable Geometry[] geometries, @NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        Geometry[] geometries2 = geometries;
        if (geometries2 == null) {
            geometries2 = new Geometry[]{};
        }
        this.geometries = geometries2;
    }

    @NotNull
    protected final Geometry[] getGeometries() {
        return this.geometries;
    }

    protected final void setGeometries(@NotNull Geometry[] geometryArray) {
        Intrinsics.checkNotNullParameter((Object)geometryArray, (String)"<set-?>");
        this.geometries = geometryArray;
    }

    @Deprecated(message="Use GeometryFactory instead ")
    public GeometryCollection(@Nullable Geometry[] geometries, @NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    @Override
    @Nullable
    public Coordinate getCoordinate() {
        return this.isEmpty() ? null : this.geometries[0].getCoordinate();
    }

    @Override
    @NotNull
    public Coordinate[] getCoordinates() {
        Object[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            Coordinate[] childCoordinates;
            Intrinsics.checkNotNull((Object)this.geometries[i].getCoordinates());
            for (Object coordinates[++k] : childCoordinates) {
            }
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordinates);
    }

    @Override
    public boolean isEmpty() {
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int dimension = -1;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            dimension = Math.INSTANCE.max(dimension, this.geometries[i].getDimension());
        }
        return dimension;
    }

    @Override
    public int getBoundaryDimension() {
        int dimension = -1;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            dimension = Math.INSTANCE.max(dimension, this.geometries[i].getBoundaryDimension());
        }
        return dimension;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    @NotNull
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int numPoints = 0;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            numPoints += this.geometries[i].getNumPoints();
        }
        return numPoints;
    }

    @Override
    @NotNull
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    @Nullable
    public Geometry getBoundary() {
        Geometry.Companion.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere$default(null, 1, null);
        return null;
    }

    @Override
    public double getArea() {
        double area = 0.0;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            area += this.geometries[i].getArea();
        }
        return area;
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            sum += this.geometries[i].getLength();
        }
        return sum;
    }

    @Override
    public boolean equalsExact(@Nullable Geometry other, double tolerance) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            if (this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(@NotNull CoordinateFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(@NotNull CoordinateSequenceFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (this.geometries.length == 0) {
            return;
        }
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(@NotNull GeometryFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(@NotNull GeometryComponentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    @Deprecated(message="")
    @NotNull
    public Object clone() {
        return this.copy();
    }

    @Override
    @NotNull
    protected GeometryCollection copyInternal() {
        Object[] geometries = new Geometry[this.geometries.length];
        int n = geometries.length;
        for (int i = 0; i < n; ++i) {
            geometries[i] = this.geometries[i].copy();
        }
        return new GeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geometries), this.getFactory());
    }

    @Override
    public void normalize() {
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            this.geometries[i].normalize();
        }
        ArraysKt.sort((Object[])this.geometries);
    }

    @Override
    @NotNull
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        int n = this.geometries.length;
        for (int i = 0; i < n; ++i) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return envelope;
    }

    @Override
    protected int compareToSameClass(@Nullable Object o) {
        Collection collection = ArraysKt.toList((Object[])this.geometries);
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.GeometryCollection");
        return this.compare(collection, ArraysKt.toList((Object[])((GeometryCollection)o).geometries));
    }

    @Override
    public int compareToSameClass(@Nullable Object o, @NotNull CoordinateSequenceComparator comp) {
        int i;
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.GeometryCollection");
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        for (i = 0; i < n1 && i < n2; ++i) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < n1) {
            return 1;
        }
        return i < n2 ? -1 : 0;
    }

    @Override
    protected int getTypeCode() {
        return 7;
    }

    @Override
    @NotNull
    public GeometryCollection reverse() {
        Geometry geometry = super.reverse();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.GeometryCollection");
        return (GeometryCollection)geometry;
    }

    @Override
    @NotNull
    protected GeometryCollection reverseInternal() {
        Object[] geometries = new Geometry[this.geometries.length];
        int n = geometries.length;
        for (int i = 0; i < n; ++i) {
            geometries[i] = this.geometries[i].reverse();
        }
        return new GeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geometries), this.getFactory());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/geom/GeometryCollection$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

