/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.util.GeometryEditor;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u0000 G2\u00060\u0001j\u0002`\u0002:\u0002FGB!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000eB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0014\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0006\u0010 \u001a\u00020!J\u001b\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020'J\u001b\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010#\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020+J\u001b\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010#\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u0002002\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#\u00a2\u0006\u0002\u00101J\u0014\u0010/\u001a\u0002002\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0006\u00102\u001a\u000203J\u001b\u00102\u001a\u0002032\u000e\u00104\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010#\u00a2\u0006\u0002\u00105J\u001d\u00102\u001a\u0002032\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#H\u0007\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\u0002032\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#\u00a2\u0006\u0002\u00106J\u0010\u00102\u001a\u0002032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ+\u00108\u001a\u00020-2\n\b\u0002\u00109\u001a\u0004\u0018\u0001002\u0010\b\u0002\u0010:\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010#H\u0007\u00a2\u0006\u0002\u0010;J\u0010\u00108\u001a\u00020-2\b\u00109\u001a\u0004\u0018\u00010\u001fJ\u001b\u00108\u001a\u00020-2\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#\u00a2\u0006\u0002\u0010<J\u0014\u0010=\u001a\u00020\u00172\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170?J\u001b\u0010@\u001a\u00020$2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#\u00a2\u0006\u0002\u0010AJ\u0014\u0010@\u001a\u00020$2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u000e\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\u0006J\u0012\u0010D\u001a\u0004\u0018\u00010\u00172\b\u0010E\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006H"}, d2={"Lorg/locationtech/jts/geom/GeometryFactory;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "sRID", "", "coordinateSequenceFactory", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;ILorg/locationtech/jts/geom/CoordinateSequenceFactory;)V", "SRID", "(Lorg/locationtech/jts/geom/PrecisionModel;I)V", "(Lorg/locationtech/jts/geom/CoordinateSequenceFactory;)V", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "()V", "getPrecisionModel", "()Lorg/locationtech/jts/geom/PrecisionModel;", "getSRID", "()I", "getCoordinateSequenceFactory", "()Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "toGeometry", "Lorg/locationtech/jts/geom/Geometry;", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "createPoint", "Lorg/locationtech/jts/geom/Point;", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "createMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "lineStrings", "", "Lorg/locationtech/jts/geom/LineString;", "([Lorg/locationtech/jts/geom/LineString;)Lorg/locationtech/jts/geom/MultiLineString;", "createGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "geometries", "([Lorg/locationtech/jts/geom/Geometry;)Lorg/locationtech/jts/geom/GeometryCollection;", "createMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "polygons", "Lorg/locationtech/jts/geom/Polygon;", "([Lorg/locationtech/jts/geom/Polygon;)Lorg/locationtech/jts/geom/MultiPolygon;", "createLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/LinearRing;", "createMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "point", "([Lorg/locationtech/jts/geom/Point;)Lorg/locationtech/jts/geom/MultiPoint;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/MultiPoint;", "createMultiPointFromCoords", "createPolygon", "shell", "holes", "(Lorg/locationtech/jts/geom/LinearRing;[Lorg/locationtech/jts/geom/LinearRing;)Lorg/locationtech/jts/geom/Polygon;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Polygon;", "buildGeometry", "geomList", "", "createLineString", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/LineString;", "createEmpty", "dimension", "createGeometry", "g", "CoordSeqCloneOp", "Companion", "kts-core"})
public final class GeometryFactory
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel precisionModel;
    private final int sRID;
    @NotNull
    private final CoordinateSequenceFactory coordinateSequenceFactory;
    private static final long serialVersionUID = -6820524753094095635L;

    @JvmOverloads
    public GeometryFactory(@NotNull PrecisionModel precisionModel, int sRID, @NotNull CoordinateSequenceFactory coordinateSequenceFactory) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        Intrinsics.checkNotNullParameter((Object)coordinateSequenceFactory, (String)"coordinateSequenceFactory");
        this.precisionModel = precisionModel;
        this.sRID = sRID;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
    }

    @NotNull
    public final PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public final int getSRID() {
        return this.sRID;
    }

    @NotNull
    public final CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }

    public GeometryFactory(@NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(precisionModel, SRID, GeometryFactory.Companion.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory(@NotNull CoordinateSequenceFactory coordinateSequenceFactory) {
        Intrinsics.checkNotNullParameter((Object)coordinateSequenceFactory, (String)"coordinateSequenceFactory");
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(@NotNull PrecisionModel precisionModel) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(precisionModel, 0, GeometryFactory.Companion.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    @NotNull
    public final Geometry toGeometry(@NotNull Envelope envelope) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        if (envelope.isNull()) {
            return GeometryFactory.createPoint$default(this, null, 1, null);
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return this.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getMinX() == envelope.getMaxX() || envelope.getMinY() == envelope.getMaxY()) {
            Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())};
            geometry = this.createLineString(coordinateArray);
        } else {
            Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())};
            geometry = this.createPolygon(this.createLinearRing(coordinateArray), null);
        }
        return geometry;
    }

    @NotNull
    public final Point createPoint(@Nullable Coordinate coordinate) {
        CoordinateSequence coordinateSequence;
        if (coordinate != null) {
            Coordinate[] coordinateArray = new Coordinate[]{coordinate};
            coordinateSequence = this.coordinateSequenceFactory.create(coordinateArray);
        } else {
            coordinateSequence = null;
        }
        return this.createPoint(coordinateSequence);
    }

    @JvmOverloads
    @NotNull
    public final Point createPoint(@Nullable CoordinateSequence coordinates) {
        return new Point(coordinates, this);
    }

    public static /* synthetic */ Point createPoint$default(GeometryFactory geometryFactory, CoordinateSequence coordinateSequence, int n, Object object) {
        if ((n & 1) != 0) {
            coordinateSequence = geometryFactory.coordinateSequenceFactory.create(new Coordinate[0]);
        }
        return geometryFactory.createPoint(coordinateSequence);
    }

    @NotNull
    public final MultiLineString createMultiLineString() {
        return new MultiLineString(null, this);
    }

    @NotNull
    public final MultiLineString createMultiLineString(@Nullable LineString[] lineStrings) {
        return new MultiLineString(lineStrings, this);
    }

    @NotNull
    public final GeometryCollection createGeometryCollection() {
        return new GeometryCollection(null, this);
    }

    @NotNull
    public final GeometryCollection createGeometryCollection(@Nullable Geometry[] geometries) {
        return new GeometryCollection(geometries, this);
    }

    @NotNull
    public final MultiPolygon createMultiPolygon() {
        return new MultiPolygon(null, this);
    }

    @NotNull
    public final MultiPolygon createMultiPolygon(@Nullable Polygon[] polygons) {
        return new MultiPolygon(polygons, this);
    }

    @NotNull
    public final LinearRing createLinearRing(@Nullable Coordinate[] coordinates) {
        return this.createLinearRing(coordinates != null ? this.coordinateSequenceFactory.create(coordinates) : null);
    }

    @JvmOverloads
    @NotNull
    public final LinearRing createLinearRing(@Nullable CoordinateSequence coordinates) {
        return new LinearRing(coordinates, this);
    }

    public static /* synthetic */ LinearRing createLinearRing$default(GeometryFactory geometryFactory, CoordinateSequence coordinateSequence, int n, Object object) {
        if ((n & 1) != 0) {
            coordinateSequence = geometryFactory.coordinateSequenceFactory.create(new Coordinate[0]);
        }
        return geometryFactory.createLinearRing(coordinateSequence);
    }

    @NotNull
    public final MultiPoint createMultiPoint() {
        return new MultiPoint(null, this);
    }

    @NotNull
    public final MultiPoint createMultiPoint(@Nullable Point[] point) {
        return new MultiPoint(point, this);
    }

    @Deprecated(message="Use {@link GeometryFactory#createMultiPointFromCoords} instead")
    @NotNull
    public final MultiPoint createMultiPoint(@Nullable Coordinate[] coordinates) {
        return this.createMultiPoint(coordinates != null ? this.coordinateSequenceFactory.create(coordinates) : null);
    }

    @NotNull
    public final MultiPoint createMultiPointFromCoords(@Nullable Coordinate[] coordinates) {
        return this.createMultiPoint(coordinates != null ? this.coordinateSequenceFactory.create(coordinates) : null);
    }

    @NotNull
    public final MultiPoint createMultiPoint(@Nullable CoordinateSequence coordinates) {
        if (coordinates == null) {
            return this.createMultiPoint(new Point[0]);
        }
        Object[] points = new Point[coordinates.size()];
        int n = coordinates.size();
        for (int i = 0; i < n; ++i) {
            CoordinateSequence ptSeq = this.coordinateSequenceFactory.create(1, coordinates.getDimension(), coordinates.getMeasures());
            CoordinateSequences.copy(coordinates, i, ptSeq, 0, 1);
            points[i] = this.createPoint(ptSeq);
        }
        return this.createMultiPoint((Point[])ArraysKt.requireNoNulls((Object[])points));
    }

    @JvmOverloads
    @NotNull
    public final Polygon createPolygon(@Nullable LinearRing shell, @Nullable LinearRing[] holes) {
        return new Polygon(shell, holes, this);
    }

    public static /* synthetic */ Polygon createPolygon$default(GeometryFactory geometryFactory, LinearRing linearRing, LinearRing[] linearRingArray, int n, Object object) {
        if ((n & 1) != 0) {
            linearRing = null;
        }
        if ((n & 2) != 0) {
            linearRingArray = null;
        }
        return geometryFactory.createPolygon(linearRing, linearRingArray);
    }

    @NotNull
    public final Polygon createPolygon(@Nullable CoordinateSequence shell) {
        return GeometryFactory.createPolygon$default(this, this.createLinearRing(shell), null, 2, null);
    }

    @NotNull
    public final Polygon createPolygon(@Nullable Coordinate[] shell) {
        return GeometryFactory.createPolygon$default(this, this.createLinearRing(shell), null, 2, null);
    }

    @NotNull
    public final Geometry buildGeometry(@NotNull Collection<? extends Geometry> geomList) {
        boolean isCollection;
        Intrinsics.checkNotNullParameter(geomList, (String)"geomList");
        KClass geomClass = null;
        boolean isHeterogeneous = false;
        boolean hasGeometryCollection = false;
        for (Geometry geometry : geomList) {
            KClass partClass = Reflection.getOrCreateKotlinClass(geometry.getClass());
            if (geomClass == null) {
                geomClass = partClass;
            }
            if (!Intrinsics.areEqual((Object)partClass, (Object)geomClass)) {
                isHeterogeneous = true;
            }
            if (!(geometry instanceof GeometryCollection)) continue;
            hasGeometryCollection = true;
        }
        if (geomClass == null) {
            return this.createGeometryCollection();
        }
        if (isHeterogeneous || hasGeometryCollection) {
            return this.createGeometryCollection(Companion.toGeometryArray(geomList));
        }
        Geometry geometry = geomList.iterator().next();
        boolean bl = isCollection = geomList.size() > 1;
        if (isCollection) {
            if (geometry instanceof Polygon) {
                return this.createMultiPolygon(Companion.toPolygonArray(geomList));
            }
            if (geometry instanceof LineString) {
                return this.createMultiLineString(Companion.toLineStringArray(geomList));
            }
            if (geometry instanceof Point) {
                return this.createMultiPoint(Companion.toPointArray(geomList));
            }
            Assert.shouldNeverReachHere("Unhandled class: " + Reflection.getOrCreateKotlinClass(geometry.getClass()));
        }
        return geometry;
    }

    @NotNull
    public final LineString createLineString(@Nullable Coordinate[] coordinates) {
        return this.createLineString(coordinates != null ? this.coordinateSequenceFactory.create(coordinates) : null);
    }

    @JvmOverloads
    @NotNull
    public final LineString createLineString(@Nullable CoordinateSequence coordinates) {
        return new LineString(coordinates, this);
    }

    public static /* synthetic */ LineString createLineString$default(GeometryFactory geometryFactory, CoordinateSequence coordinateSequence, int n, Object object) {
        if ((n & 1) != 0) {
            coordinateSequence = geometryFactory.coordinateSequenceFactory.create(new Coordinate[0]);
        }
        return geometryFactory.createLineString(coordinateSequence);
    }

    @NotNull
    public final Geometry createEmpty(int dimension) {
        return switch (dimension) {
            case -1 -> this.createGeometryCollection();
            case 0 -> GeometryFactory.createPoint$default(this, null, 1, null);
            case 1 -> GeometryFactory.createLineString$default(this, null, 1, null);
            case 2 -> GeometryFactory.createPolygon$default(this, null, null, 3, null);
            default -> throw new IllegalArgumentException("Invalid dimension: " + dimension);
        };
    }

    @Nullable
    public final Geometry createGeometry(@Nullable Geometry g) {
        GeometryEditor editor = new GeometryEditor(this);
        return editor.edit(g, new CoordSeqCloneOp(this.coordinateSequenceFactory));
    }

    @JvmOverloads
    @NotNull
    public final Point createPoint() {
        return GeometryFactory.createPoint$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final LinearRing createLinearRing() {
        return GeometryFactory.createLinearRing$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Polygon createPolygon(@Nullable LinearRing shell) {
        return GeometryFactory.createPolygon$default(this, shell, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Polygon createPolygon() {
        return GeometryFactory.createPolygon$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final LineString createLineString() {
        return GeometryFactory.createLineString$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Point[] toPointArray(@NotNull Collection<? extends Geometry> points) {
        return Companion.toPointArray(points);
    }

    @JvmStatic
    @Nullable
    public static final Geometry[] toGeometryArray(@Nullable Collection<? extends Geometry> geometries) {
        return Companion.toGeometryArray(geometries);
    }

    @JvmStatic
    @NotNull
    public static final LinearRing[] toLinearRingArray(@NotNull Collection<? extends Geometry> linearRings) {
        return Companion.toLinearRingArray(linearRings);
    }

    @JvmStatic
    @NotNull
    public static final LineString[] toLineStringArray(@NotNull Collection<? extends Geometry> lineStrings) {
        return Companion.toLineStringArray(lineStrings);
    }

    @JvmStatic
    @NotNull
    public static final Polygon[] toPolygonArray(@NotNull Collection<? extends Geometry> polygons) {
        return Companion.toPolygonArray(polygons);
    }

    @JvmStatic
    @NotNull
    public static final MultiPolygon[] toMultiPolygonArray(@NotNull Collection<? extends Geometry> multiPolygons) {
        return Companion.toMultiPolygonArray(multiPolygons);
    }

    @JvmStatic
    @NotNull
    public static final MultiLineString[] toMultiLineStringArray(@NotNull Collection<? extends Geometry> multiLineStrings) {
        return Companion.toMultiLineStringArray(multiLineStrings);
    }

    @JvmStatic
    @NotNull
    public static final MultiPoint[] toMultiPointArray(@NotNull Collection<? extends Geometry> multiPoints) {
        return Companion.toMultiPointArray(multiPoints);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00112\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010#J!\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010'J!\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010+J!\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00112\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00060"}, d2={"Lorg/locationtech/jts/geom/GeometryFactory$Companion;", "", "<init>", "()V", "serialVersionUID", "", "createPointFromInternalCoord", "Lorg/locationtech/jts/geom/Point;", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "exemplar", "Lorg/locationtech/jts/geom/Geometry;", "defaultCoordinateSequenceFactory", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "getDefaultCoordinateSequenceFactory", "()Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "toPointArray", "", "points", "", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/Point;", "toGeometryArray", "geometries", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/Geometry;", "toLinearRingArray", "Lorg/locationtech/jts/geom/LinearRing;", "linearRings", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/LinearRing;", "toLineStringArray", "Lorg/locationtech/jts/geom/LineString;", "lineStrings", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/LineString;", "toPolygonArray", "Lorg/locationtech/jts/geom/Polygon;", "polygons", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/Polygon;", "toMultiPolygonArray", "Lorg/locationtech/jts/geom/MultiPolygon;", "multiPolygons", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/MultiPolygon;", "toMultiLineStringArray", "Lorg/locationtech/jts/geom/MultiLineString;", "multiLineStrings", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/MultiLineString;", "toMultiPointArray", "Lorg/locationtech/jts/geom/MultiPoint;", "multiPoints", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/MultiPoint;", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nGeometryFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryFactory.kt\norg/locationtech/jts/geom/GeometryFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,652:1\n1586#2:653\n1661#2,3:654\n1586#2:659\n1661#2,3:660\n1586#2:665\n1661#2,3:666\n1586#2:671\n1661#2,3:672\n1586#2:677\n1661#2,3:678\n1586#2:683\n1661#2,3:684\n1586#2:689\n1661#2,3:690\n1586#2:695\n1661#2,3:696\n37#3,2:657\n37#3,2:663\n37#3,2:669\n37#3,2:675\n37#3,2:681\n37#3,2:687\n37#3,2:693\n37#3,2:699\n*S KotlinDebug\n*F\n+ 1 GeometryFactory.kt\norg/locationtech/jts/geom/GeometryFactory$Companion\n*L\n569#1:653\n569#1:654,3\n583#1:659\n583#1:660,3\n594#1:665\n594#1:666,3\n605#1:671\n605#1:672,3\n616#1:677\n616#1:678,3\n627#1:683\n627#1:684,3\n638#1:689\n638#1:690,3\n649#1:695\n649#1:696,3\n569#1:657,2\n583#1:663,2\n594#1:669,2\n605#1:675,2\n616#1:681,2\n627#1:687,2\n638#1:693,2\n649#1:699,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Point createPointFromInternalCoord(@NotNull Coordinate coord, @NotNull Geometry exemplar) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)exemplar, (String)"exemplar");
            exemplar.getPrecisionModel().makePrecise(coord);
            return exemplar.getFactory().createPoint(coord);
        }

        private final CoordinateSequenceFactory getDefaultCoordinateSequenceFactory() {
            return CoordinateArraySequenceFactory.Companion.instance();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Point[] toPointArray(@NotNull Collection<? extends Geometry> points) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Iterable $this$map$iv = points;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                collection.add((Point)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Point[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final Geometry[] toGeometryArray(@Nullable Collection<? extends Geometry> geometries) {
            void $this$mapTo$iv$iv;
            if (geometries == null) {
                return null;
            }
            Geometry[] geometryArray = new Geometry[geometries.size()];
            Iterable $this$map$iv = geometries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Geometry[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final LinearRing[] toLinearRingArray(@NotNull Collection<? extends Geometry> linearRings) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(linearRings, (String)"linearRings");
            Iterable $this$map$iv = linearRings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
                collection.add((LinearRing)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new LinearRing[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final LineString[] toLineStringArray(@NotNull Collection<? extends Geometry> lineStrings) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(lineStrings, (String)"lineStrings");
            Iterable $this$map$iv = lineStrings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                collection.add((LineString)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new LineString[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Polygon[] toPolygonArray(@NotNull Collection<? extends Geometry> polygons) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(polygons, (String)"polygons");
            Iterable $this$map$iv = polygons;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                collection.add((Polygon)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Polygon[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final MultiPolygon[] toMultiPolygonArray(@NotNull Collection<? extends Geometry> multiPolygons) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(multiPolygons, (String)"multiPolygons");
            Iterable $this$map$iv = multiPolygons;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.MultiPolygon");
                collection.add((MultiPolygon)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new MultiPolygon[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final MultiLineString[] toMultiLineStringArray(@NotNull Collection<? extends Geometry> multiLineStrings) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(multiLineStrings, (String)"multiLineStrings");
            Iterable $this$map$iv = multiLineStrings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.MultiLineString");
                collection.add((MultiLineString)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new MultiLineString[0]);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final MultiPoint[] toMultiPointArray(@NotNull Collection<? extends Geometry> multiPoints) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(multiPoints, (String)"multiPoints");
            Iterable $this$map$iv = multiPoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.MultiPoint");
                collection.add((MultiPoint)it);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new MultiPoint[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/geom/GeometryFactory$CoordSeqCloneOp;", "Lorg/locationtech/jts/geom/util/GeometryEditor$CoordinateSequenceOperation;", "coordinateSequenceFactory", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "<init>", "(Lorg/locationtech/jts/geom/CoordinateSequenceFactory;)V", "getCoordinateSequenceFactory", "()Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "setCoordinateSequenceFactory", "edit", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coordSeq", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    private static final class CoordSeqCloneOp
    extends GeometryEditor.CoordinateSequenceOperation {
        @NotNull
        private CoordinateSequenceFactory coordinateSequenceFactory;

        public CoordSeqCloneOp(@NotNull CoordinateSequenceFactory coordinateSequenceFactory) {
            Intrinsics.checkNotNullParameter((Object)coordinateSequenceFactory, (String)"coordinateSequenceFactory");
            this.coordinateSequenceFactory = coordinateSequenceFactory;
        }

        @NotNull
        public final CoordinateSequenceFactory getCoordinateSequenceFactory() {
            return this.coordinateSequenceFactory;
        }

        public final void setCoordinateSequenceFactory(@NotNull CoordinateSequenceFactory coordinateSequenceFactory) {
            Intrinsics.checkNotNullParameter((Object)coordinateSequenceFactory, (String)"<set-?>");
            this.coordinateSequenceFactory = coordinateSequenceFactory;
        }

        @Override
        @NotNull
        public CoordinateSequence edit(@Nullable CoordinateSequence coordSeq, @Nullable Geometry geometry) {
            CoordinateSequence coordinateSequence = coordSeq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            return this.coordinateSequenceFactory.create(coordinateSequence);
        }
    }
}

