/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Dimension;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J!\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0012J\u0019\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0086\u0002J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0016\u0010(\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0005J\u0006\u0010,\u001a\u00020\u0000J\n\u0010-\u001a\u00020\u0005H\u0096\u0080\u0004R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010$\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0011\u0010%\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001eR\u0011\u0010&\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0011\u0010'\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001e\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/geom/IntersectionMatrix;", "", "<init>", "()V", "elements", "", "(Ljava/lang/String;)V", "other", "(Lorg/locationtech/jts/geom/IntersectionMatrix;)V", "matrix", "", "", "[[I", "add", "", "im", "set", "row", "", "column", "dimensionValue", "dimensionSymbols", "setAtLeast", "minimumDimensionValue", "setAtLeastIfValid", "minimumDimensionSymbols", "setAll", "get", "isDisjoint", "", "()Z", "isIntersects", "isTouches", "dimensionOfGeometryA", "dimensionOfGeometryB", "isCrosses", "isWithin", "isContains", "isCovers", "isCoveredBy", "isEquals", "isOverlaps", "matches", "pattern", "transpose", "toString", "Companion", "kts-core"})
public final class IntersectionMatrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[][] matrix;

    public IntersectionMatrix() {
        int n = 0;
        int[][] nArrayArray = new int[3][];
        IntersectionMatrix intersectionMatrix = this;
        while (n < 3) {
            int n2 = n++;
            nArrayArray[n2] = new int[3];
        }
        intersectionMatrix.matrix = nArrayArray;
        this.setAll(-1);
    }

    public IntersectionMatrix(@NotNull String elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this();
        this.set(elements);
    }

    public IntersectionMatrix(@NotNull IntersectionMatrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this();
        this.matrix[0][0] = other.matrix[0][0];
        this.matrix[0][1] = other.matrix[0][1];
        this.matrix[0][2] = other.matrix[0][2];
        this.matrix[1][0] = other.matrix[1][0];
        this.matrix[1][1] = other.matrix[1][1];
        this.matrix[1][2] = other.matrix[1][2];
        this.matrix[2][0] = other.matrix[2][0];
        this.matrix[2][1] = other.matrix[2][1];
        this.matrix[2][2] = other.matrix[2][2];
    }

    public final void add(@NotNull IntersectionMatrix im) {
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.setAtLeast(i, j, im.get(i, j));
            }
        }
    }

    public final void set(int row, int column, int dimensionValue) {
        this.matrix[row][column] = dimensionValue;
    }

    public final void set(@NotNull String dimensionSymbols) {
        Intrinsics.checkNotNullParameter((Object)dimensionSymbols, (String)"dimensionSymbols");
        int n = ((CharSequence)dimensionSymbols).length();
        for (int i = 0; i < n; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.matrix[row][col] = Dimension.INSTANCE.toDimensionValue(dimensionSymbols.charAt(i));
        }
    }

    public final void setAtLeast(int row, int column, int minimumDimensionValue) {
        if (this.matrix[row][column] < minimumDimensionValue) {
            this.matrix[row][column] = minimumDimensionValue;
        }
    }

    public final void setAtLeastIfValid(int row, int column, int minimumDimensionValue) {
        if (row >= 0 && column >= 0) {
            this.setAtLeast(row, column, minimumDimensionValue);
        }
    }

    public final void setAtLeast(@NotNull String minimumDimensionSymbols) {
        Intrinsics.checkNotNullParameter((Object)minimumDimensionSymbols, (String)"minimumDimensionSymbols");
        int n = ((CharSequence)minimumDimensionSymbols).length();
        for (int i = 0; i < n; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.setAtLeast(row, col, Dimension.INSTANCE.toDimensionValue(minimumDimensionSymbols.charAt(i)));
        }
    }

    public final void setAll(int dimensionValue) {
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                this.matrix[ai][bi] = dimensionValue;
            }
        }
    }

    public final int get(int row, int column) {
        return this.matrix[row][column];
    }

    public final boolean isDisjoint() {
        return this.matrix[0][0] == -1 && this.matrix[0][1] == -1 && this.matrix[1][0] == -1 && this.matrix[1][1] == -1;
    }

    public final boolean isIntersects() {
        return !this.isDisjoint();
    }

    public final boolean isTouches(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA > dimensionOfGeometryB) {
            return this.isTouches(dimensionOfGeometryB, dimensionOfGeometryA);
        }
        return dimensionOfGeometryA == 2 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 1 ? this.matrix[0][0] == -1 && (Companion.isTrue(this.matrix[0][1]) || Companion.isTrue(this.matrix[1][0]) || Companion.isTrue(this.matrix[1][1])) : false;
    }

    public final boolean isCrosses(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA == 0 && dimensionOfGeometryB == 1 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 2) {
            return Companion.isTrue(this.matrix[0][0]) && Companion.isTrue(this.matrix[0][2]);
        }
        if (dimensionOfGeometryA == 1 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 1) {
            return Companion.isTrue(this.matrix[0][0]) && Companion.isTrue(this.matrix[2][0]);
        }
        return dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1 ? this.matrix[0][0] == 0 : false;
    }

    public final boolean isWithin() {
        return Companion.isTrue(this.matrix[0][0]) && this.matrix[0][2] == -1 && this.matrix[1][2] == -1;
    }

    public final boolean isContains() {
        return Companion.isTrue(this.matrix[0][0]) && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public final boolean isCovers() {
        boolean hasPointInCommon = Companion.isTrue(this.matrix[0][0]) || Companion.isTrue(this.matrix[0][1]) || Companion.isTrue(this.matrix[1][0]) || Companion.isTrue(this.matrix[1][1]);
        return hasPointInCommon && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public final boolean isCoveredBy() {
        boolean hasPointInCommon = Companion.isTrue(this.matrix[0][0]) || Companion.isTrue(this.matrix[0][1]) || Companion.isTrue(this.matrix[1][0]) || Companion.isTrue(this.matrix[1][1]);
        return hasPointInCommon && this.matrix[0][2] == -1 && this.matrix[1][2] == -1;
    }

    public final boolean isEquals(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        return dimensionOfGeometryA != dimensionOfGeometryB ? false : Companion.isTrue(this.matrix[0][0]) && this.matrix[0][2] == -1 && this.matrix[1][2] == -1 && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public final boolean isOverlaps(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA == 0 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 2) {
            return Companion.isTrue(this.matrix[0][0]) && Companion.isTrue(this.matrix[0][2]) && Companion.isTrue(this.matrix[2][0]);
        }
        return dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1 ? this.matrix[0][0] == 1 && Companion.isTrue(this.matrix[0][2]) && Companion.isTrue(this.matrix[2][0]) : false;
    }

    public final boolean matches(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (pattern.length() != 9) {
            throw new IllegalArgumentException("Should be length 9: " + pattern);
        }
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                if (Companion.matches(this.matrix[ai][bi], pattern.charAt(3 * ai + bi))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final IntersectionMatrix transpose() {
        int temp = this.matrix[1][0];
        this.matrix[1][0] = this.matrix[0][1];
        this.matrix[0][1] = temp;
        temp = this.matrix[2][0];
        this.matrix[2][0] = this.matrix[0][2];
        this.matrix[0][2] = temp;
        temp = this.matrix[2][1];
        this.matrix[2][1] = this.matrix[1][2];
        this.matrix[1][2] = temp;
        return this;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder("123456789");
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                builder.setCharAt(3 * ai + bi, Dimension.INSTANCE.toDimensionSymbol(this.matrix[ai][bi]));
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/geom/IntersectionMatrix$Companion;", "", "<init>", "()V", "isTrue", "", "actualDimensionValue", "", "matches", "requiredDimensionSymbol", "", "actualDimensionSymbols", "", "requiredDimensionSymbols", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTrue(int actualDimensionValue) {
            return actualDimensionValue >= 0 || actualDimensionValue == -2;
        }

        public final boolean matches(int actualDimensionValue, char requiredDimensionSymbol) {
            if (requiredDimensionSymbol == '*') {
                return true;
            }
            if (requiredDimensionSymbol == 'T' && (actualDimensionValue >= 0 || actualDimensionValue == -2)) {
                return true;
            }
            if (requiredDimensionSymbol == 'F' && actualDimensionValue == -1) {
                return true;
            }
            if (requiredDimensionSymbol == '0' && actualDimensionValue == 0) {
                return true;
            }
            if (requiredDimensionSymbol == '1' && actualDimensionValue == 1) {
                return true;
            }
            return requiredDimensionSymbol == '2' && actualDimensionValue == 2;
        }

        public final boolean matches(@NotNull String actualDimensionSymbols, @NotNull String requiredDimensionSymbols) {
            Intrinsics.checkNotNullParameter((Object)actualDimensionSymbols, (String)"actualDimensionSymbols");
            Intrinsics.checkNotNullParameter((Object)requiredDimensionSymbols, (String)"requiredDimensionSymbols");
            IntersectionMatrix m = new IntersectionMatrix(actualDimensionSymbols);
            return m.matches(requiredDimensionSymbols);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

