/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B'\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u000eB\u001f\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u0000H\u0014J\b\u0010\u001d\u001a\u00020\u0000H\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0014R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/geom/LinearRing;", "Lorg/locationtech/jts/geom/LineString;", "points", "Lorg/locationtech/jts/geom/CoordinateSequence;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/CoordinateSequence;Lorg/locationtech/jts/geom/GeometryFactory;)V", "", "Lorg/locationtech/jts/geom/Coordinate;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "SRID", "", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/GeometryFactory;)V", "validateConstruction", "", "isClosed", "", "()Z", "geometryType", "", "getGeometryType", "()Ljava/lang/String;", "typeCode", "getTypeCode", "()I", "copyInternal", "reverse", "reverseInternal", "Companion", "kts-core"})
public final class LinearRing
extends LineString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MINIMUM_VALID_SIZE = 3;
    private static final long serialVersionUID = -4261142084085851829L;

    public LinearRing(@Nullable CoordinateSequence points, @NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(points, factory);
        this.validateConstruction();
    }

    @Deprecated(message="Use GeometryFactory instead")
    public LinearRing(@NotNull Coordinate[] points, @NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(points, new GeometryFactory(precisionModel, SRID));
        this.validateConstruction();
    }

    private LinearRing(Coordinate[] points, GeometryFactory factory) {
        this(factory.getCoordinateSequenceFactory().create(points), factory);
    }

    private final void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("Points of LinearRing do not form a closed linestring");
        }
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        boolean bl = 1 <= n ? n < 3 : false;
        if (bl) {
            CoordinateSequence coordinateSequence2 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            throw new IllegalArgumentException("Invalid number of points in LinearRing (found " + coordinateSequence2.size() + " - must be 0 or >= 3)");
        }
    }

    @Override
    public boolean isClosed() {
        return this.isEmpty() ? true : super.isClosed();
    }

    @Override
    @NotNull
    public String getGeometryType() {
        return "LinearRing";
    }

    @Override
    protected int getTypeCode() {
        return 3;
    }

    @Override
    @NotNull
    protected LinearRing copyInternal() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return new LinearRing(coordinateSequence.copy(), this.getFactory());
    }

    @Override
    @NotNull
    public LinearRing reverse() {
        LineString lineString = super.reverse();
        Intrinsics.checkNotNull((Object)lineString, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
        return (LinearRing)lineString;
    }

    @Override
    @NotNull
    protected LinearRing reverseInternal() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq = coordinateSequence.copy();
        CoordinateSequences.reverse(seq);
        return this.getFactory().createLinearRing(seq);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geom/LinearRing$Companion;", "", "<init>", "()V", "MINIMUM_VALID_SIZE", "", "serialVersionUID", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

