/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.DD;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u0018J\u0010\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/geom/Triangle;", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "getP0", "()Lorg/locationtech/jts/geom/Coordinate;", "setP0", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getP1", "setP1", "getP2", "setP2", "inCentre", "isAcute", "", "()Z", "isCCW", "circumcentre", "centroid", "longestSideLength", "", "area", "signedArea", "area3D", "interpolateZ", "p", "Companion", "kts-core"})
public final class Triangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Coordinate p0;
    @NotNull
    private Coordinate p1;
    @NotNull
    private Coordinate p2;

    public Triangle(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    @NotNull
    public final Coordinate getP0() {
        return this.p0;
    }

    public final void setP0(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p0 = coordinate;
    }

    @NotNull
    public final Coordinate getP1() {
        return this.p1;
    }

    public final void setP1(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p1 = coordinate;
    }

    @NotNull
    public final Coordinate getP2() {
        return this.p2;
    }

    public final void setP2(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p2 = coordinate;
    }

    @NotNull
    public final Coordinate inCentre() {
        return Companion.inCentre(this.p0, this.p1, this.p2);
    }

    public final boolean isAcute() {
        return Companion.isAcute(this.p0, this.p1, this.p2);
    }

    public final boolean isCCW() {
        return Companion.isCCW(this.p0, this.p1, this.p2);
    }

    @NotNull
    public final Coordinate circumcentre() {
        return Companion.circumcentre(this.p0, this.p1, this.p2);
    }

    @NotNull
    public final Coordinate centroid() {
        return Companion.centroid(this.p0, this.p1, this.p2);
    }

    public final double longestSideLength() {
        return Companion.longestSideLength(this.p0, this.p1, this.p2);
    }

    public final double area() {
        return Companion.area(this.p0, this.p1, this.p2);
    }

    public final double signedArea() {
        return Companion.signedArea(this.p0, this.p1, this.p2);
    }

    public final double area3D() {
        return Companion.area3D(this.p0, this.p1, this.p2);
    }

    public final double interpolateZ(@Nullable Coordinate p) {
        if (p == null) {
            throw new IllegalArgumentException("Supplied point is null.");
        }
        return Companion.interpolateZ(p, this.p0, this.p1, this.p2);
    }

    @JvmStatic
    public static final boolean isCCW(@Nullable Coordinate a, @Nullable Coordinate b, @Nullable Coordinate c) {
        return Companion.isCCW(a, b, c);
    }

    @JvmStatic
    public static final boolean intersects(@Nullable Coordinate a, @Nullable Coordinate b, @Nullable Coordinate c, @Nullable Coordinate p) {
        return Companion.intersects(a, b, c, p);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Coordinate circumcentre(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.circumcentre(a, b, c);
    }

    @JvmStatic
    @NotNull
    public static final Coordinate circumcentreDD(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.circumcentreDD(a, b, c);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Coordinate inCentre(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.inCentre(a, b, c);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Coordinate centroid(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.centroid(a, b, c);
    }

    @JvmStatic
    @JvmOverloads
    public static final double length(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.length(a, b, c);
    }

    @JvmStatic
    @JvmOverloads
    public static final double longestSideLength(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        return Companion.longestSideLength(a, b, c);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J&\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0007J0\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u001e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J&\u0010\u001f\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/geom/Triangle$Companion;", "", "<init>", "()V", "isAcute", "", "a", "Lorg/locationtech/jts/geom/Coordinate;", "b", "c", "isCCW", "intersects", "p", "perpendicularBisector", "Lorg/locationtech/jts/algorithm/HCoordinate;", "circumcentre", "circumcentreDD", "det", "", "m00", "m01", "m10", "m11", "inCentre", "centroid", "length", "longestSideLength", "angleBisector", "area", "signedArea", "area3D", "interpolateZ", "v0", "v1", "v2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAcute(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (!Angle.isAcute(a, b, c)) {
                return false;
            }
            if (!Angle.isAcute(b, c, a)) {
                return false;
            }
            return Angle.isAcute(c, a, b);
        }

        @JvmStatic
        public final boolean isCCW(@Nullable Coordinate a, @Nullable Coordinate b, @Nullable Coordinate c) {
            return 1 == Orientation.index(a, b, c);
        }

        @JvmStatic
        public final boolean intersects(@Nullable Coordinate a, @Nullable Coordinate b, @Nullable Coordinate c, @Nullable Coordinate p) {
            int exteriorIndex;
            int n = exteriorIndex = this.isCCW(a, b, c) ? -1 : 1;
            if (exteriorIndex == Orientation.index(a, b, p)) {
                return false;
            }
            if (exteriorIndex == Orientation.index(b, c, p)) {
                return false;
            }
            return exteriorIndex != Orientation.index(c, a, p);
        }

        @NotNull
        public final HCoordinate perpendicularBisector(@NotNull Coordinate a, @NotNull Coordinate b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            HCoordinate l1 = new HCoordinate(a.x + dx / 2.0, a.y + dy / 2.0, 1.0);
            HCoordinate l2 = new HCoordinate(a.x - dy + dx / 2.0, a.y + dx + dy / 2.0, 1.0);
            return new HCoordinate(l1, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Coordinate circumcentre(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double cx = c.x;
            double cy = c.y;
            double ax = a.x - cx;
            double ay = a.y - cy;
            double bx = b.x - cx;
            double by = b.y - cy;
            double denom = (double)2 * this.det(ax, ay, bx, by);
            double numx = this.det(ay, ax * ax + ay * ay, by, bx * bx + by * by);
            double numy = this.det(ax, ax * ax + ay * ay, bx, bx * bx + by * by);
            double ccx = cx - numx / denom;
            double ccy = cy + numy / denom;
            return new Coordinate(ccx, ccy);
        }

        @JvmStatic
        @NotNull
        public final Coordinate circumcentreDD(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            DD ax = DD.Companion.valueOf(a.x).subtract(c.x);
            DD ay = DD.Companion.valueOf(a.y).subtract(c.y);
            DD bx = DD.Companion.valueOf(b.x).subtract(c.x);
            DD by = DD.Companion.valueOf(b.y).subtract(c.y);
            DD denom = DD.Companion.determinant(ax, ay, bx, by).multiply(2.0);
            DD asqr = ax.sqr().add(ay.sqr());
            DD bsqr = bx.sqr().add(by.sqr());
            DD numx = DD.Companion.determinant(ay, asqr, by, bsqr);
            DD numy = DD.Companion.determinant(ax, asqr, bx, bsqr);
            double ccx = DD.Companion.valueOf(c.x).subtract(numx.divide(denom)).doubleValue();
            double ccy = DD.Companion.valueOf(c.y).add(numy.divide(denom)).doubleValue();
            return new Coordinate(ccx, ccy);
        }

        private final double det(double m00, double m01, double m10, double m11) {
            return m00 * m11 - m01 * m10;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Coordinate inCentre(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double len0 = b.distance(c);
            double len1 = a.distance(c);
            double len2 = a.distance(b);
            double circum = len0 + len1 + len2;
            double inCentreX = len0 * a.x + len1 * b.x + len2 * c.x / circum;
            double inCentreY = len0 * a.y + len1 * b.y + len2 * c.y / circum;
            return new Coordinate(inCentreX, inCentreY);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Coordinate centroid(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double x = (a.x + b.x + c.x) / (double)3;
            double y = (a.y + b.y + c.y) / (double)3;
            return new Coordinate(x, y);
        }

        @JvmStatic
        @JvmOverloads
        public final double length(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return a.distance(b) + b.distance(c) + c.distance(a);
        }

        @JvmStatic
        @JvmOverloads
        public final double longestSideLength(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double lenAB = a.distance(b);
            double lenBC = b.distance(c);
            double lenCA = c.distance(a);
            double maxLen = lenAB;
            if (lenBC > maxLen) {
                maxLen = lenBC;
            }
            if (lenCA > maxLen) {
                maxLen = lenCA;
            }
            return maxLen;
        }

        @NotNull
        public final Coordinate angleBisector(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double len0 = b.distance(a);
            double len2 = b.distance(c);
            double frac = len0 / (len0 + len2);
            double dx = c.x - a.x;
            double dy = c.y - a.y;
            return new Coordinate(a.x + frac * dx, a.y + frac * dy);
        }

        @JvmOverloads
        public final double area(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return Math.INSTANCE.abs(((c.x - a.x) * (b.y - a.y) - (b.x - a.x) * (c.y - a.y)) / (double)2);
        }

        @JvmOverloads
        public final double signedArea(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return ((c.x - a.x) * (b.y - a.y) - (b.x - a.x) * (c.y - a.y)) / (double)2;
        }

        @JvmOverloads
        public final double area3D(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            double ux = b.x - a.x;
            double uy = b.y - a.y;
            double uz = b.getZ() - a.getZ();
            double vx = c.x - a.x;
            double vy = c.y - a.y;
            double vz = c.getZ() - a.getZ();
            double crossx = uy * vz - uz * vy;
            double crossy = uz * vx - ux * vz;
            double crossz = ux * vy - uy * vx;
            double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
            return Math.INSTANCE.sqrt(absSq) / (double)2;
        }

        public final double interpolateZ(@NotNull Coordinate p, @NotNull Coordinate v0, @NotNull Coordinate v1, @NotNull Coordinate v2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"v0");
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            double x0 = v0.x;
            double y0 = v0.y;
            double a = v1.x - x0;
            double b = v2.x - x0;
            double c = v1.y - y0;
            double d = v2.y - y0;
            double det = a * d - b * c;
            double dx = p.x - x0;
            double dy = p.y - y0;
            double t = (d * dx - b * dy) / det;
            double u = (-c * dx + a * dy) / det;
            return v0.getZ() + t * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

