/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\b&\u0018\u0000 32\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0003123B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u001a\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0018\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H&J\u0016\u0010%\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00052\u0006\u0010&\u001a\u00020 J\u0016\u0010'\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00052\u0006\u0010&\u001a\u00020 J\n\u0010(\u001a\u00020)H\u0096\u0080\u0004J\b\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0005H$J\b\u0010-\u001a\u00020+H'J\b\u0010.\u001a\u00020\u0000H&J \u0010/\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u0010&\u001a\u00020 H&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR<\u0010\f\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rj\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u0001`\u0010X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u00064"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence;", "Lorg/locationtech/jts/geom/CoordinateSequence;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "dimension", "", "measures", "<init>", "(II)V", "getDimension", "()I", "getMeasures", "coordRef", "Ljava/lang/ref/SoftReference;", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/legacy/SoftReference;", "getCoordRef", "()Ljava/lang/ref/SoftReference;", "setCoordRef", "(Ljava/lang/ref/SoftReference;)V", "Ljava/lang/ref/SoftReference;", "getCoordinate", "i", "getCoordinateCopy", "", "coord", "toCoordinateArray", "()[Lorg/locationtech/jts/geom/Coordinate;", "cachedCoords", "getCachedCoords", "getX", "", "index", "getY", "getOrdinate", "ordinateIndex", "setX", "value", "setY", "toString", "", "readResolve", "", "getCoordinateInternal", "clone", "copy", "setOrdinate", "ordinate", "Double", "Float", "Companion", "kts-core"})
public abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int dimension;
    private final int measures;
    @Nullable
    private transient SoftReference<Coordinate[]> coordRef;
    private static final long serialVersionUID = -3151899011275603L;

    protected PackedCoordinateSequence(int dimension, int measures) {
        this.dimension = dimension;
        this.measures = measures;
        if (this.getDimension() - this.getMeasures() < 2) {
            throw new IllegalArgumentException("Must have at least 2 spatial dimensions");
        }
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getMeasures() {
        return this.measures;
    }

    @Nullable
    protected final SoftReference<Coordinate[]> getCoordRef() {
        return this.coordRef;
    }

    protected final void setCoordRef(@Nullable SoftReference<Coordinate[]> softReference) {
        this.coordRef = softReference;
    }

    @Override
    @NotNull
    public Coordinate getCoordinate(int i) {
        Coordinate[] coords;
        Object object = coords = this.getCachedCoords();
        if (coords == null || (object = object[i]) == null) {
            object = this.getCoordinateInternal(i);
        }
        return object;
    }

    @Override
    @Nullable
    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinateInternal(i);
    }

    @Override
    public void getCoordinate(int i, @Nullable Coordinate coord) {
        Intrinsics.checkNotNull((Object)coord);
        coord.x = this.getOrdinate(i, 0);
        coord.y = this.getOrdinate(i, 1);
        if (this.hasZ()) {
            coord.setZ(this.getZ(i));
        }
        if (this.hasM()) {
            coord.setM(this.getM(i));
        }
    }

    @Override
    @NotNull
    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords;
        if (coords != null) {
            coords = this.getCachedCoords();
            return coords;
        }
        Object[] c = new Coordinate[this.size()];
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            c[i] = this.getCoordinateInternal(i);
        }
        Coordinate[] referent = (Coordinate[])ArraysKt.requireNoNulls((Object[])c);
        this.coordRef = new SoftReference<Coordinate[]>(referent);
        return referent;
    }

    private final Coordinate[] getCachedCoords() {
        Coordinate[] coordinateArray;
        if (this.coordRef != null) {
            SoftReference<Coordinate[]> softReference = this.coordRef;
            Intrinsics.checkNotNull(softReference);
            Coordinate[] coords = softReference.get();
            if (coords != null) {
                coordinateArray = coords;
            } else {
                this.coordRef = null;
                coordinateArray = null;
            }
        } else {
            coordinateArray = null;
        }
        return coordinateArray;
    }

    @Override
    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    @Override
    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    @Override
    public abstract double getOrdinate(int var1, int var2);

    public final void setX(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 0, value);
    }

    public final void setY(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 1, value);
    }

    @NotNull
    public String toString() {
        return CoordinateSequences.INSTANCE.toString(this);
    }

    @NotNull
    protected final Object readResolve() {
        this.coordRef = null;
        return this;
    }

    @NotNull
    protected abstract Coordinate getCoordinateInternal(int var1);

    @Override
    @Deprecated(message="")
    @NotNull
    public abstract Object clone();

    @Override
    @NotNull
    public abstract PackedCoordinateSequence copy();

    @Override
    public abstract void setOrdinate(int var1, int var2, double var3);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nB-\b\u0017\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000eB!\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence$Double;", "Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence;", "coords", "", "dimension", "", "measures", "<init>", "([DII)V", "", "([FII)V", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;II)V", "size", "(III)V", "rawCoordinates", "getRawCoordinates", "()[D", "setRawCoordinates", "([D)V", "getCoordinateInternal", "i", "clone", "", "copy", "getOrdinate", "", "index", "ordinate", "setOrdinate", "", "value", "expandEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "env", "Companion", "kts-core"})
    public static final class Double
    extends PackedCoordinateSequence {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private double[] rawCoordinates;
        private static final long serialVersionUID = 5777450686367912719L;

        @NotNull
        public final double[] getRawCoordinates() {
            return this.rawCoordinates;
        }

        public final void setRawCoordinates(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.rawCoordinates = dArray;
        }

        public Double(@NotNull double[] coords, int dimension, int measures) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.rawCoordinates = coords;
        }

        public Double(@NotNull float[] coords, int dimension, int measures) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            super(dimension, measures);
            this.rawCoordinates = new double[coords.length];
            int n = coords.length;
            for (int i = 0; i < n; ++i) {
                this.rawCoordinates[i] = coords[i];
            }
        }

        @JvmOverloads
        public Double(@Nullable Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            Coordinate[] coordinates2 = coordinates;
            if (coordinates2 == null) {
                coordinates2 = new Coordinate[]{};
            }
            this.rawCoordinates = new double[coordinates2.length * this.getDimension()];
            int n = coordinates2.length;
            for (int i = 0; i < n; ++i) {
                int offset = i * dimension;
                this.rawCoordinates[offset] = coordinates2[i].x;
                this.rawCoordinates[offset + 1] = coordinates2[i].y;
                if (dimension >= 3) {
                    this.rawCoordinates[offset + 2] = coordinates2[i].getOrdinate(2);
                }
                if (dimension < 4) continue;
                this.rawCoordinates[offset + 3] = coordinates2[i].getOrdinate(3);
            }
        }

        public /* synthetic */ Double(Coordinate[] coordinateArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 3;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(coordinateArray, n, n2);
        }

        public Double(int size, int dimension, int measures) {
            super(dimension, measures);
            this.rawCoordinates = new double[size * this.getDimension()];
        }

        @Override
        @NotNull
        public Coordinate getCoordinateInternal(int i) {
            double x = this.rawCoordinates[i * this.getDimension()];
            double y = this.rawCoordinates[i * this.getDimension() + 1];
            if (this.getDimension() == 2 && this.getMeasures() == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.getDimension() == 3 && this.getMeasures() == 0) {
                double z = this.rawCoordinates[i * this.getDimension() + 2];
                return new Coordinate(x, y, z);
            }
            if (this.getDimension() == 3 && this.getMeasures() == 1) {
                double m = this.rawCoordinates[i * this.getDimension() + 2];
                return new CoordinateXYM(x, y, m);
            }
            if (this.getDimension() == 4) {
                double z = this.rawCoordinates[i * this.getDimension() + 2];
                double m = this.rawCoordinates[i * this.getDimension() + 3];
                return new CoordinateXYZM(x, y, z, m);
            }
            return new Coordinate(x, y);
        }

        @Override
        public int size() {
            return this.rawCoordinates.length / this.getDimension();
        }

        @Override
        @Deprecated(message="")
        @NotNull
        public Object clone() {
            return this.copy();
        }

        @Override
        @NotNull
        public Double copy() {
            double[] dArray = Arrays.copyOf(this.rawCoordinates, this.rawCoordinates.length);
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
            double[] clone = dArray;
            return new Double(clone, this.getDimension(), this.getMeasures());
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.rawCoordinates[index * this.getDimension() + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.setCoordRef(null);
            this.rawCoordinates[index * this.getDimension() + ordinate] = value;
        }

        @Override
        @NotNull
        public Envelope expandEnvelope(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            for (int i = 0; i < this.rawCoordinates.length; i += this.getDimension()) {
                if (i + 1 >= this.rawCoordinates.length) continue;
                env.expandToInclude(this.rawCoordinates[i], this.rawCoordinates[i + 1]);
            }
            return env;
        }

        @JvmOverloads
        public Double(@Nullable Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, 0, 4, null);
        }

        @JvmOverloads
        public Double(@Nullable Coordinate[] coordinates) {
            this(coordinates, 0, 0, 6, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence$Double$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nB+\b\u0017\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000eB!\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence$Float;", "Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence;", "coords", "", "dimension", "", "measures", "<init>", "([FII)V", "", "([DII)V", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;II)V", "size", "(III)V", "rawCoordinates", "getRawCoordinates", "()[F", "setRawCoordinates", "([F)V", "getCoordinateInternal", "i", "clone", "", "copy", "getOrdinate", "", "index", "ordinate", "setOrdinate", "", "value", "expandEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "env", "Companion", "kts-core"})
    public static final class Float
    extends PackedCoordinateSequence {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private float[] rawCoordinates;
        private static final long serialVersionUID = -2902252401427938986L;

        @NotNull
        public final float[] getRawCoordinates() {
            return this.rawCoordinates;
        }

        public final void setRawCoordinates(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.rawCoordinates = fArray;
        }

        public Float(@NotNull float[] coords, int dimension, int measures) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.rawCoordinates = coords;
        }

        public Float(@NotNull double[] coords, int dimension, int measures) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            super(dimension, measures);
            this.rawCoordinates = new float[coords.length];
            int n = coords.length;
            for (int i = 0; i < n; ++i) {
                this.rawCoordinates[i] = (float)coords[i];
            }
        }

        @JvmOverloads
        public Float(@Nullable Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            Coordinate[] coordinates2 = coordinates;
            if (coordinates2 == null) {
                coordinates2 = new Coordinate[]{};
            }
            this.rawCoordinates = new float[coordinates2.length * dimension];
            int n = coordinates2.length;
            for (int i = 0; i < n; ++i) {
                int offset = i * dimension;
                this.rawCoordinates[offset] = (float)coordinates2[i].x;
                this.rawCoordinates[offset + 1] = (float)coordinates2[i].y;
                if (dimension >= 3) {
                    this.rawCoordinates[offset + 2] = (float)coordinates2[i].getOrdinate(2);
                }
                if (dimension < 4) continue;
                this.rawCoordinates[offset + 3] = (float)coordinates2[i].getOrdinate(3);
            }
        }

        public /* synthetic */ Float(Coordinate[] coordinateArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = Math.INSTANCE.max(0, n - 3);
            }
            this(coordinateArray, n, n2);
        }

        public Float(int size, int dimension, int measures) {
            super(dimension, measures);
            this.rawCoordinates = new float[size * this.getDimension()];
        }

        @Override
        @NotNull
        public Coordinate getCoordinateInternal(int i) {
            double x = this.rawCoordinates[i * this.getDimension()];
            double y = this.rawCoordinates[i * this.getDimension() + 1];
            if (this.getDimension() == 2 && this.getMeasures() == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.getDimension() == 3 && this.getMeasures() == 0) {
                double z = this.rawCoordinates[i * this.getDimension() + 2];
                return new Coordinate(x, y, z);
            }
            if (this.getDimension() == 3 && this.getMeasures() == 1) {
                double m = this.rawCoordinates[i * this.getDimension() + 2];
                return new CoordinateXYM(x, y, m);
            }
            if (this.getDimension() == 4 && this.getMeasures() == 1) {
                double z = this.rawCoordinates[i * this.getDimension() + 2];
                double m = this.rawCoordinates[i * this.getDimension() + 3];
                return new CoordinateXYZM(x, y, z, m);
            }
            return new Coordinate(x, y);
        }

        @Override
        public int size() {
            return this.rawCoordinates.length / this.getDimension();
        }

        @Override
        @Deprecated(message="")
        @NotNull
        public Object clone() {
            return this.copy();
        }

        @Override
        @NotNull
        public Float copy() {
            float[] fArray = Arrays.copyOf(this.rawCoordinates, this.rawCoordinates.length);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            float[] clone = fArray;
            return new Float(clone, this.getDimension(), this.getMeasures());
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.rawCoordinates[index * this.getDimension() + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.setCoordRef(null);
            this.rawCoordinates[index * this.getDimension() + ordinate] = (float)value;
        }

        @Override
        @NotNull
        public Envelope expandEnvelope(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            for (int i = 0; i < this.rawCoordinates.length; i += this.getDimension()) {
                if (i + 1 >= this.rawCoordinates.length) continue;
                env.expandToInclude(this.rawCoordinates[i], this.rawCoordinates[i + 1]);
            }
            return env;
        }

        @JvmOverloads
        public Float(@Nullable Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, 0, 4, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/geom/impl/PackedCoordinateSequence$Float$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

