/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.GeometricShapeFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0012\u0010\u0007\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/geom/util/SineStarFactory;", "Lorg/locationtech/jts/util/GeometricShapeFactory;", "<init>", "()V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "numArms", "", "armLengthRatio", "", "setNumArms", "", "setArmLengthRatio", "createSineStar", "Lorg/locationtech/jts/geom/Geometry;", "Companion", "kts-core"})
public final class SineStarFactory
extends GeometricShapeFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    protected int numArms;
    @JvmField
    protected double armLengthRatio;

    public SineStarFactory() {
        this.numArms = 8;
        this.armLengthRatio = 0.5;
    }

    public SineStarFactory(@Nullable GeometryFactory geomFact) {
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        super(geometryFactory);
        this.numArms = 8;
        this.armLengthRatio = 0.5;
    }

    public final void setNumArms(int numArms) {
        this.numArms = numArms;
    }

    public final void setArmLengthRatio(double armLengthRatio) {
        this.armLengthRatio = armLengthRatio;
    }

    @NotNull
    public final Geometry createSineStar() {
        Envelope env = this.getDim().getEnvelope();
        double radius = env.getWidth() / 2.0;
        double armRatio = this.armLengthRatio;
        if (armRatio < 0.0) {
            armRatio = 0.0;
        }
        if (armRatio > 1.0) {
            armRatio = 1.0;
        }
        double armMaxLen = armRatio * radius;
        double insideRadius = (1.0 - armRatio) * radius;
        double centreX = env.getMinX() + radius;
        double centreY = env.getMinY() + radius;
        Object[] pts = new Coordinate[this.getNPts() + 1];
        int iPt = 0;
        int n = this.getNPts();
        for (int i = 0; i < n; ++i) {
            double ptArcFrac = (double)i / (double)this.getNPts() * (double)this.numArms;
            double armAngFrac = ptArcFrac - Math.INSTANCE.floor(ptArcFrac);
            double armAng = java.lang.Math.PI * 2 * armAngFrac;
            double armLenFrac = (Math.INSTANCE.cos(armAng) + 1.0) / 2.0;
            double curveRadius = insideRadius + armMaxLen * armLenFrac;
            double ang = (double)i * (java.lang.Math.PI * 2 / (double)this.getNPts());
            double x = curveRadius * Math.INSTANCE.cos(ang) + centreX;
            double y = curveRadius * Math.INSTANCE.sin(ang) + centreY;
            pts[iPt++] = this.coord(x, y);
        }
        Coordinate coordinate = pts[0];
        Intrinsics.checkNotNull((Object)coordinate);
        pts[iPt] = new Coordinate(coordinate);
        LinearRing ring = this.getGeomFact().createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        return GeometryFactory.createPolygon$default(this.getGeomFact(), ring, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Geometry create(@Nullable Coordinate origin, double size, int nPts, int nArms, double armLengthRatio) {
        return Companion.create(origin, size, nPts, nArms, armLengthRatio);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/geom/util/SineStarFactory$Companion;", "", "<init>", "()V", "create", "Lorg/locationtech/jts/geom/Geometry;", "origin", "Lorg/locationtech/jts/geom/Coordinate;", "size", "", "nPts", "", "nArms", "armLengthRatio", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry create(@Nullable Coordinate origin, double size, int nPts, int nArms, double armLengthRatio) {
            SineStarFactory gsf = new SineStarFactory();
            gsf.setCentre(origin);
            gsf.setSize(size);
            gsf.setNumPoints(nPts);
            gsf.setArmLengthRatio(armLengthRatio);
            gsf.setNumArms(nArms);
            return gsf.createSineStar();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

